/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.identity;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.LevelUtil;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class MeteorSlamSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("03181ad0-e750-11ed-a05b-0242ac120003");
    protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> slamMotions;
    private final double minDistance = 6.0;

    public static float getFallDistance(SkillContainer skillContainer) {
        return ((Float)skillContainer.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.FALL_DISTANCE.get())).floatValue();
    }

    public static Builder createMeteorSlamBuilder() {
        return (Builder)((SkillBuilder)new Builder().addSlamMotion(CapabilityItem.WeaponCategories.SPEAR, (item, player) -> Animations.METEOR_SLAM).addSlamMotion(CapabilityItem.WeaponCategories.GREATSWORD, (item, player) -> Animations.METEOR_SLAM).addSlamMotion(CapabilityItem.WeaponCategories.TACHI, (item, player) -> Animations.METEOR_SLAM).addSlamMotion(CapabilityItem.WeaponCategories.LONGSWORD, (item, player) -> Animations.METEOR_SLAM).setCategory(SkillCategories.IDENTITY)).setResource(Skill.Resource.NONE);
    }

    public MeteorSlamSkill(Builder builder) {
        super(builder);
        this.slamMotions = builder.slamMotions;
    }

    @Override
    public void onInitiate(SkillContainer container) {
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.SKILL_EXECUTE_EVENT, EVENT_UUID, event -> {
            PlayerPatch<?> patt3440$temp = container.getExecutor();
            if (patt3440$temp instanceof ServerPlayerPatch) {
                Vec3 from;
                Vec3 to;
                double distance;
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)patt3440$temp;
                Skill skill = event.getSkillContainer().getSkill();
                if (skill.getCategory() != SkillCategories.BASIC_ATTACK && skill.getCategory() != SkillCategories.AIR_ATTACK) {
                    return;
                }
                if (((Player)container.getExecutor().getOriginal()).m_20096_() || ((Player)container.getExecutor().getOriginal()).m_146909_() < 40.0f) {
                    return;
                }
                CapabilityItem holdingItem = container.getExecutor().getHoldingItemCapability(InteractionHand.MAIN_HAND);
                if (!this.slamMotions.containsKey(holdingItem.getWeaponCategory())) {
                    return;
                }
                AnimationManager.AnimationAccessor<? extends StaticAnimation> slamAnimation = this.slamMotions.get(holdingItem.getWeaponCategory()).apply(holdingItem, container.getExecutor());
                if (slamAnimation == null) {
                    return;
                }
                Vec3 vec3 = ((Player)container.getExecutor().getOriginal()).m_20299_(1.0f);
                Vec3 vec31 = ((Player)container.getExecutor().getOriginal()).m_20252_(1.0f);
                Vec3 vec32 = vec3.m_82520_(vec31.f_82479_ * 50.0, vec31.f_82480_ * 50.0, vec31.f_82481_ * 50.0);
                BlockHitResult hitResult = ((Player)container.getExecutor().getOriginal()).m_9236_().m_45547_(new ClipContext(vec3, vec32, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, container.getExecutor().getOriginal()));
                if (hitResult.m_6662_() != HitResult.Type.MISS && (distance = (to = hitResult.m_82450_()).m_82554_(from = ((Player)container.getExecutor().getOriginal()).m_20182_())) > this.minDistance) {
                    container.getExecutor().playAnimationSynchronized(slamAnimation, 0.0f);
                    container.getDataManager().setDataSync((SkillDataKey)SkillDataKeys.FALL_DISTANCE.get(), Float.valueOf((float)distance), (ServerPlayer)serverPlayerPatch.getOriginal());
                    container.getDataManager().setData((SkillDataKey)SkillDataKeys.PROTECT_NEXT_FALL.get(), true);
                    event.setCanceled(true);
                }
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            if (((DamageSource)event.getDamageSource()).m_269533_(DamageTypeTags.f_268549_) && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.PROTECT_NEXT_FALL.get())).booleanValue()) {
                float stamina = container.getExecutor().getStamina();
                float damage = event.getAmount();
                event.setAmount(damage - stamina);
                event.setCanceled(true);
                container.getExecutor().setStamina(stamina - damage);
                container.getDataManager().setData((SkillDataKey)SkillDataKeys.PROTECT_NEXT_FALL.get(), false);
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID, event -> {
            if (LevelUtil.calculateLivingEntityFallDamage(event.getForgeEvent().getEntity(), event.getForgeEvent().getDamageMultiplier(), event.getForgeEvent().getDistance()) == 0) {
                container.getDataManager().setData((SkillDataKey)SkillDataKeys.PROTECT_NEXT_FALL.get(), false);
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SKILL_EXECUTE_EVENT, EVENT_UUID);
    }

    @Override
    public List<WeaponCategory> getAvailableWeaponCategories() {
        return List.copyOf(this.slamMotions.keySet());
    }

    @Override
    public boolean getCustomConsumptionTooltips(SkillBookScreen.AttributeIconList consumptionList) {
        consumptionList.add((Component)Component.m_237115_((String)"attribute.name.epicfight.stamina.consume.tooltip"), (Component)Component.m_237115_((String)"skill.epicfight.meteor_slam.consume.tooltip"), SkillBookScreen.STAMINA_TEXTURE_INFO);
        return true;
    }

    public static class Builder
    extends SkillBuilder<MeteorSlamSkill> {
        protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> slamMotions = Maps.newHashMap();

        public Builder addSlamMotion(WeaponCategory weaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, AnimationManager.AnimationAccessor<? extends StaticAnimation>> function) {
            this.slamMotions.put(weaponCategory, function);
            return this;
        }
    }
}

