/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class SwordmasterSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("a395b692-fd97-11eb-9a03-0242ac130003");
    private float speedBonus;
    private Set<WeaponCategory> availableWeaponCategories;
    @OnlyIn(value=Dist.CLIENT)
    private List<WeaponCategory> availableWeaponCategoryList;

    public static Builder createSwordMasterBuilder() {
        return (Builder)((SkillBuilder)new Builder().addAvailableWeaponCategory(CapabilityItem.WeaponCategories.UCHIGATANA, CapabilityItem.WeaponCategories.LONGSWORD, CapabilityItem.WeaponCategories.SWORD, CapabilityItem.WeaponCategories.TACHI).setCategory(SkillCategories.PASSIVE)).setResource(Skill.Resource.NONE);
    }

    public SwordmasterSkill(Builder builder) {
        super(builder);
        this.availableWeaponCategories = builder.availableWeaponCategories;
    }

    @Override
    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.speedBonus = parameters.m_128457_("speed_bonus");
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_ATTACK_SPEED_EVENT, EVENT_UUID, event -> {
            WeaponCategory heldWeaponCategory = event.getItemCapability().getWeaponCategory();
            if (this.availableWeaponCategories.contains(heldWeaponCategory)) {
                float attackSpeed = event.getAttackSpeed();
                event.setAttackSpeed(attackSpeed * (1.0f + this.speedBonus * 0.01f));
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_ATTACK_SPEED_EVENT, EVENT_UUID);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(String.format("%.0f", Float.valueOf(this.speedBonus)));
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (WeaponCategory weaponCategory : this.availableWeaponCategories) {
            sb.append(WeaponCategory.ENUM_MANAGER.toTranslated(weaponCategory));
            if (i < this.availableWeaponCategories.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        list.add(sb.toString());
        return list;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<WeaponCategory> getAvailableWeaponCategories() {
        if (this.availableWeaponCategoryList == null) {
            this.availableWeaponCategoryList = List.copyOf(this.availableWeaponCategories);
        }
        return this.availableWeaponCategoryList;
    }

    public static class Builder
    extends SkillBuilder<SwordmasterSkill> {
        protected final Set<WeaponCategory> availableWeaponCategories = Sets.newHashSet();

        public Builder addAvailableWeaponCategory(WeaponCategory ... wc) {
            this.availableWeaponCategories.addAll(Arrays.asList(wc));
            return this;
        }
    }
}

