/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.ServerAnimator;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.main.EpicFightSharedConstants;
import yesman.epicfight.model.armature.types.ToolHolderArmature;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.common.AnimatorControlPacket;
import yesman.epicfight.network.server.SPAnimatorControl;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.HurtableEntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageSources;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.TargetIndicatorCheckEvent;

public abstract class LivingEntityPatch<T extends LivingEntity>
extends HurtableEntityPatch<T> {
    protected static EntityDataAccessor<Float> STUN_SHIELD;
    protected static EntityDataAccessor<Float> MAX_STUN_SHIELD;
    protected static EntityDataAccessor<Integer> EXECUTION_RESISTANCE;
    protected static EntityDataAccessor<Boolean> AIRBORNE;
    public static final double WEIGHT_CORRECTION = 37.037;
    protected Armature armature;
    protected Animator animator;
    protected EntityState state = EntityState.DEFAULT_STATE;
    protected Vec3 lastAttackPosition;
    protected EpicFightDamageSource epicFightDamageSource;
    protected boolean isLastAttackSuccess;
    protected float lastDealDamage;
    protected AttackResult.ResultType lastAttackResultType;
    protected Entity lastTryHurtEntity;
    protected LivingEntity grapplingTarget;
    public LivingMotion currentLivingMotion = LivingMotions.IDLE;
    public LivingMotion currentCompositeMotion = LivingMotions.IDLE;
    private Style oStyle;
    private final Map<InteractionHand, Joint> parentJointOfHands = Maps.newHashMap();

    public static void initLivingEntityDataAccessor() {
        STUN_SHIELD = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        MAX_STUN_SHIELD = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        EXECUTION_RESISTANCE = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        AIRBORNE = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }

    public static void createSyncedEntityData(LivingEntity livingentity) {
        livingentity.m_20088_().m_135372_(STUN_SHIELD, (Object)Float.valueOf(0.0f));
        livingentity.m_20088_().m_135372_(MAX_STUN_SHIELD, (Object)Float.valueOf(0.0f));
        livingentity.m_20088_().m_135372_(EXECUTION_RESISTANCE, (Object)0);
        livingentity.m_20088_().m_135372_(AIRBORNE, (Object)false);
    }

    @Override
    public void onConstructed(T entityIn) {
        Animator animator;
        super.onConstructed(entityIn);
        this.armature = Armatures.getArmatureFor(this);
        this.animator = animator = EpicFightSharedConstants.getAnimator(this);
        this.initAnimator(animator);
        animator.postInit();
    }

    protected void initAnimator(Animator animator) {
        animator.getVariables().putDefaultSharedVariable(AttackAnimation.HIT_ENTITIES);
        animator.getVariables().putDefaultSharedVariable(AttackAnimation.HURT_ENTITIES);
        animator.getVariables().putDefaultSharedVariable(ActionAnimation.ACTION_ANIMATION_COORD);
        Armature armature = this.armature;
        if (armature instanceof ToolHolderArmature) {
            ToolHolderArmature toolArmature = (ToolHolderArmature)((Object)armature);
            this.setParentJointOfHand(InteractionHand.MAIN_HAND, toolArmature.rightToolJoint());
            this.setParentJointOfHand(InteractionHand.OFF_HAND, toolArmature.leftToolJoint());
        }
    }

    @Override
    public void onJoinWorld(T entity, EntityJoinLevelEvent event) {
        super.onJoinWorld(entity, event);
        if (entity.m_21172_((Attribute)EpicFightAttributes.WEIGHT.get()) == 0.0) {
            EntityDimensions entityDimensions = entity.m_6972_(net.minecraft.world.entity.Pose.STANDING);
            double weight = (double)(entityDimensions.f_20377_ * entityDimensions.f_20378_) * 37.037;
            entity.m_21051_((Attribute)EpicFightAttributes.WEIGHT.get()).m_22100_(weight);
        }
    }

    public abstract void updateMotion(boolean var1);

    public Armature getArmature() {
        return this.armature;
    }

    @Override
    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        this.oStyle = this.getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle(this);
        if (((LivingEntity)this.original).m_21223_() <= 0.0f) {
            ((LivingEntity)this.original).m_146926_(0.0f);
            AnimationPlayer animPlayer = ((Animator)this.getAnimator()).getPlayerFor(null);
            if (((LivingEntity)this.original).f_20919_ >= 19 && !animPlayer.isEmpty() && !animPlayer.isEnd()) {
                --((LivingEntity)this.original).f_20919_;
            }
        }
        this.animator.tick();
        if (this.isLogicalClient()) {
            this.clientTick(event);
        } else {
            this.serverTick(event);
        }
        if (((LivingEntity)this.original).f_20919_ == 19) {
            this.aboutToDeath();
        }
        if (!this.getEntityState().inaction() && ((LivingEntity)this.original).f_19861_ && this.isAirborneState()) {
            this.setAirborneState(false);
        }
    }

    protected void clientTick(LivingEvent.LivingTickEvent event) {
    }

    protected void serverTick(LivingEvent.LivingTickEvent event) {
    }

    public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTicks) {
        if (pose.hasTransform("Head") && this.armature.hasJoint("Head") && animation.doesHeadRotFollowEntityHead()) {
            float headRotO = ((LivingEntity)this.original).f_20884_ - ((LivingEntity)this.original).f_20886_;
            float headRot = ((LivingEntity)this.original).f_20883_ - ((LivingEntity)this.original).f_20885_;
            float partialHeadRot = MathUtils.lerpBetween(headRotO, headRot, partialTicks);
            OpenMatrix4f toOriginalRotation = new OpenMatrix4f(this.armature.getBindedTransformFor(pose, this.armature.searchJointByName("Head"))).removeScale().removeTranslation().invert();
            Vec3f xAxis = OpenMatrix4f.transform3v(toOriginalRotation, Vec3f.X_AXIS, null);
            Vec3f yAxis = OpenMatrix4f.transform3v(toOriginalRotation, Vec3f.Y_AXIS, null);
            OpenMatrix4f headRotation = OpenMatrix4f.createRotatorDeg(partialHeadRot, yAxis).rotateDeg(-((LivingEntity)this.original).m_146909_(), xAxis);
            pose.orElseEmpty("Head").frontResult(JointTransform.fromMatrix(headRotation), OpenMatrix4f::mul);
        }
    }

    public void onFall(LivingFallEvent event) {
        AssetAccessor<? extends StaticAnimation> fallAnimation;
        if (!((LivingEntity)this.getOriginal()).m_9236_().m_5776_() && this.isAirborneState() && (fallAnimation = ((Animator)this.getAnimator()).getLivingAnimation(LivingMotions.LANDING_RECOVERY, this.getHitAnimation(StunType.FALL))) != null) {
            this.playAnimationSynchronized(fallAnimation, 0.0f);
        }
        this.setAirborneState(false);
    }

    @Override
    public void onDeath(LivingDeathEvent event) {
        ((Animator)this.getAnimator()).playDeathAnimation();
        this.currentLivingMotion = LivingMotions.DEATH;
    }

    public void updateEntityState() {
        this.state = this.animator.getEntityState();
    }

    public void updateEntityState(EntityState entityState) {
        this.state = entityState;
    }

    public void cancelItemUse() {
        if (((LivingEntity)this.original).m_6117_()) {
            ((LivingEntity)this.original).m_5810_();
            ForgeEventFactory.onUseItemStop((LivingEntity)((LivingEntity)this.original), (ItemStack)((LivingEntity)this.original).m_21211_(), (int)((LivingEntity)this.original).m_21212_());
        }
    }

    public CapabilityItem getHoldingItemCapability(InteractionHand hand) {
        return EpicFightCapabilities.getItemStackCapability(((LivingEntity)this.original).m_21120_(hand));
    }

    public CapabilityItem getAdvancedHoldingItemCapability(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return this.getHoldingItemCapability(hand);
        }
        return this.isOffhandItemValid() ? this.getHoldingItemCapability(hand) : CapabilityItem.EMPTY;
    }

    public EpicFightDamageSource getDamageSource(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation, InteractionHand hand) {
        EpicFightDamageSources damageSources = EpicFightDamageSources.of(((LivingEntity)this.original).m_9236_());
        EpicFightDamageSource damagesource = damageSources.mobAttack((LivingEntity)this.original).setAnimation(animation);
        damagesource.setImpact(this.getImpact(hand));
        damagesource.setArmorNegation(this.getArmorNegation(hand));
        damagesource.setHurtItem(((LivingEntity)this.original).m_21120_(hand));
        return damagesource;
    }

    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        return AttackResult.of(this.getEntityState().attackResult(damageSource), amount);
    }

    public AttackResult tryHarm(Entity target, EpicFightDamageSource damagesource, float amount) {
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(target, LivingEntityPatch.class);
        AttackResult result = entitypatch != null ? entitypatch.tryHurt(damagesource, amount) : AttackResult.success(amount);
        return result;
    }

    @Nullable
    public EpicFightDamageSource getEpicFightDamageSource() {
        return this.epicFightDamageSource;
    }

    protected void setOffhandDamage(InteractionHand hand, ItemStack mainhandItemStack, ItemStack offhandItemStack, boolean offhandValid, Collection<AttributeModifier> mainhandAttributes, Collection<AttributeModifier> offhandAttributes) {
        if (hand == InteractionHand.MAIN_HAND) {
            return;
        }
        ((LivingEntity)this.getOriginal()).m_21008_(InteractionHand.MAIN_HAND, offhandValid ? offhandItemStack : ItemStack.f_41583_);
        ((LivingEntity)this.getOriginal()).m_21008_(InteractionHand.OFF_HAND, mainhandItemStack);
        AttributeInstance damageAttributeInstance = ((LivingEntity)this.original).m_21051_(Attributes.f_22281_);
        mainhandAttributes.forEach(arg_0 -> ((AttributeInstance)damageAttributeInstance).m_22130_(arg_0));
        offhandAttributes.forEach(arg_0 -> ((AttributeInstance)damageAttributeInstance).m_22118_(arg_0));
    }

    protected void recoverMainhandDamage(InteractionHand hand, ItemStack mainhandItemStack, ItemStack offhandItemStack, Collection<AttributeModifier> mainhandAttributes, Collection<AttributeModifier> offhandAttributes) {
        if (hand == InteractionHand.MAIN_HAND) {
            return;
        }
        ((LivingEntity)this.getOriginal()).m_21008_(InteractionHand.MAIN_HAND, mainhandItemStack);
        ((LivingEntity)this.getOriginal()).m_21008_(InteractionHand.OFF_HAND, offhandItemStack);
        AttributeInstance damageAttributeInstance = ((LivingEntity)this.original).m_21051_(Attributes.f_22281_);
        offhandAttributes.forEach(arg_0 -> ((AttributeInstance)damageAttributeInstance).m_22130_(arg_0));
        mainhandAttributes.forEach(arg_0 -> ((AttributeInstance)damageAttributeInstance).m_22118_(arg_0));
    }

    public void setLastAttackResult(AttackResult attackResult) {
        this.lastAttackResultType = attackResult.resultType;
        this.lastDealDamage = attackResult.damage;
    }

    public void setLastAttackEntity(Entity tryHurtEntity) {
        this.lastTryHurtEntity = tryHurtEntity;
    }

    protected boolean checkLastAttackSuccess(Entity target) {
        boolean success = target.m_7306_(this.lastTryHurtEntity);
        this.lastTryHurtEntity = null;
        if (success && !this.isLastAttackSuccess) {
            this.setLastAttackSuccess(true);
        }
        return success;
    }

    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        return this.checkLastAttackSuccess(target) ? new AttackResult(this.lastAttackResultType, this.lastDealDamage) : AttackResult.missed(0.0f);
    }

    public float getModifiedBaseDamage(float baseDamage) {
        return baseDamage;
    }

    public boolean onDrop(LivingDropsEvent event) {
        return false;
    }

    @Override
    public float getStunShield() {
        return ((Float)((LivingEntity)this.original).m_20088_().m_135370_(STUN_SHIELD)).floatValue();
    }

    @Override
    public void setStunShield(float value) {
        value = Math.max(value, 0.0f);
        value = Math.min(value, this.getMaxStunShield());
        ((LivingEntity)this.original).m_20088_().m_135381_(STUN_SHIELD, (Object)Float.valueOf(value));
    }

    public float getMaxStunShield() {
        return ((Float)((LivingEntity)this.original).m_20088_().m_135370_(MAX_STUN_SHIELD)).floatValue();
    }

    public void setMaxStunShield(float value) {
        value = Math.max(value, 0.0f);
        ((LivingEntity)this.original).m_20088_().m_135381_(MAX_STUN_SHIELD, (Object)Float.valueOf(value));
    }

    public int getExecutionResistance() {
        return (Integer)((LivingEntity)this.original).m_20088_().m_135370_(EXECUTION_RESISTANCE);
    }

    public void setExecutionResistance(int value) {
        int maxExecutionResistance = (int)((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.EXECUTION_RESISTANCE.get());
        value = Math.min(maxExecutionResistance, value);
        ((LivingEntity)this.original).m_20088_().m_135381_(EXECUTION_RESISTANCE, (Object)value);
    }

    @Override
    public float getWeight() {
        return (float)((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.WEIGHT.get());
    }

    public void rotateTo(float degree, float limit, boolean syncPrevRot) {
        LivingEntity entity = (LivingEntity)this.getOriginal();
        float yRot = Mth.m_14177_((float)entity.m_146908_());
        float amount = Mth.m_14036_((float)Mth.m_14177_((float)(degree - yRot)), (float)(-limit), (float)limit);
        float f1 = yRot + amount;
        if (syncPrevRot) {
            entity.f_19859_ = f1;
            entity.f_20886_ = f1;
            entity.f_20884_ = f1;
        }
        entity.m_146922_(f1);
        entity.f_20885_ = f1;
        entity.f_20883_ = f1;
    }

    public void rotateTo(Entity target, float limit, boolean syncPrevRot) {
        Vec3 playerPosition = ((LivingEntity)this.original).m_20182_();
        Vec3 targetPosition = target.m_20182_();
        float yaw = (float)MathUtils.getYRotOfVector(targetPosition.m_82546_(playerPosition));
        this.rotateTo(yaw, limit, syncPrevRot);
    }

    public LivingEntity getTarget() {
        return ((LivingEntity)this.original).m_21214_();
    }

    public float getAttackDirectionPitch() {
        float partialTicks = EpicFightSharedConstants.isPhysicalClient() ? Minecraft.m_91087_().m_91296_() : 1.0f;
        float pitch = -((LivingEntity)this.getOriginal()).m_5686_(partialTicks);
        float correct = pitch > 0.0f ? 0.03333f * (float)Math.pow(pitch, 2.0) : -0.03333f * (float)Math.pow(pitch, 2.0);
        return Mth.m_14036_((float)correct, (float)-30.0f, (float)30.0f);
    }

    public float getCameraXRot() {
        return Mth.m_14177_((float)((LivingEntity)this.original).m_146909_());
    }

    public float getCameraYRot() {
        return Mth.m_14177_((float)((LivingEntity)this.original).m_146908_());
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float yRot;
        float yRotO;
        float scale = ((LivingEntity)this.original).m_6162_() ? 0.5f : 1.0f;
        Entity entity = ((LivingEntity)this.original).m_20202_();
        if (entity instanceof LivingEntity) {
            LivingEntity ridingEntity = (LivingEntity)entity;
            yRotO = ridingEntity.f_20884_;
            yRot = ridingEntity.f_20883_;
        } else {
            yRotO = this.isLogicalClient() ? ((LivingEntity)this.original).f_20884_ : ((LivingEntity)this.original).m_146908_();
            yRot = this.isLogicalClient() ? ((LivingEntity)this.original).f_20883_ : ((LivingEntity)this.original).m_146908_();
        }
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, yRotO, yRot, partialTicks, scale, scale, scale);
    }

    public void reserveAnimation(AssetAccessor<? extends StaticAnimation> animation) {
        if (this.isLogicalClient()) {
            this.animator.reserveAnimation(animation);
        } else {
            this.handleAnimationPacket(AnimatorControlPacket.Action.RESERVE, animation, 0.0f, SPAnimatorControl::new);
        }
    }

    public void reserveAnimation(AssetAccessor<? extends StaticAnimation> animation, ServerAnimationPacketProvider packetProvider) {
        this.handleAnimationPacket(AnimatorControlPacket.Action.RESERVE, animation, 0.0f, packetProvider);
    }

    public void playAnimationInstantly(AssetAccessor<? extends StaticAnimation> animation) {
        if (this.isLogicalClient()) {
            this.animator.playAnimationInstantly(animation);
        } else {
            this.handleAnimationPacket(AnimatorControlPacket.Action.PLAY_INSTANTLY, animation, 0.0f, SPAnimatorControl::new);
        }
    }

    public void playAnimationInstantly(AssetAccessor<? extends StaticAnimation> animation, ServerAnimationPacketProvider packetProvider) {
        this.handleAnimationPacket(AnimatorControlPacket.Action.PLAY_INSTANTLY, animation, 0.0f, packetProvider);
    }

    public void playAnimation(AssetAccessor<? extends StaticAnimation> animation, float transitionTimeModifier) {
        this.animator.playAnimation(animation, transitionTimeModifier);
    }

    public void stopPlaying(AssetAccessor<? extends StaticAnimation> animation) {
        if (this.isLogicalClient()) {
            this.animator.stopPlaying(animation);
        } else {
            this.handleAnimationPacket(AnimatorControlPacket.Action.STOP, animation, -1.0f, SPAnimatorControl::new);
        }
    }

    public void playAnimation(AssetAccessor<? extends StaticAnimation> animation, float transitionTimeModifier, ServerAnimationPacketProvider packetProvider) {
        this.handleAnimationPacket(AnimatorControlPacket.Action.PLAY, animation, transitionTimeModifier, packetProvider);
    }

    public void playAnimationSynchronized(AssetAccessor<? extends StaticAnimation> animation, float transitionTimeModifier) {
        if (!this.isLogicalClient()) {
            this.handleAnimationPacket(AnimatorControlPacket.Action.PLAY, animation, transitionTimeModifier, SPAnimatorControl::new);
        }
    }

    public void playAnimationSynchronized(AssetAccessor<? extends StaticAnimation> animation, float transitionTimeModifier, ServerAnimationPacketProvider packetProvider) {
        this.handleAnimationPacket(AnimatorControlPacket.Action.PLAY, animation, transitionTimeModifier, packetProvider);
    }

    public void playAnimationInClientSide(AssetAccessor<? extends StaticAnimation> animation, float transitionTimeModifier) {
        if (this.isLogicalClient()) {
            this.animator.playAnimation(animation, transitionTimeModifier);
        } else {
            this.sendToAllPlayerTrackingMe(new SPAnimatorControl(AnimatorControlPacket.Action.PLAY, animation, ((LivingEntity)this.original).m_19879_(), transitionTimeModifier, false));
        }
    }

    public void playShootingAnimation() {
        if (this.isLogicalClient()) {
            this.animator.playShootingAnimation();
        } else {
            this.sendToAllPlayerTrackingMe(new SPAnimatorControl(AnimatorControlPacket.Action.SHOT, -1, ((LivingEntity)this.getOriginal()).m_19879_(), 0.0f, false));
        }
    }

    private void handleAnimationPacket(AnimatorControlPacket.Action action, AssetAccessor<? extends StaticAnimation> animation, float transitionTimeModifier, ServerAnimationPacketProvider packetProvider) {
        if (this.isLogicalClient()) {
            throw new IllegalStateException("Cannot send animation play packet in client side.");
        }
        switch (action) {
            case PLAY: {
                this.animator.playAnimation(animation, transitionTimeModifier);
                break;
            }
            case PLAY_INSTANTLY: {
                this.animator.playAnimationInstantly(animation);
                break;
            }
            case STOP: {
                this.animator.stopPlaying(animation);
                break;
            }
            case RESERVE: {
                this.animator.reserveAnimation(animation);
                break;
            }
            case SHOT: {
                this.animator.playShootingAnimation();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Only PLAY, PLAY_INSTANTLY, STOP and RESERVE are allowed");
            }
        }
        this.sendToAllPlayerTrackingMe(packetProvider.get(action, animation, transitionTimeModifier, this));
    }

    public void pauseAnimator(AnimatorControlPacket.Action action, boolean pause) {
        switch (action) {
            case SOFT_PAUSE: {
                this.animator.setSoftPause(pause);
                break;
            }
            case HARD_PAUSE: {
                this.animator.setHardPause(pause);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Only SOFT_PAUSE and HARD_PAUSE are allowed");
            }
        }
        if (!this.isLogicalClient()) {
            this.sendToAllPlayerTrackingMe(new SPAnimatorControl(action, -1, ((LivingEntity)this.original).m_19879_(), 0.0f, pause));
        }
    }

    public void sendToAllPlayerTrackingMe(Object packet) {
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(packet, this.original, new Object[0]);
    }

    public void resetSize(EntityDimensions size) {
        EntityDimensions entitysize1;
        EntityDimensions entitysize = ((LivingEntity)this.original).f_19815_;
        ((LivingEntity)this.original).f_19815_ = entitysize1 = size;
        if (entitysize1.f_20377_ < entitysize.f_20377_) {
            double d0 = (double)entitysize1.f_20377_ / 2.0;
            ((LivingEntity)this.original).m_20011_(new AABB(((LivingEntity)this.original).m_20185_() - d0, ((LivingEntity)this.original).m_20186_(), ((LivingEntity)this.original).m_20189_() - d0, ((LivingEntity)this.original).m_20185_() + d0, ((LivingEntity)this.original).m_20186_() + (double)entitysize1.f_20378_, ((LivingEntity)this.original).m_20189_() + d0));
        } else {
            AABB axisalignedbb = ((LivingEntity)this.original).m_20191_();
            ((LivingEntity)this.original).m_20011_(new AABB(axisalignedbb.f_82288_, axisalignedbb.f_82289_, axisalignedbb.f_82290_, axisalignedbb.f_82288_ + (double)entitysize1.f_20377_, axisalignedbb.f_82289_ + (double)entitysize1.f_20378_, axisalignedbb.f_82290_ + (double)entitysize1.f_20377_));
            if (entitysize1.f_20377_ > entitysize.f_20377_ && !((LivingEntity)this.original).m_9236_().m_5776_()) {
                float f = entitysize.f_20377_ - entitysize1.f_20377_;
                ((LivingEntity)this.original).m_6478_(MoverType.SELF, new Vec3((double)f, 0.0, (double)f));
            }
        }
    }

    @Override
    public boolean applyStun(StunType stunType, float stunTime) {
        ((LivingEntity)this.original).f_20900_ = 0.0f;
        ((LivingEntity)this.original).f_20901_ = 0.0f;
        ((LivingEntity)this.original).f_20902_ = 0.0f;
        ((LivingEntity)this.original).m_20334_(0.0, 0.0, 0.0);
        this.cancelKnockback = true;
        AssetAccessor<StaticAnimation> hitAnimation = this.getHitAnimation(stunType);
        if (hitAnimation != null) {
            this.playAnimationSynchronized(hitAnimation, stunType.hasFixedStunTime() ? 0.0f : stunTime);
            return true;
        }
        return false;
    }

    public void beginAction(ActionAnimation animation) {
    }

    public void updateHeldItem(CapabilityItem fromCap, CapabilityItem toCap, ItemStack from, ItemStack to, InteractionHand hand) {
    }

    public void updateArmor(CapabilityItem fromCap, CapabilityItem toCap, EquipmentSlot slotType) {
    }

    public void onAttackBlocked(DamageSource damageSource, LivingEntityPatch<?> blocker) {
    }

    public void onStrike(AttackAnimation animation, InteractionHand hand) {
        this.getAdvancedHoldingItemCapability(hand).onStrike(this, animation);
    }

    public void onMount(boolean isMountOrDismount, Entity ridingEntity) {
    }

    public void notifyGrapplingWarning() {
    }

    public void onDodgeSuccess(DamageSource damageSource) {
    }

    public void countHurtTime(float damageTaken) {
        ((LivingEntity)this.original).f_20898_ = damageTaken;
        ((LivingEntity)this.original).f_19802_ = 20;
        ((LivingEntity)this.original).f_20916_ = ((LivingEntity)this.original).f_20917_ = 10;
    }

    @Override
    public boolean isStunned() {
        return this.getEntityState().hurt();
    }

    public <A extends Animator> A getAnimator() {
        return (A)this.animator;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ClientAnimator getClientAnimator() {
        return (ClientAnimator)this.getAnimator();
    }

    public ServerAnimator getServerAnimator() {
        return (ServerAnimator)this.getAnimator();
    }

    public abstract AssetAccessor<? extends StaticAnimation> getHitAnimation(StunType var1);

    public void aboutToDeath() {
    }

    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getHitSound();
    }

    public SoundEvent getSwingSound(InteractionHand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getSmashingSound();
    }

    public HitParticleType getWeaponHitParticle(InteractionHand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getHitParticle();
    }

    public Collider getColliderMatching(InteractionHand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getWeaponCollider();
    }

    public int getMaxStrikes(InteractionHand hand) {
        return (int)(hand == InteractionHand.MAIN_HAND ? ((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.MAX_STRIKES.get()) : (this.isOffhandItemValid() ? ((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get()) : ((LivingEntity)this.original).m_21051_((Attribute)EpicFightAttributes.MAX_STRIKES.get()).m_22115_()));
    }

    public float getArmorNegation(InteractionHand hand) {
        return (float)(hand == InteractionHand.MAIN_HAND ? ((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()) : (this.isOffhandItemValid() ? ((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get()) : ((LivingEntity)this.original).m_21051_((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).m_22115_()));
    }

    public float getImpact(InteractionHand hand) {
        float impact;
        int i = 0;
        if (hand == InteractionHand.MAIN_HAND) {
            impact = (float)((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.IMPACT.get());
            i = ((LivingEntity)this.getOriginal()).m_21205_().getEnchantmentLevel(Enchantments.f_44980_);
        } else if (this.isOffhandItemValid()) {
            impact = (float)((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get());
            i = ((LivingEntity)this.getOriginal()).m_21206_().getEnchantmentLevel(Enchantments.f_44980_);
        } else {
            impact = (float)((LivingEntity)this.original).m_21051_((Attribute)EpicFightAttributes.IMPACT.get()).m_22115_();
        }
        return impact * (1.0f + (float)i * 0.12f);
    }

    public ItemStack getValidItemInHand(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return ((LivingEntity)this.original).m_21120_(hand);
        }
        return this.isOffhandItemValid() ? ((LivingEntity)this.original).m_21120_(hand) : ItemStack.f_41583_;
    }

    public boolean isOffhandItemValid() {
        return this.getHoldingItemCapability(InteractionHand.MAIN_HAND).checkOffhandValid(this);
    }

    public Joint getParentJointOfHand(InteractionHand hand) {
        return this.parentJointOfHands.getOrDefault(hand, this.armature.rootJoint);
    }

    public void setParentJointOfHand(InteractionHand hand, Joint joint) {
        this.parentJointOfHands.put(hand, joint);
    }

    public boolean isTargetInvulnerable(Entity target) {
        if (!target.m_6087_() || target.m_5833_()) {
            return true;
        }
        if (((LivingEntity)this.original).m_20201_() == target.m_20201_() && !target.canRiderInteract()) {
            return true;
        }
        return ((LivingEntity)this.original).m_7307_(target) && ((LivingEntity)this.original).m_5647_() != null && !((LivingEntity)this.original).m_5647_().m_6260_();
    }

    public boolean canPush(Entity entity) {
        EntityState state;
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(entity, LivingEntityPatch.class);
        if (entitypatch != null && (state = entitypatch.getEntityState()).inaction()) {
            return false;
        }
        EntityState thisState = this.getEntityState();
        return !thisState.inaction() && !entity.m_7306_((Entity)this.grapplingTarget);
    }

    public LivingEntity getGrapplingTarget() {
        return this.grapplingTarget;
    }

    public void setGrapplingTarget(LivingEntity grapplingTarget) {
        this.grapplingTarget = grapplingTarget;
    }

    public Vec3 getLastAttackPosition() {
        return this.lastAttackPosition;
    }

    public void setLastAttackPosition() {
        this.lastAttackPosition = ((LivingEntity)this.original).m_20182_();
    }

    public void setAirborneState(boolean airborne) {
        ((LivingEntity)this.original).m_20088_().m_135381_(AIRBORNE, (Object)airborne);
    }

    public boolean isAirborneState() {
        return (Boolean)((LivingEntity)this.original).m_20088_().m_135370_(AIRBORNE);
    }

    public void setLastAttackSuccess(boolean setter) {
        this.isLastAttackSuccess = setter;
    }

    public boolean isLastAttackSuccess() {
        return this.isLastAttackSuccess;
    }

    public boolean shouldMoveOnCurrentSide(ActionAnimation actionAnimation) {
        return !this.isLogicalClient();
    }

    public boolean isFirstPerson() {
        return false;
    }

    @Override
    public boolean overrideRender() {
        return true;
    }

    public boolean shouldBlockMoving() {
        return false;
    }

    public float getYRotLimit() {
        return 20.0f;
    }

    public double getXOld() {
        return ((LivingEntity)this.original).f_19790_;
    }

    public double getYOld() {
        return ((LivingEntity)this.original).f_19791_;
    }

    public double getZOld() {
        return ((LivingEntity)this.original).f_19792_;
    }

    public float getYRot() {
        return ((LivingEntity)this.original).m_146908_();
    }

    public float getYRotO() {
        return ((LivingEntity)this.original).f_19859_;
    }

    public void setYRot(float yRot) {
        ((LivingEntity)this.original).m_146922_(yRot);
    }

    public void setYRotO(float yRot) {
        ((LivingEntity)this.original).f_19859_ = yRot;
    }

    @Override
    public EntityState getEntityState() {
        return this.state;
    }

    public InteractionHand getAttackingHand() {
        Pair<AnimationPlayer, AttackAnimation> layerInfo = ((Animator)this.getAnimator()).findFor(AttackAnimation.class);
        if (layerInfo != null) {
            return ((AttackAnimation)layerInfo.getSecond()).getPhaseByTime((float)((AnimationPlayer)layerInfo.getFirst()).getElapsedTime()).hand;
        }
        return null;
    }

    public Style getOldStyle() {
        return this.oStyle;
    }

    public LivingMotion getCurrentLivingMotion() {
        return this.currentLivingMotion;
    }

    public List<LivingEntity> getCurrenltyAttackedEntities() {
        return ((Animator)this.getAnimator()).getVariables().getOrDefaultSharedVariable(AttackAnimation.HIT_ENTITIES);
    }

    public List<LivingEntity> getCurrenltyHurtEntities() {
        return ((Animator)this.getAnimator()).getVariables().getOrDefaultSharedVariable(AttackAnimation.HURT_ENTITIES);
    }

    public void removeHurtEntities() {
        ((Animator)this.getAnimator()).getVariables().getOrDefaultSharedVariable(AttackAnimation.HIT_ENTITIES).clear();
        ((Animator)this.getAnimator()).getVariables().getOrDefaultSharedVariable(AttackAnimation.HURT_ENTITIES).clear();
    }

    public abstract Faction getFaction();

    @OnlyIn(value=Dist.CLIENT)
    public boolean flashTargetIndicator(LocalPlayerPatch playerpatch) {
        TargetIndicatorCheckEvent event = new TargetIndicatorCheckEvent(playerpatch, this);
        playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.TARGET_INDICATOR_ALERT_CHECK_EVENT, event);
        return event.isCanceled();
    }

    @FunctionalInterface
    public static interface ServerAnimationPacketProvider {
        public SPAnimatorControl get(AnimatorControlPacket.Action var1, AssetAccessor<? extends StaticAnimation> var2, float var3, LivingEntityPatch<?> var4);
    }
}

