/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.boss;

import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPEntityPacket;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public interface BossPatch<T extends Entity> {
    public BossEvent getBossEvent();

    public T getOriginal();

    default public void recordBossEventOwner(ServerPlayer trackingPlayer) {
        SPEntityPacket packet = new SPEntityPacket(this.getOriginal().m_19879_());
        packet.getBuffer().writeBoolean(true);
        packet.getBuffer().m_130077_(this.getBossEvent().m_18860_());
        EpicFightNetworkManager.sendToPlayer(packet, trackingPlayer, new Object[0]);
    }

    default public void removeBossEventOwner(ServerPlayer trackingPlayer) {
        SPEntityPacket packet = new SPEntityPacket(this.getOriginal().m_19879_());
        packet.getBuffer().writeBoolean(false);
        packet.getBuffer().m_130077_(this.getBossEvent().m_18860_());
        EpicFightNetworkManager.sendToPlayer(packet, trackingPlayer, new Object[0]);
    }

    default public <P extends LivingEntityPatch<?>> P cast() {
        return (P)((LivingEntityPatch)((Object)this));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void processOwnerRecordPacket(FriendlyByteBuf buffer) {
        boolean addOperation = buffer.readBoolean();
        UUID eventUUID = buffer.m_130259_();
        if (addOperation) {
            ClientEngine.getInstance().renderEngine.addBossEventOwner(eventUUID, this);
        } else {
            ClientEngine.getInstance().renderEngine.removeBossEventOwner(eventUUID, this);
        }
    }
}

