/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.network.server.SPEntityPacket;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

public class EndermanPatch
extends MobPatch<EnderMan> {
    private static final UUID SPEED_MODIFIER_RAGE_UUID = UUID.fromString("dc362d1a-8424-11ec-a8a3-0242ac120002");
    private static final AttributeModifier SPEED_MODIFIER_RAGE = new AttributeModifier(SPEED_MODIFIER_RAGE_UUID, "Rage speed bonus", 0.1, AttributeModifier.Operation.ADDITION);
    private boolean onRage;
    private Goal normalAttacks;
    private Goal teleportAttacks;
    private Goal rageAttacks;
    private Goal rageTargeting;

    public EndermanPatch() {
        super(Factions.ENDERMAN);
    }

    @Override
    public void onJoinWorld(EnderMan enderman, EntityJoinLevelEvent event) {
        if (enderman.m_9236_().m_46472_() == Level.f_46430_ && EpicFightGameRules.NO_MOBS_IN_BOSSFIGHT.getRuleValue(enderman.m_9236_()).booleanValue() && enderman.m_20182_().m_165925_() < 40000.0) {
            event.setCanceled(true);
        }
        super.onJoinWorld(enderman, event);
    }

    @Override
    public void onStartTracking(ServerPlayer trackingPlayer) {
        if (this.isRaging()) {
            SPEntityPacket packet = new SPEntityPacket(((EnderMan)this.original).m_19879_());
            EpicFightNetworkManager.sendToPlayer(packet, trackingPlayer, new Object[0]);
        }
    }

    @Override
    public void processEntityPacket(FriendlyByteBuf buf) {
        ClientAnimator animator = this.getClientAnimator();
        animator.addLivingAnimation(LivingMotions.IDLE, Animations.ENDERMAN_RAGE_IDLE);
        animator.addLivingAnimation(LivingMotions.WALK, Animations.ENDERMAN_RAGE_WALK);
        animator.setCurrentMotionsAsDefault();
    }

    public static void initAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.f_20566_, (Attribute)EpicFightAttributes.STUN_ARMOR.get(), 8.0);
        event.add(EntityType.f_20566_, (Attribute)EpicFightAttributes.IMPACT.get(), 1.8);
    }

    @Override
    protected void initAI() {
        super.initAI();
        this.normalAttacks = new AnimatedAttackGoal<EndermanPatch>(this, MobCombatBehaviors.ENDERMAN.build(this));
        this.teleportAttacks = new EndermanTeleportMove(this, MobCombatBehaviors.ENDERMAN_TELEPORT.build(this));
        this.rageAttacks = new AnimatedAttackGoal<EndermanPatch>(this, MobCombatBehaviors.ENDERMAN_RAGE.build(this));
        this.rageTargeting = new NearestAttackableTargetGoal((Mob)this.original, Player.class, true);
        ((EnderMan)this.original).f_21345_.m_25352_(1, (Goal)new TargetChasingGoal(this, (PathfinderMob)this.getOriginal(), 0.75, false));
        if (this.isRaging()) {
            ((EnderMan)this.original).f_21346_.m_25352_(3, this.rageTargeting);
            ((EnderMan)this.original).f_21345_.m_25352_(1, this.rageAttacks);
        } else {
            ((EnderMan)this.original).f_21345_.m_25352_(1, this.normalAttacks);
            ((EnderMan)this.original).f_21345_.m_25352_(0, this.teleportAttacks);
        }
    }

    @Override
    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation(LivingMotions.DEATH, Animations.ENDERMAN_DEATH);
        animator.addLivingAnimation(LivingMotions.WALK, Animations.ENDERMAN_WALK);
        animator.addLivingAnimation(LivingMotions.IDLE, Animations.ENDERMAN_IDLE);
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonMobUpdateMotion(considerInaction);
    }

    @Override
    public void serverTick(LivingEvent.LivingTickEvent event) {
        super.serverTick(event);
        if (this.isRaging() && !this.onRage && ((EnderMan)this.original).f_19797_ > 5) {
            this.toRaging();
        } else if (this.onRage && !this.isRaging()) {
            this.toNormal();
        }
    }

    @Override
    public void tick(LivingEvent.LivingTickEvent event) {
        if (((EnderMan)this.original).m_21223_() <= 0.0f) {
            ((EnderMan)this.original).m_146926_(0.0f);
        }
        super.tick(event);
    }

    @Override
    public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTicks) {
        super.poseTick(animation, pose, elapsedTime, partialTicks);
        if (this.isRaging() && pose.hasTransform("Head_Top")) {
            pose.orElseEmpty("Head_Top").frontResult(JointTransform.translation(new Vec3f(0.0f, 0.25f, 0.0f)), OpenMatrix4f::mul);
        }
    }

    @Override
    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        if (!((EnderMan)this.original).m_9236_().m_5776_() && damageSource.m_7639_() != null && !this.isRaging()) {
            EpicFightDamageSource extDamageSource = null;
            if (damageSource instanceof EpicFightDamageSource) {
                extDamageSource = (EpicFightDamageSource)damageSource;
            }
            if (extDamageSource == null || extDamageSource.getStunType() != StunType.HOLD) {
                int percentage;
                int n = percentage = this.getServerAnimator().getPlayerFor(null).getAnimation() instanceof AttackAnimation ? 10 : 3;
                if (((EnderMan)this.original).m_217043_().m_188503_(percentage) == 0) {
                    for (int i = 0; i < 9; ++i) {
                        if (!((EnderMan)this.original).m_32529_()) continue;
                        if (damageSource.m_7639_() instanceof LivingEntity) {
                            ((EnderMan)this.original).m_6703_((LivingEntity)damageSource.m_7639_());
                        }
                        if (this.state.inaction()) {
                            this.playAnimationSynchronized(Animations.ENDERMAN_TP_EMERGENCE, 0.0f);
                        }
                        return AttackResult.blocked(amount);
                    }
                }
            }
        }
        return super.tryHurt(damageSource, amount);
    }

    public boolean isRaging() {
        return ((EnderMan)this.original).m_21223_() / ((EnderMan)this.original).m_21233_() < 0.33f;
    }

    protected void toRaging() {
        this.onRage = true;
        this.playAnimationSynchronized(Animations.ENDERMAN_CONVERT_RAGE, 0.0f);
        if (!((EnderMan)this.original).m_21525_()) {
            ((EnderMan)this.original).f_21345_.m_25363_(this.normalAttacks);
            ((EnderMan)this.original).f_21345_.m_25363_(this.teleportAttacks);
            ((EnderMan)this.original).f_21345_.m_25352_(1, this.rageAttacks);
            ((EnderMan)this.original).f_21346_.m_25352_(3, this.rageTargeting);
            ((EnderMan)this.original).m_20088_().m_135381_(EnderMan.f_32473_, (Object)true);
            ((EnderMan)this.original).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 120000));
            ((EnderMan)this.original).m_21051_(Attributes.f_22279_).m_22118_(SPEED_MODIFIER_RAGE);
            SPChangeLivingMotion msg = new SPChangeLivingMotion(((EnderMan)this.original).m_19879_(), true).putPair(LivingMotions.IDLE, Animations.ENDERMAN_RAGE_IDLE).putPair(LivingMotions.WALK, Animations.ENDERMAN_RAGE_WALK);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(msg, this.original, new Object[0]);
        }
    }

    protected void toNormal() {
        this.onRage = false;
        if (!((EnderMan)this.original).m_21525_()) {
            ((EnderMan)this.original).f_21345_.m_25352_(1, this.normalAttacks);
            ((EnderMan)this.original).f_21345_.m_25352_(0, this.teleportAttacks);
            ((EnderMan)this.original).f_21345_.m_25363_(this.rageAttacks);
            ((EnderMan)this.original).f_21346_.m_25363_(this.rageTargeting);
            if (((EnderMan)this.original).m_5448_() == null) {
                ((EnderMan)this.original).m_20088_().m_135381_(EnderMan.f_32473_, (Object)false);
            }
            ((EnderMan)this.original).m_21195_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get());
            ((EnderMan)this.original).m_21051_(Attributes.f_22279_).m_22130_(SPEED_MODIFIER_RAGE);
            SPChangeLivingMotion msg = new SPChangeLivingMotion(((EnderMan)this.original).m_19879_(), true).putPair(LivingMotions.IDLE, Animations.ENDERMAN_IDLE).putPair(LivingMotions.WALK, Animations.ENDERMAN_WALK);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(msg, this.original, new Object[0]);
        }
    }

    @Override
    public void aboutToDeath() {
        ((EnderMan)this.original).m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        if (this.isLogicalClient()) {
            for (int i = 0; i < 100; ++i) {
                RandomSource rand = ((EnderMan)this.original).m_217043_();
                Vec3f vec = new Vec3f(rand.m_188502_(), rand.m_188502_(), rand.m_188502_());
                vec.normalize().scale(0.5f);
                Minecraft minecraft = Minecraft.m_91087_();
                minecraft.f_91061_.m_107370_((ParticleOptions)EpicFightParticles.ENDERMAN_DEATH_EMIT.get(), ((EnderMan)this.original).m_20185_(), ((EnderMan)this.original).m_20186_() + (double)(((EnderMan)this.original).m_6972_((net.minecraft.world.entity.Pose)net.minecraft.world.entity.Pose.STANDING).f_20378_ / 2.0f), ((EnderMan)this.original).m_20189_(), (double)vec.x, (double)vec.y, (double)vec.z);
            }
        }
        super.aboutToDeath();
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        switch (stunType) {
            case SHORT: {
                return Animations.ENDERMAN_HIT_SHORT;
            }
            case LONG: {
                return Animations.ENDERMAN_HIT_LONG;
            }
            case HOLD: {
                return Animations.ENDERMAN_HIT_SHORT;
            }
            case KNOCKDOWN: {
                return Animations.ENDERMAN_NEUTRALIZED;
            }
            case NEUTRALIZE: {
                return Animations.ENDERMAN_NEUTRALIZED;
            }
        }
        return null;
    }

    static class EndermanTeleportMove
    extends AnimatedAttackGoal<EndermanPatch> {
        private int waitingCounter;
        private int delayCounter;
        private CombatBehaviors.Behavior<EndermanPatch> move;

        public EndermanTeleportMove(EndermanPatch mobpatch, CombatBehaviors<EndermanPatch> mobAttacks) {
            super(mobpatch, mobAttacks);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean m_8036_() {
            this.combatBehaviors.tick();
            if (super.m_8036_()) {
                this.move = this.combatBehaviors.selectRandomBehaviorSeries();
                return this.move != null;
            }
            return false;
        }

        public boolean m_8045_() {
            boolean waitExpired;
            boolean bl = waitExpired = this.waitingCounter <= 100;
            if (!waitExpired) {
                this.waitingCounter = 500;
            }
            return this.checkTargetValid() && !((EndermanPatch)this.mobpatch).getEntityState().hurt() && !((EndermanPatch)this.mobpatch).getEntityState().inaction() && waitExpired;
        }

        public void m_8056_() {
            this.delayCounter = 20 + ((EnderMan)((EndermanPatch)this.mobpatch).getOriginal()).m_217043_().m_188503_(5);
            this.waitingCounter = 0;
        }

        public void m_8041_() {
            this.move = null;
        }

        @Override
        public void m_8037_() {
            Mob mob = (Mob)((EndermanPatch)this.mobpatch).getOriginal();
            LivingEntity target = mob.m_5448_();
            mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (this.delayCounter-- < 0 && !((EndermanPatch)this.mobpatch).getEntityState().inaction()) {
                Vec3f vec = new Vec3f((float)(mob.m_20185_() - target.m_20185_()), 0.0f, (float)(mob.m_20189_() - target.m_20189_()));
                vec.normalize().scale(1.414f);
                boolean flag = mob.m_20984_(target.m_20185_() + (double)vec.x, target.m_20186_(), target.m_20189_() + (double)vec.z, true);
                if (flag) {
                    ((EndermanPatch)this.mobpatch).rotateTo((Entity)target, 360.0f, true);
                    this.move.execute((EndermanPatch)this.mobpatch);
                    mob.m_9236_().m_6263_(null, mob.f_19854_, mob.f_19855_, mob.f_19856_, SoundEvents.f_11852_, mob.m_5720_(), 1.0f, 1.0f);
                    mob.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                    this.waitingCounter = 0;
                } else {
                    ++this.waitingCounter;
                }
            }
        }
    }
}

