/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPEntityPacket;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.behavior.AnimatedCombatBehavior;
import yesman.epicfight.world.entity.ai.behavior.MoveToTargetSinkStopInaction;
import yesman.epicfight.world.entity.ai.brain.BrainRecomposer;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class PiglinPatch
extends HumanoidMobPatch<Piglin> {
    public PiglinPatch() {
        super(Factions.PIGLINS);
    }

    public static void initAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.f_20511_, (Attribute)EpicFightAttributes.IMPACT.get(), 1.0);
    }

    @Override
    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation(LivingMotions.IDLE, Animations.PIGLIN_IDLE);
        animator.addLivingAnimation(LivingMotions.FALL, Animations.BIPED_FALL);
        animator.addLivingAnimation(LivingMotions.MOUNT, Animations.BIPED_MOUNT);
        animator.addLivingAnimation(LivingMotions.CELEBRATE, AnimationManager.byId(Animations.PIGLIN_CELEBRATE1.id() + ((Piglin)this.original).m_217043_().m_188503_(3)));
        animator.addLivingAnimation(LivingMotions.ADMIRE, Animations.PIGLIN_ADMIRE);
        animator.addLivingAnimation(LivingMotions.WALK, Animations.PIGLIN_WALK);
        animator.addLivingAnimation(LivingMotions.CHASE, Animations.PIGLIN_WALK);
        animator.addLivingAnimation(LivingMotions.DEATH, Animations.PIGLIN_DEATH);
        animator.addLivingAnimation(LivingMotions.RELOAD, Animations.BIPED_CROSSBOW_RELOAD);
        animator.addLivingAnimation(LivingMotions.AIM, Animations.BIPED_CROSSBOW_AIM);
        animator.addLivingAnimation(LivingMotions.SHOT, Animations.BIPED_CROSSBOW_SHOT);
    }

    @Override
    public void onStartTracking(ServerPlayer trackingPlayer) {
        if (((Piglin)this.original).m_6162_()) {
            SPEntityPacket packet = new SPEntityPacket(((Piglin)this.original).m_19879_());
            EpicFightNetworkManager.sendToPlayer(packet, trackingPlayer, new Object[0]);
        }
        super.onStartTracking(trackingPlayer);
    }

    @Override
    public void processEntityPacket(FriendlyByteBuf buf) {
        ClientAnimator animator = this.getClientAnimator();
        animator.addLivingAnimation(LivingMotions.WALK, Animations.BIPED_RUN);
        animator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        if (((Piglin)this.getOriginal()).m_21206_().m_204117_(ItemTags.f_13151_)) {
            this.currentLivingMotion = LivingMotions.ADMIRE;
        } else if (((Piglin)this.original).m_34771_()) {
            this.currentLivingMotion = LivingMotions.CELEBRATE;
        } else {
            super.commonAggressiveRangedMobUpdateMotion(considerInaction);
        }
    }

    @Override
    protected void selectGoalToRemove(Set<Goal> toRemove) {
        BrainRecomposer.removeBehavior(((Piglin)this.original).m_6274_(), Activity.f_37988_, 13, MeleeAttack.class);
    }

    @Override
    public void setAIAsInfantry(boolean holdingRanedWeapon) {
        CombatBehaviors.Builder<HumanoidMobPatch<?>> builder = this.getHoldingItemWeaponMotionBuilder();
        BrainRecomposer.recomposePiglinBrain(((Piglin)this.original).m_6274_(), builder != null ? new AnimatedCombatBehavior<PiglinPatch>(this, builder.build(this)) : null, new MoveToTargetSinkStopInaction());
    }

    @Override
    public void setAIAsMounted(Entity ridingEntity) {
    }
}

