/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.mob.WitherSkeletonPatch;
import yesman.epicfight.world.capabilities.projectile.ProjectilePatch;
import yesman.epicfight.world.entity.EpicFightEntities;
import yesman.epicfight.world.entity.WitherSkeletonMinion;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

public class WitherSkullPatch
extends ProjectilePatch<WitherSkull> {
    @Override
    public void onJoinWorld(WitherSkull projectileEntity, EntityJoinLevelEvent event) {
        super.onJoinWorld(projectileEntity, event);
        this.impact = 1.0f;
    }

    @Override
    protected void setMaxStrikes(WitherSkull projectileEntity, int maxStrikes) {
    }

    @Override
    public boolean onProjectileImpact(ProjectileImpactEvent event) {
        HitResult hitResult = event.getRayTraceResult();
        if (!(hitResult instanceof EntityHitResult)) {
            Level level = event.getProjectile().m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (Math.random() < 0.2) {
                    Vec3 location = event.getRayTraceResult().m_82450_();
                    BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(location.f_82479_, location.f_82480_, location.f_82481_);
                    Projectile projectile = event.getProjectile();
                    EntityType entityType = (EntityType)EpicFightEntities.WITHER_SKELETON_MINION.get();
                    if (NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.m_21752_((EntityType)entityType), (LevelReader)serverLevel, (BlockPos)blockpos, (EntityType)entityType) && SpawnPlacements.m_217074_((EntityType)entityType, (ServerLevelAccessor)serverLevel, (MobSpawnType)MobSpawnType.REINFORCEMENT, (BlockPos)blockpos, (RandomSource)serverLevel.f_46441_) && !EpicFightGameRules.NO_MOBS_IN_BOSSFIGHT.getRuleValue((Level)serverLevel).booleanValue()) {
                        WitherBoss summoner = projectile.m_19749_() instanceof WitherBoss ? (WitherBoss)projectile.m_19749_() : null;
                        WitherSkeletonMinion witherskeletonminion = new WitherSkeletonMinion((Level)serverLevel, summoner, projectile.m_20185_(), projectile.m_20186_() + 0.1, projectile.m_20189_());
                        witherskeletonminion.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_((BlockPos)blockpos), MobSpawnType.REINFORCEMENT, null, null);
                        witherskeletonminion.m_146922_(projectile.m_146908_() - 180.0f);
                        serverLevel.m_7967_((Entity)witherskeletonminion);
                        EpicFightCapabilities.getParameterizedEntityPatch((Entity)witherskeletonminion, WitherSkeletonMinion.class, WitherSkeletonPatch.class).ifPresent(witherskeletonpatch -> witherskeletonpatch.playAnimationInstantly(Animations.WITHER_SKELETON_SPECIAL_SPAWN));
                    }
                }
            }
        } else {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            return entityHitResult.m_82443_() instanceof WitherSkeletonMinion;
        }
        return false;
    }
}

