/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.spirit;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.klikli_dev.occultism.api.common.data.WorkAreaSize;
import com.klikli_dev.occultism.common.container.spirit.SpiritContainer;
import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.ISkinnedCreatureMixin;
import com.klikli_dev.occultism.common.item.spirit.BookOfCallingItem;
import com.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.klikli_dev.occultism.registry.OccultismSounds;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrain;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.NotNull;

public abstract class SpiritEntity
extends TamableAnimal
implements ISkinnedCreatureMixin,
MenuProvider,
SmartBrainOwner<SpiritEntity> {
    public static final EntityDataAccessor<Integer> SKIN = SynchedEntityData.m_135353_(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int DEFAULT_MAX_AGE = -1;
    public static final int MAX_FILTER_SLOTS = 14;
    private static final EntityDataAccessor<Optional<BlockPos>> DEPOSIT_POSITION = SynchedEntityData.m_135353_(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Optional<UUID>> DEPOSIT_ENTITY_UUID = SynchedEntityData.m_135353_(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Direction> DEPOSIT_FACING = SynchedEntityData.m_135353_(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Optional<BlockPos>> EXTRACT_POSITION = SynchedEntityData.m_135353_(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Direction> EXTRACT_FACING = SynchedEntityData.m_135353_(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Optional<BlockPos>> WORK_AREA_POSITION = SynchedEntityData.m_135353_(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Integer> WORK_AREA_SIZE = SynchedEntityData.m_135353_(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPIRIT_AGE = SynchedEntityData.m_135353_(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPIRIT_MAX_AGE = SynchedEntityData.m_135353_(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<String> JOB_ID = SynchedEntityData.m_135353_(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> IS_FILTER_BLACKLIST = SynchedEntityData.m_135353_(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<CompoundTag> FILTER_ITEMS = SynchedEntityData.m_135353_(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<String> TAG_FILTER = SynchedEntityData.m_135353_(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public ItemStackHandler inventory;
    public LazyOptional<ItemStackHandler> itemStackHandler = LazyOptional.of(() -> this.inventory);
    public LazyOptional<ItemStackHandler> filterItemStackHandler = LazyOptional.of(() -> new ItemStackHandler(14){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            SpiritEntity.this.f_19804_.m_135381_(FILTER_ITEMS, (Object)this.serializeNBT());
        }
    });
    protected Optional<SpiritJob> job;
    protected boolean isInitialized = false;

    public SpiritEntity(EntityType<? extends SpiritEntity> type, Level worldIn) {
        this(type, worldIn, new ItemStackHandler(1));
    }

    public SpiritEntity(EntityType<? extends SpiritEntity> type, Level worldIn, ItemStackHandler inventory) {
        super(type, worldIn);
        this.inventory = inventory;
        this.m_21530_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return TamableAnimal.m_21183_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22283_, 4.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22277_, 50.0);
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    protected Brain.Provider<?> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this, true);
    }

    protected void m_8024_() {
        this.tickBrain((LivingEntity)this);
    }

    public void handleAdditionalBrainSetup(SmartBrain<? extends SpiritEntity> brain) {
        this.getJob().ifPresent(job -> job.handleAdditionalBrainSetup((Brain<? extends SpiritEntity>)brain));
    }

    public List<ExtendedSensor<SpiritEntity>> getSensors() {
        return this.getJob().isPresent() ? this.getJob().get().getSensors() : ImmutableList.of();
    }

    public BrainActivityGroup<SpiritEntity> getCoreTasks() {
        return this.getJob().isPresent() ? this.getJob().get().getCoreTasks() : BrainActivityGroup.empty();
    }

    public BrainActivityGroup<SpiritEntity> getIdleTasks() {
        return this.getJob().isPresent() ? this.getJob().get().getIdleTasks() : BrainActivityGroup.empty();
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (key == FILTER_ITEMS && this.m_9236_().f_46443_) {
            this.filterItemStackHandler.ifPresent(handler -> {
                CompoundTag compound = (CompoundTag)this.f_19804_.m_135370_(FILTER_ITEMS);
                if (!compound.m_128456_()) {
                    handler.deserializeNBT(compound);
                }
            });
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemStackHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public Optional<BlockPos> getDepositPosition() {
        return (Optional)this.f_19804_.m_135370_(DEPOSIT_POSITION);
    }

    public void setDepositPosition(BlockPos position) {
        this.f_19804_.m_135381_(DEPOSIT_POSITION, Optional.ofNullable(position));
        if (position != null) {
            this.f_19804_.m_135381_(DEPOSIT_ENTITY_UUID, Optional.empty());
        }
        BrainUtils.setMemory((LivingEntity)this, OccultismMemoryTypes.DEPOSIT_POSITION.get(), (Object)position);
    }

    public Optional<UUID> getDepositEntityUUID() {
        return (Optional)this.f_19804_.m_135370_(DEPOSIT_ENTITY_UUID);
    }

    public void setDepositEntityUUID(UUID uuid) {
        this.f_19804_.m_135381_(DEPOSIT_ENTITY_UUID, Optional.ofNullable(uuid));
        if (uuid != null) {
            this.f_19804_.m_135381_(DEPOSIT_POSITION, Optional.empty());
        }
    }

    public Optional<BlockPos> getExtractPosition() {
        return (Optional)this.f_19804_.m_135370_(EXTRACT_POSITION);
    }

    public void setExtractPosition(BlockPos position) {
        this.f_19804_.m_135381_(EXTRACT_POSITION, Optional.ofNullable(position));
    }

    public Optional<BlockPos> getWorkAreaPosition() {
        return (Optional)this.f_19804_.m_135370_(WORK_AREA_POSITION);
    }

    public void setWorkAreaPosition(BlockPos position) {
        this.f_19804_.m_135381_(WORK_AREA_POSITION, Optional.ofNullable(position));
        BrainUtils.setMemory((LivingEntity)this, OccultismMemoryTypes.WORK_AREA_CENTER.get(), (Object)this.getWorkAreaCenter());
        this.getJob().ifPresent(SpiritJob::onChangeWorkArea);
    }

    public WorkAreaSize getWorkAreaSize() {
        return WorkAreaSize.get((Integer)this.f_19804_.m_135370_(WORK_AREA_SIZE));
    }

    public void setWorkAreaSize(WorkAreaSize workAreaSize) {
        this.f_19804_.m_135381_(WORK_AREA_SIZE, (Object)workAreaSize.getValue());
        BrainUtils.setMemory((LivingEntity)this, OccultismMemoryTypes.WORK_AREA_SIZE.get(), (Object)this.getWorkAreaSize().getValue());
        this.getJob().ifPresent(SpiritJob::onChangeWorkArea);
    }

    public BlockPos getWorkAreaCenter() {
        return this.getWorkAreaPosition().orElse(this.m_20183_());
    }

    public Direction getDepositFacing() {
        return (Direction)this.f_19804_.m_135370_(DEPOSIT_FACING);
    }

    public void setDepositFacing(Direction depositFacing) {
        this.f_19804_.m_135381_(DEPOSIT_FACING, (Object)depositFacing);
        BrainUtils.setMemory((LivingEntity)this, OccultismMemoryTypes.DEPOSIT_FACING.get(), (Object)depositFacing);
    }

    public Direction getExtractFacing() {
        return (Direction)this.f_19804_.m_135370_(EXTRACT_FACING);
    }

    public void setExtractFacing(Direction extractFacing) {
        this.f_19804_.m_135381_(EXTRACT_FACING, (Object)extractFacing);
    }

    public int getSpiritAge() {
        return (Integer)this.f_19804_.m_135370_(SPIRIT_AGE);
    }

    public void setSpiritAge(int seconds) {
        this.f_19804_.m_135381_(SPIRIT_AGE, (Object)seconds);
    }

    public int getSpiritMaxAge() {
        return (Integer)this.f_19804_.m_135370_(SPIRIT_MAX_AGE);
    }

    public void setSpiritMaxAge(int seconds) {
        this.f_19804_.m_135381_(SPIRIT_MAX_AGE, (Object)seconds);
    }

    public String getJobID() {
        return (String)this.f_19804_.m_135370_(JOB_ID);
    }

    public void setJobID(String id) {
        this.f_19804_.m_135381_(JOB_ID, (Object)id);
    }

    public boolean isFilterBlacklist() {
        return (Boolean)this.f_19804_.m_135370_(IS_FILTER_BLACKLIST);
    }

    public void setFilterBlacklist(boolean isFilterBlacklist) {
        this.f_19804_.m_135381_(IS_FILTER_BLACKLIST, (Object)isFilterBlacklist);
    }

    public String getTagFilter() {
        return (String)this.f_19804_.m_135370_(TAG_FILTER);
    }

    public void setTagFilter(String tagFilter) {
        this.f_19804_.m_135381_(TAG_FILTER, (Object)tagFilter);
    }

    public LazyOptional<ItemStackHandler> getFilterItems() {
        return this.filterItemStackHandler;
    }

    public Optional<SpiritJob> getJob() {
        if (this.job == null) {
            this.job = Optional.empty();
        }
        return this.job;
    }

    public void setJob(SpiritJob job) {
        this.setJob(job, true);
    }

    public void setJob(SpiritJob job, boolean recreateBrain) {
        this.removeJob();
        this.job = Optional.ofNullable(job);
        if (job != null) {
            this.job = Optional.ofNullable(job);
            this.setJobID(job.getFactoryID().toString());
            if (recreateBrain) {
                this.remakeBrain();
            }
        }
    }

    public void remakeBrain() {
        NbtOps nbtops = NbtOps.f_128958_;
        this.f_20939_ = this.m_8075_(new Dynamic((DynamicOps)nbtops, (Object)((Tag)nbtops.createMap((Map)ImmutableMap.of((Object)nbtops.createString("memories"), (Object)((Tag)nbtops.emptyMap()))))));
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new SpiritContainer(id, playerInventory, this);
    }

    @Override
    public LivingEntity getEntity() {
        return this;
    }

    @Override
    public EntityDataAccessor<Integer> getDataParameterSkin() {
        return SKIN;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.selectRandomSkin();
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageable) {
        return null;
    }

    public void m_8107_() {
        if (!this.m_9236_().f_46443_) {
            if (!this.isInitialized) {
                this.init();
            }
            if (this.m_9236_().m_46467_() % 20L == 0L && !this.f_20890_ && this.canDieFromAge()) {
                this.setSpiritAge(this.getSpiritAge() + 1);
                if (this.getSpiritAge() > this.getSpiritMaxAge()) {
                    this.m_6667_(this.m_269291_().m_269264_());
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
            if (!this.f_20890_) {
                this.getJob().ifPresent(SpiritJob::update);
            }
        }
        this.m_21203_();
        super.m_8107_();
    }

    public boolean m_6673_(@NotNull DamageSource source) {
        return super.m_6673_(source) || source.m_276093_(DamageTypes.f_268612_) || source.m_276093_(DamageTypes.f_268576_);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_8099_() {
    }

    public ItemStack m_6844_(EquipmentSlot slotIn) {
        if (slotIn == EquipmentSlot.MAINHAND) {
            return ((ItemStackHandler)this.itemStackHandler.orElseThrow(ItemHandlerMissingException::new)).getStackInSlot(0);
        }
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
        if (slotIn == EquipmentSlot.MAINHAND) {
            ((ItemStackHandler)this.itemStackHandler.orElseThrow(ItemHandlerMissingException::new)).setStackInSlot(0, stack);
        }
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = entityIn.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.registerSkinDataParameter();
        this.f_19804_.m_135372_(DEPOSIT_POSITION, Optional.empty());
        this.f_19804_.m_135372_(DEPOSIT_ENTITY_UUID, Optional.empty());
        this.f_19804_.m_135372_(DEPOSIT_FACING, (Object)Direction.UP);
        this.f_19804_.m_135372_(EXTRACT_POSITION, Optional.empty());
        this.f_19804_.m_135372_(EXTRACT_FACING, (Object)Direction.DOWN);
        this.f_19804_.m_135372_(WORK_AREA_POSITION, Optional.empty());
        this.f_19804_.m_135372_(WORK_AREA_SIZE, (Object)WorkAreaSize.SMALL.getValue());
        this.f_19804_.m_135372_(SPIRIT_AGE, (Object)0);
        this.f_19804_.m_135372_(SPIRIT_MAX_AGE, (Object)-1);
        this.f_19804_.m_135372_(JOB_ID, (Object)"");
        this.f_19804_.m_135372_(IS_FILTER_BLACKLIST, (Object)false);
        this.f_19804_.m_135372_(FILTER_ITEMS, (Object)new CompoundTag());
        this.f_19804_.m_135372_(TAG_FILTER, (Object)"");
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("spiritAge", this.getSpiritAge());
        compound.m_128405_("spiritMaxAge", this.getSpiritMaxAge());
        this.getWorkAreaPosition().ifPresent(pos -> compound.m_128356_("workAreaPosition", pos.m_121878_()));
        compound.m_128405_("workAreaSize", this.getWorkAreaSize().getValue());
        this.getDepositPosition().ifPresent(pos -> compound.m_128356_("depositPosition", pos.m_121878_()));
        this.getDepositEntityUUID().ifPresent(uuid -> compound.m_128362_("depositEntityUUID", uuid));
        compound.m_128405_("depositFacing", this.getDepositFacing().ordinal());
        this.getExtractPosition().ifPresent(pos -> compound.m_128356_("extractPosition", pos.m_121878_()));
        compound.m_128405_("extractFacing", this.getExtractFacing().ordinal());
        this.itemStackHandler.ifPresent(handler -> compound.m_128365_("inventory", (Tag)handler.serializeNBT()));
        this.getJob().ifPresent(job -> compound.m_128365_("spiritJob", (Tag)job.serializeNBT()));
        compound.m_128379_("isFilterBlacklist", this.isFilterBlacklist());
        this.filterItemStackHandler.ifPresent(handler -> compound.m_128365_("filterItems", (Tag)handler.serializeNBT()));
        compound.m_128359_("tagFilter", this.getTagFilter());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("spiritAge")) {
            this.setSpiritAge(compound.m_128451_("spiritAge"));
        }
        if (compound.m_128441_("spiritMaxAge")) {
            this.setSpiritMaxAge(compound.m_128451_("spiritMaxAge"));
        }
        if (compound.m_128441_("workAreaPosition")) {
            this.setWorkAreaPosition(BlockPos.m_122022_((long)compound.m_128454_("workAreaPosition")));
        }
        if (compound.m_128441_("workAreaSize")) {
            this.setWorkAreaSize(WorkAreaSize.get(compound.m_128451_("workAreaSize")));
        }
        if (compound.m_128441_("depositPosition")) {
            this.setDepositPosition(BlockPos.m_122022_((long)compound.m_128454_("depositPosition")));
        }
        if (compound.m_128441_("depositEntityUUID")) {
            this.setDepositEntityUUID(compound.m_128342_("depositEntityUUID"));
        }
        if (compound.m_128441_("depositFacing")) {
            this.setDepositFacing(Direction.values()[compound.m_128451_("depositFacing")]);
        }
        if (compound.m_128441_("extractPosition")) {
            this.setExtractPosition(BlockPos.m_122022_((long)compound.m_128454_("extractPosition")));
        }
        if (compound.m_128441_("extractFacing")) {
            this.setExtractFacing(Direction.values()[compound.m_128451_("extractFacing")]);
        }
        if (compound.m_128441_("inventory")) {
            this.itemStackHandler.ifPresent(handler -> handler.deserializeNBT(compound.m_128469_("inventory")));
        }
        if (compound.m_128441_("spiritJob")) {
            SpiritJob job = SpiritJob.from(this, compound.m_128469_("spiritJob"));
            boolean containsBrain = compound.m_128425_("Brain", 10);
            this.setJob(job, !containsBrain);
            if (compound.m_128425_("Brain", 10)) {
                this.f_20939_ = this.m_8075_(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128423_("Brain")));
            }
        }
        if (compound.m_128441_("isFilterBlacklist")) {
            this.setFilterBlacklist(compound.m_128471_("isFilterBlacklist"));
        }
        if (compound.m_128441_("filterItems")) {
            compound.m_128469_("filterItems").m_128405_("Size", 14);
            this.filterItemStackHandler.ifPresent(handler -> handler.deserializeNBT(compound.m_128469_("filterItems")));
        }
        if (compound.m_128441_("tagFilter")) {
            this.setTagFilter(compound.m_128461_("tagFilter"));
        }
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (!tamed) {
            this.setJob(null);
        }
    }

    protected void m_5907_() {
        super.m_5907_();
        this.itemStackHandler.ifPresent(handle -> {
            for (int i = 0; i < handle.getSlots(); ++i) {
                ItemStack itemstack = handle.getStackInSlot(i);
                if (itemstack.m_41619_()) continue;
                this.m_5552_(itemstack, 0.0f);
            }
        });
    }

    public void m_6667_(DamageSource cause) {
        if (!this.m_9236_().f_46443_) {
            if (this.m_21824_()) {
                BookOfCallingItem.spiritDeathRegister.put(this.f_19820_, this.m_9236_().m_46467_());
            }
            this.removeJob();
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)OccultismSounds.START_RITUAL.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        super.m_6667_(cause);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        this.removeJob();
        super.m_142687_(reason);
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41619_() && this.m_21824_() && player.m_6144_()) {
            this.openScreen(player);
            return InteractionResult.SUCCESS;
        }
        return super.m_7111_(player, vec, hand);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return this.getJob().map(job -> job.getDimensions(pPose, super.m_6972_(pPose))).orElse(super.m_6972_(pPose));
    }

    public void removeJob() {
        this.getJob().ifPresent(SpiritJob::cleanup);
        this.job = Optional.empty();
    }

    public boolean canDieFromAge() {
        return (Integer)this.f_19804_.m_135370_(SPIRIT_MAX_AGE) > -1;
    }

    public void init() {
        this.isInitialized = true;
        this.getJob().ifPresent(SpiritJob::init);
    }

    public boolean canPickupItem(ItemEntity entity) {
        return this.getJob().map(job -> job.canPickupItem(entity)).orElse(false);
    }

    public void openScreen(Player playerEntity) {
        if (!this.m_9236_().f_46443_) {
            SpiritEntity menuProvider = this;
            SpiritJob currentJob = this.getJob().orElse(null);
            if (currentJob instanceof MenuProvider) {
                menuProvider = (MenuProvider)currentJob;
            }
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerEntity), (MenuProvider)menuProvider, buf -> buf.writeInt(this.m_19879_()));
        }
    }
}

