/*
 * Decompiled with CFR 0.152.
 */
package net.funkpla.unseaworthy;

import java.util.function.Supplier;
import net.funkpla.unseaworthy.Sinker;
import net.funkpla.unseaworthy.UnseaworthyCommon;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class UnseaworthyPacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)UnseaworthyCommon.locate("main"), () -> "1", "1"::equals, "1"::equals);
    public static int messageId;

    public static void registerPackets() {
        INSTANCE.registerMessage(messageId++, SinkTimePacket.class, SinkTimePacket::encoder, SinkTimePacket::new, SinkTimePacket::handle);
    }

    public static void handle(SinkTimePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> UnseaworthyPacketHandler.lambda$handle$2(msg, (Supplier)ctx)));
        ctx.get().setPacketHandled(true);
    }

    public static void handleSinkTimePacket(SinkTimePacket packet, Supplier<NetworkEvent.Context> ctx) {
        Entity boat;
        PacketListener listener = ctx.get().getNetworkManager().m_129538_();
        if (listener instanceof ClientPacketListener && (boat = ((ClientPacketListener)listener).m_105147_().m_6815_(packet.entityId)) instanceof Sinker) {
            ((Sinker)boat).setSinkTime(packet.sinkTime);
        }
    }

    public static void sendSinkTimePacket(Entity boat, int sinkTime) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> boat), (Object)new SinkTimePacket(boat.m_19879_(), sinkTime));
    }

    private static /* synthetic */ Runnable lambda$handle$2(SinkTimePacket msg, Supplier ctx) {
        return () -> UnseaworthyPacketHandler.lambda$handle$1(msg, (Supplier)ctx);
    }

    private static /* synthetic */ void lambda$handle$1(SinkTimePacket msg, Supplier ctx) {
        UnseaworthyPacketHandler.handleSinkTimePacket(msg, ctx);
    }

    public static class SinkTimePacket {
        public final int entityId;
        public final int sinkTime;

        public SinkTimePacket(int entityId, int sinkTime) {
            this.entityId = entityId;
            this.sinkTime = sinkTime;
        }

        public SinkTimePacket(FriendlyByteBuf buffer) {
            this.entityId = buffer.readInt();
            this.sinkTime = buffer.readInt();
        }

        public void encoder(FriendlyByteBuf buffer) {
            buffer.writeInt(this.entityId);
            buffer.writeInt(this.sinkTime);
        }

        public void handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this.lambda$handle$1((Supplier)ctx)));
            ctx.get().setPacketHandled(true);
        }

        private /* synthetic */ Runnable lambda$handle$1(Supplier ctx) {
            return () -> this.lambda$handle$0((Supplier)ctx);
        }

        private /* synthetic */ void lambda$handle$0(Supplier ctx) {
            UnseaworthyPacketHandler.handle(this, ctx);
        }
    }
}

