/*
 * Decompiled with CFR 0.152.
 */
package net.funkpla.unseaworthy.capability;

import net.funkpla.unseaworthy.capability.ISinkTimeCapability;
import net.funkpla.unseaworthy.capability.SinkTimeCapability;
import net.funkpla.unseaworthy.capability.SinkTimeCapabilityImpl;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SinkTimeCapabilityAttacher {
    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        SinkTimeCapabilityProvider provider = new SinkTimeCapabilityProvider();
        event.addCapability(SinkTimeCapabilityProvider.IDENTIFIER, (ICapabilityProvider)provider);
    }

    private SinkTimeCapabilityAttacher() {
    }

    private static class SinkTimeCapabilityProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        public static final ResourceLocation IDENTIFIER = new ResourceLocation("unseaworthy", "sink_time");
        private final ISinkTimeCapability backend = new SinkTimeCapabilityImpl();
        private final LazyOptional<ISinkTimeCapability> optionalData = LazyOptional.of(() -> this.backend);

        private SinkTimeCapabilityProvider() {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return SinkTimeCapability.INSTANCE.orEmpty(cap, this.optionalData);
        }

        void invalidate() {
            this.optionalData.invalidate();
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.backend.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.backend.deserializeNBT((Tag)nbt);
        }
    }
}

