/*
 * Decompiled with CFR 0.152.
 */
package net.funkpla.unseaworthy.mixin;

import me.shedaniel.autoconfig.AutoConfig;
import net.funkpla.unseaworthy.Constants;
import net.funkpla.unseaworthy.Sinker;
import net.funkpla.unseaworthy.UnseaworthyConfig;
import net.funkpla.unseaworthy.platform.Services;
import net.funkpla.unseaworthy.platform.services.IBoatSinkTimeAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Boat.class})
public abstract class BoatMixin
extends Entity
implements Sinker {
    @Unique
    protected final UnseaworthyConfig unseaworthy$config = (UnseaworthyConfig)AutoConfig.getConfigHolder(UnseaworthyConfig.class).getConfig();
    @Unique
    private final IBoatSinkTimeAccessor unseaworthy$sinkTime = Services.SINK_TIME_ACCESSOR.from(this);
    @Unique
    private int unseaworthy$bounceTimer = 0;
    @Unique
    private boolean unseaworthy$isSinking = false;
    @Unique
    private float unseaworthy$sinkMultiplier;
    @Shadow
    private float f_38260_;
    @Shadow
    private float f_38261_;

    public BoatMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    protected abstract Boat.Status m_38392_();

    @Shadow
    public abstract Boat.Type m_28554_();

    @Shadow
    protected abstract void m_213560_(DamageSource var1);

    @Unique
    private int unseaworthy$getSinkTime() {
        return this.unseaworthy$sinkTime.getValue();
    }

    @Override
    @Unique
    public void setSinkTime(int ticks) {
        if (this.unseaworthy$sinkTime.getValue() != ticks) {
            this.unseaworthy$sinkTime.setValue(ticks);
        }
    }

    @Unique
    private boolean unseaworthy$isSinking() {
        return this.unseaworthy$isSinking;
    }

    @Unique
    private void unseaworthy$setSinking(boolean b) {
        this.unseaworthy$isSinking = b;
    }

    @Inject(at={@At(value="HEAD")}, method={"tickBubbleColumn"}, cancellable=true)
    private void cancelBubbleColumn(CallbackInfo ci) {
        if (this.unseaworthy$isSinking()) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/Boat;tickBubbleColumn()V")}, method={"tick"})
    private void tickSinking(CallbackInfo info) {
        if (!this.m_6095_().m_204039_(Constants.SINKABLE_BOATS)) {
            return;
        }
        int i = this.unseaworthy$getSinkTime();
        if (this.m_9236_().m_5776_()) {
            if (i >= 0) {
                this.unseaworthy$sinkMultiplier += 0.01f;
                if (this.f_19796_.m_188503_(15) == 0) {
                    this.m_5841_();
                }
            } else {
                this.unseaworthy$sinkMultiplier -= 0.1f;
            }
            this.unseaworthy$sinkMultiplier = Mth.m_14036_((float)this.unseaworthy$sinkMultiplier, (float)0.0f, (float)1.0f);
            this.f_38261_ = this.f_38260_;
            this.f_38260_ = 15.0f * (float)Math.sin(0.5f * (float)this.m_9236_().m_46467_()) * this.unseaworthy$sinkMultiplier;
        } else if (this.shouldSink() && this.m_38392_() != Boat.Status.UNDER_WATER) {
            if (!this.unseaworthy$isSinking()) {
                this.unseaworthy$setSinking(true);
                this.setSinkTime(this.unseaworthy$config.interval);
            } else if (this.unseaworthy$getSinkTime() <= 0) {
                if (this.f_19796_.m_188503_(100) > this.unseaworthy$config.breakChance) {
                    this.setSinkTime(this.unseaworthy$config.interval);
                } else {
                    this.unseaworthy$sink();
                }
            } else {
                this.unseaworthy$tryBounce();
                this.setSinkTime(--i);
            }
        } else {
            this.unseaworthy$setSinking(false);
            this.setSinkTime(-1);
        }
    }

    @Unique
    private float unseaworthy$getWaterLevelBelow() {
        AABB aabb = this.m_20191_();
        int minX = Mth.m_14107_((double)aabb.f_82288_);
        int maxX = Mth.m_14165_((double)aabb.f_82291_);
        int minY = Mth.m_14107_((double)aabb.f_82289_);
        int minZ = Mth.m_14107_((double)aabb.f_82290_);
        int maxZ = Mth.m_14165_((double)aabb.f_82293_);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int curY = minY;
        block0: while (true) {
            for (int curX = minX; curX < maxX; ++curX) {
                for (int curZ = minZ; curZ < maxZ; ++curZ) {
                    mutableBlockPos.m_122178_(curX, curY, curZ);
                    FluidState fluidState = this.m_9236_().m_6425_((BlockPos)mutableBlockPos);
                    if (!fluidState.m_205070_(FluidTags.f_13131_)) break block0;
                }
            }
            --curY;
        }
        return (float)minY - (float)curY;
    }

    @Unique
    boolean shouldSink() {
        return this.unseaworthy$getWaterLevelBelow() >= (float)this.unseaworthy$config.minDepth && this.m_9236_().m_204166_(this.m_20183_()).m_203656_(Constants.SINKS_BOATS) && this.unseaworthy$weatherBadEnough();
    }

    @Unique
    boolean unseaworthy$weatherBadEnough() {
        switch (this.unseaworthy$config.weatherRequired) {
            case CLEAR: {
                return true;
            }
            case RAINING: {
                return this.m_9236_().m_46471_();
            }
            case THUNDERING: {
                return this.m_9236_().m_46470_();
            }
        }
        return false;
    }

    @Unique
    private void unseaworthy$tryBounce() {
        if (this.unseaworthy$bounceTimer > 0) {
            --this.unseaworthy$bounceTimer;
            return;
        }
        this.unseaworthy$bounce();
        this.m_5841_();
        this.unseaworthy$bounceTimer = 20 + this.f_19796_.m_188503_(10);
    }

    @Unique
    private void unseaworthy$bounce() {
        Vec3 vec3 = this.m_20184_();
        float jitterX = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
        float jitterZ = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
        this.m_20334_(vec3.f_82479_ + vec3.f_82479_ * (double)jitterX, vec3.f_82480_ + 0.1 * (double)this.f_19796_.m_216339_(3, 5), vec3.f_82481_ + (double)jitterZ);
        this.m_146922_(this.m_146908_() + (this.f_19796_.m_188501_() - 0.5f) * 90.0f);
    }

    @Unique
    private void unseaworthy$sink() {
        if (this.unseaworthy$isSinking()) {
            this.m_9236_().m_245803_((Entity)this, BlockPos.m_274446_((Position)this.m_20182_()), SoundEvents.f_12278_, this.m_5720_(), 1.0f, 0.8f + 0.4f * this.f_19796_.m_188501_());
            if (this.unseaworthy$config.fate == UnseaworthyConfig.BoatFate.DESTROY) {
                this.m_6074_();
                int spawnCount = this.f_19796_.m_216339_(3, 5);
                for (int i = 0; i < spawnCount; ++i) {
                    this.m_5552_(new ItemStack((ItemLike)this.m_28554_().m_38434_()), 1.0f);
                    this.m_5552_(new ItemStack((ItemLike)Items.f_42398_), 1.0f);
                }
            } else if (this.unseaworthy$config.fate == UnseaworthyConfig.BoatFate.BREAK) {
                this.m_6074_();
                this.m_213560_(new DamageSources(this.m_9236_().m_9598_()).m_269063_());
            } else if (this.unseaworthy$config.fate == UnseaworthyConfig.BoatFate.SINK) {
                this.m_20153_();
                Vec3 vec3 = this.m_20184_();
                this.m_20334_(vec3.f_82479_, -2.0, vec3.f_82481_);
            }
        }
    }
}

