/*
 * Decompiled with CFR 0.152.
 */
package net.funkpla.unseaworthy.platform;

import net.funkpla.unseaworthy.UnseaworthyPacketHandler;
import net.funkpla.unseaworthy.capability.ISinkTimeCapability;
import net.funkpla.unseaworthy.capability.SinkTimeCapability;
import net.funkpla.unseaworthy.platform.services.IBoatSinkTimeAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class ForgeBoatSinkTimeAccessor
implements IBoatSinkTimeAccessor {
    private LazyOptional<ISinkTimeCapability> sinkCapability;
    private Entity boat;

    public ForgeBoatSinkTimeAccessor() {
    }

    public ForgeBoatSinkTimeAccessor(ICapabilityProvider entity) {
        this.sinkCapability = entity.getCapability(SinkTimeCapability.INSTANCE);
    }

    @Override
    public IBoatSinkTimeAccessor from(Entity entity) {
        ForgeBoatSinkTimeAccessor acc = new ForgeBoatSinkTimeAccessor((ICapabilityProvider)entity);
        acc.boat = entity;
        return acc;
    }

    @Override
    public int getValue() {
        return this.sinkCapability.resolve().map(ISinkTimeCapability::getValue).orElse(0);
    }

    @Override
    public void setValue(int i) {
        this.sinkCapability.ifPresent(cap -> cap.setMyValue(i));
        UnseaworthyPacketHandler.sendSinkTimePacket(this.boat, i);
    }
}

