/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.client.model;

import dev.hexnowloading.dungeonnowloading.entity.passive.WhimperEntity;
import java.util.Arrays;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class WhimperModel<T extends WhimperEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("dungeonnowloading", "whimper"), "main");
    private final ModelPart head;
    private final ModelPart left_hand;
    private final ModelPart right_hand;
    private final ModelPart left_ear;
    private final ModelPart right_ear;
    private final ModelPart tail;
    private final ModelPart root;

    public WhimperModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.left_hand = root.m_171324_("left_hand");
        this.right_hand = root.m_171324_("right_hand");
        this.left_ear = this.head.m_171324_("left_ear");
        this.right_ear = this.head.m_171324_("right_ear");
        this.tail = this.head.m_171324_("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)0.0f));
        head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(0.0f, 0.0f, -3.0f, 0.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(0.0f, 0.0f, -3.0f, 0.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        head.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)4.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("left_hand", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.5f, (float)22.5f, (float)-6.5f));
        partdefinition.m_171599_("right_hand", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.5f, (float)22.5f, (float)-6.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.animateHeadLookTarget(netHeadYaw, headPitch);
        this.animateIdlePose(ageInTicks);
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
    }

    private void animateIdlePose(float ageInTicks) {
        float AGEINTICKS_TO_SECONDS = ageInTicks / 20.0f;
        float UPDOWN_OSCILLATION_SECOND = 2.0f;
        float UPDOWN_DISTANCE_PIXEL = 1.0f;
        float updownRate = UPDOWN_DISTANCE_PIXEL * Mth.m_14031_((float)(AGEINTICKS_TO_SECONDS * ((float)Math.PI * 2) / UPDOWN_OSCILLATION_SECOND));
        ModelPart[] UPDOWN_ANIMATION_PARTS = new ModelPart[]{this.head, this.right_hand, this.left_hand};
        Arrays.stream(UPDOWN_ANIMATION_PARTS).forEach(modelPart -> modelPart.f_104201_ += updownRate);
        float FLAPPING_OSCILLATION_SECOND = 2.0f;
        float FLAPPING_ROTATION_DEGREE = 25.0f;
        float flappingRate = (float)Math.PI / 180 * FLAPPING_ROTATION_DEGREE * Mth.m_14089_((float)(AGEINTICKS_TO_SECONDS * ((float)Math.PI * 2) / FLAPPING_OSCILLATION_SECOND));
        this.right_ear.f_104205_ += flappingRate;
        this.left_ear.f_104205_ -= flappingRate;
        this.tail.f_104203_ += flappingRate;
        float HAND_OSCILLATION_SECOND = 3.0f;
        float HAND_ROTATION_DEGREE = 10.0f;
        float handRotationRate = (float)Math.PI / 180 * HAND_ROTATION_DEGREE * Mth.m_14089_((float)(AGEINTICKS_TO_SECONDS * ((float)Math.PI * 2) / HAND_OSCILLATION_SECOND));
        this.right_hand.f_104203_ += handRotationRate;
        this.left_hand.f_104203_ += handRotationRate;
        this.right_hand.f_104204_ += handRotationRate;
        this.left_hand.f_104204_ -= handRotationRate;
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

