/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.passive;

import dev.hexnowloading.dungeonnowloading.config.PvpConfig;
import dev.hexnowloading.dungeonnowloading.entity.ai.EntityBodyRotationControl;
import dev.hexnowloading.dungeonnowloading.entity.ai.SealedChaosAttackGoal;
import dev.hexnowloading.dungeonnowloading.registry.DNLItems;
import dev.hexnowloading.dungeonnowloading.util.PlayerSupporterEntity;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SealedChaosEntity
extends PathfinderMob
implements PlayerSupporterEntity {
    private static final EntityDataAccessor<Integer> DESPAWN_TICK = SynchedEntityData.m_135353_(SealedChaosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(SealedChaosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public SealedChaosEntity(EntityType<? extends SealedChaosEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22277_, 10.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new SealedChaosAttackGoal(this, 20));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, c -> !c.m_20148_().equals(this.getOwnerUUID()) && (Boolean)PvpConfig.TOGGLE_PVP_MODE.get() != false && c instanceof PlayerSupporterEntity));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, c -> !c.m_20148_().equals(this.getOwnerUUID()) && (Boolean)PvpConfig.TOGGLE_PVP_MODE.get() != false));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, c -> c instanceof Enemy));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DESPAWN_TICK, (Object)600);
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("DespawnTicks", ((Integer)this.f_19804_.m_135370_(DESPAWN_TICK)).intValue());
        if (this.getOwnerUUID() != null) {
            compoundTag.m_128362_("Owner", this.getOwnerUUID());
        }
    }

    public void m_7378_(CompoundTag compoundTag) {
        UUID uuid;
        super.m_7378_(compoundTag);
        this.f_19804_.m_135381_(DESPAWN_TICK, (Object)compoundTag.m_128451_("DespawnTicks"));
        if (compoundTag.m_128403_("Owner")) {
            uuid = compoundTag.m_128342_("Owner");
        } else {
            String string = compoundTag.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)string);
        }
        if (uuid != null) {
            this.setOwnerUUID(uuid);
        }
    }

    protected void m_8024_() {
        if (this.getDespawnTick() > 0) {
            int despawnTick = this.getDespawnTick() - 1;
            if (despawnTick <= 0) {
                this.discardWithParticle();
            }
            this.setDespawnTick(despawnTick);
        }
        super.m_8024_();
    }

    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (itemStack.m_150930_(DNLItems.SCEPTER_OF_SEALED_CHAOS.get()) && player.m_20148_().equals(this.getOwnerUUID())) {
            if (player.m_36335_().m_41519_(DNLItems.SCEPTER_OF_SEALED_CHAOS.get())) {
                player.m_36335_().m_41524_(DNLItems.SCEPTER_OF_SEALED_CHAOS.get(), 20);
                this.discardWithParticle();
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, interactionHand);
    }

    private void discardWithParticle() {
        if (!this.m_9236_().f_46443_) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 20, 0.3, 0.3, 0.3, 0.0);
        }
        this.m_146870_();
    }

    protected BodyRotationControl m_7560_() {
        return new EntityBodyRotationControl((Mob)this);
    }

    public Vec3 m_20184_() {
        return Vec3.f_82478_;
    }

    public void m_20256_(Vec3 vec3) {
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 0.5f;
    }

    public void m_141965_(ClientboundAddEntityPacket clientboundAddEntityPacket) {
        super.m_141965_(clientboundAddEntityPacket);
        this.f_20883_ = 0.0f;
        this.f_20884_ = 0.0f;
    }

    public void m_7334_(Entity entity) {
    }

    public int getDespawnTick() {
        return (Integer)this.f_19804_.m_135370_(DESPAWN_TICK);
    }

    public void setDespawnTick(int tick) {
        this.f_19804_.m_135381_(DESPAWN_TICK, (Object)tick);
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(uuid));
    }
}

