/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.passive;

import dev.hexnowloading.dungeonnowloading.config.PvpConfig;
import dev.hexnowloading.dungeonnowloading.entity.ai.WhimperChargeAttackGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.WhimperMoveControl;
import dev.hexnowloading.dungeonnowloading.entity.ai.WhimperRandomMoveGoal;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.util.PlayerSupporterEntity;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;

public class WhimperEntity
extends PathfinderMob
implements PlayerSupporterEntity {
    private static final EntityDataAccessor<Integer> DESPAWN_TICK = SynchedEntityData.m_135353_(WhimperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(WhimperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(WhimperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public WhimperEntity(EntityType<? extends WhimperEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 0;
        this.f_21342_ = new WhimperMoveControl(this);
        this.f_21365_ = new LookControl((Mob)this);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22277_, 48.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new WhimperChargeAttackGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new WhimperRandomMoveGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, c -> !c.m_20148_().equals(this.getOwnerUUID()) && (Boolean)PvpConfig.TOGGLE_PVP_MODE.get() != false && c instanceof PlayerSupporterEntity));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, c -> !c.m_20148_().equals(this.getOwnerUUID()) && (Boolean)PvpConfig.TOGGLE_PVP_MODE.get() != false));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, c -> c instanceof Enemy));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DESPAWN_TICK, (Object)600);
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(CHARGING, (Object)false);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("DespawnTicks", ((Integer)this.f_19804_.m_135370_(DESPAWN_TICK)).intValue());
        if (this.getOwnerUUID() != null) {
            compoundTag.m_128362_("Owner", this.getOwnerUUID());
        }
    }

    public void m_7378_(CompoundTag compoundTag) {
        UUID uuid;
        super.m_7378_(compoundTag);
        this.f_19804_.m_135381_(DESPAWN_TICK, (Object)compoundTag.m_128451_("DespawnTicks"));
        if (compoundTag.m_128403_("Owner")) {
            uuid = compoundTag.m_128342_("Owner");
        } else {
            String string = compoundTag.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)string);
        }
        if (uuid != null) {
            this.setOwnerUUID(uuid);
        }
    }

    protected void m_8024_() {
        if (this.getDespawnTick() > 0) {
            int despawnTick = this.getDespawnTick() - 1;
            if (despawnTick <= 0) {
                this.discardWithParticle();
            }
            this.setDespawnTick(despawnTick);
        }
        super.m_8024_();
    }

    private void discardWithParticle() {
        if (!this.m_9236_().f_46443_) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 20, 0.3, 0.3, 0.3, 0.0);
        }
        this.m_146870_();
    }

    public boolean m_20068_() {
        return true;
    }

    protected void m_7840_(double $$0, boolean $$1, BlockState $$2, BlockPos $$3) {
    }

    public boolean m_6147_() {
        return false;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 0.6f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return DNLSounds.WHIMPER_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource $$0) {
        return DNLSounds.WHIMPER_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return DNLSounds.WHIMPER_DEATH.get();
    }

    public int getDespawnTick() {
        return (Integer)this.f_19804_.m_135370_(DESPAWN_TICK);
    }

    public void setDespawnTick(int tick) {
        this.f_19804_.m_135381_(DESPAWN_TICK, (Object)tick);
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public boolean IsCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean b) {
        this.f_19804_.m_135381_(CHARGING, (Object)b);
    }
}

