/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.projectile;

import dev.hexnowloading.dungeonnowloading.entity.boss.ChaosSpawnerEntity;
import dev.hexnowloading.dungeonnowloading.entity.passive.SealedChaosEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ChaosSpawnerProjectileEntity
extends Entity {
    private UUID ownerUUID;
    private Entity cachedOwner;
    private boolean leftOwner;
    private boolean hasBeenShot;
    public double xPower;
    public double yPower;
    public double zPower;
    private final float INERTIA = 1.0f;
    private final ParticleOptions SPAWN_PARTICLE = ParticleTypes.f_123759_;
    private final ParticleOptions TRAIL_PARTICLE = ParticleTypes.f_123799_;

    public ChaosSpawnerProjectileEntity(EntityType<? extends ChaosSpawnerProjectileEntity> entityType, Level level) {
        super(entityType, level);
    }

    public ChaosSpawnerProjectileEntity(double x, double y, double z, double xP, double yP, double zP, Level level) {
        this(DNLEntityTypes.CHAOS_SPAWNER_PROJECTILE.get(), level);
        this.m_7678_(x, y, z, this.m_146908_(), this.m_146909_());
        this.m_20090_();
        double d0 = Math.sqrt(xP * xP + yP * yP + zP * zP);
        if (d0 != 0.0) {
            this.xPower = xP / d0 * 0.1;
            this.yPower = yP / d0 * 0.1;
            this.zPower = zP / d0 * 0.1;
        }
    }

    public ChaosSpawnerProjectileEntity(LivingEntity owner, double xP, double yP, double zP) {
        this(owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), xP, yP, zP, owner.m_9236_());
        this.setOwner((Entity)owner);
        this.m_19915_(owner.m_146908_(), owner.m_146909_());
    }

    public void m_8119_() {
        if (!this.hasBeenShot) {
            this.m_146852_(GameEvent.f_157778_, this.getOwner());
            this.hasBeenShot = true;
        }
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        if (this.f_19797_ > 400) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else {
            Entity owner = this.getOwner();
            if (this.m_9236_().f_46443_ || (owner == null || !owner.m_213877_()) && this.m_9236_().m_46805_(this.m_20183_())) {
                super.m_8119_();
                HitResult hitResult = ProjectileUtil.m_278158_((Entity)this, this::canHitEntity);
                if (hitResult.m_6662_() != HitResult.Type.MISS) {
                    this.onHit(hitResult);
                }
                this.m_20101_();
                Vec3 deltaMovement = this.m_20184_();
                double d0 = this.m_20185_() + deltaMovement.f_82479_;
                double d1 = this.m_20186_() + deltaMovement.f_82480_;
                double d2 = this.m_20189_() + deltaMovement.f_82481_;
                float inertia = this.INERTIA;
                this.m_20256_(deltaMovement.m_82520_(this.xPower, this.yPower, this.zPower).m_82490_((double)inertia));
                this.m_9236_().m_7106_(this.TRAIL_PARTICLE, d0, d1 + 0.5, d2, 0.0, 0.0, 0.0);
                this.m_6034_(d0, d1, d2);
                ProjectileUtil.m_37284_((Entity)this, (float)1.0f);
                if (this.f_19797_ == 3) {
                    for (int i = 0; i < 5; ++i) {
                        this.m_9236_().m_7106_(this.SPAWN_PARTICLE, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
                    }
                }
            } else {
                this.m_146870_();
            }
        }
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vector3d = new Vec3(x, y, z).m_82541_().m_82520_(this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy, this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy, this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy).m_82490_((double)velocity);
        this.m_20256_(vector3d);
        float f = Mth.m_14116_((float)((float)vector3d.m_165925_()));
        this.m_146922_((float)(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    protected void onHit(HitResult hitResult) {
        HitResult.Type hitresult$type = hitResult.m_6662_();
        if (hitresult$type == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)hitResult);
            this.m_9236_().m_214171_(GameEvent.f_157777_, hitResult.m_82450_(), GameEvent.Context.m_223719_((Entity)this, (BlockState)null));
        } else if (hitresult$type == HitResult.Type.BLOCK) {
            BlockHitResult blockhitresult = (BlockHitResult)hitResult;
            this.onHitBlock(blockhitresult);
            BlockPos blockpos = blockhitresult.m_82425_();
            this.m_9236_().m_220407_(GameEvent.f_157777_, blockpos, GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(blockpos)));
        }
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        if (!this.m_9236_().f_46443_) {
            boolean entityHurted;
            int damageAmount;
            Entity target = entityHitResult.m_82443_();
            Entity owner = this.getOwner();
            if (owner instanceof ChaosSpawnerEntity && target instanceof Player) {
                damageAmount = 1;
                if (this.getOwner() instanceof ChaosSpawnerEntity) {
                    damageAmount = (int)(((ChaosSpawnerEntity)owner).getAttackDamage() * 0.5);
                }
                entityHurted = target.m_6469_(this.m_269291_().m_269299_((Entity)this, (LivingEntity)owner), (float)damageAmount);
                if (((Player)target).m_21254_()) {
                    ((Player)target).m_36384_(true);
                }
                if (entityHurted && target.m_6084_()) {
                    this.m_19970_((LivingEntity)owner, target);
                }
            }
            if (owner instanceof SealedChaosEntity) {
                if (target instanceof SealedChaosEntity) {
                    if (((SealedChaosEntity)owner).getOwnerUUID() != ((SealedChaosEntity)target).getOwnerUUID()) {
                        damageAmount = (int)((SealedChaosEntity)owner).m_21133_(Attributes.f_22281_);
                        entityHurted = target.m_6469_(this.m_269291_().m_269299_((Entity)this, (LivingEntity)this.getOwner()), (float)damageAmount);
                        if (entityHurted && target.m_6084_()) {
                            this.m_19970_((LivingEntity)owner, target);
                        }
                    }
                } else if (target instanceof Player) {
                    if (((SealedChaosEntity)owner).getOwnerUUID() != target.m_20148_()) {
                        damageAmount = (int)((SealedChaosEntity)owner).m_21133_(Attributes.f_22281_);
                        entityHurted = target.m_6469_(this.m_269291_().m_269299_((Entity)this, (LivingEntity)this.getOwner()), (float)damageAmount);
                        if (entityHurted && target.m_6084_()) {
                            this.m_19970_((LivingEntity)owner, target);
                        }
                    }
                } else {
                    damageAmount = (int)((SealedChaosEntity)owner).m_21133_(Attributes.f_22281_);
                    entityHurted = target.m_6469_(this.m_269291_().m_269299_((Entity)this, (LivingEntity)this.getOwner()), (float)damageAmount);
                    if (entityHurted && target.m_6084_()) {
                        this.m_19970_((LivingEntity)owner, target);
                    }
                }
            }
        }
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
    }

    protected boolean canHitEntity(Entity entity) {
        if (!entity.f_19794_) {
            if (!entity.m_271807_()) {
                return false;
            }
            Entity owner = this.getOwner();
            if (owner instanceof SealedChaosEntity) {
                return true;
            }
            return owner == null || this.leftOwner || !owner.m_20365_(entity);
        }
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        Entity entity = this.getOwner();
        int i = entity == null ? 0 : entity.m_19879_();
        int n = this.m_19879_();
        UUID uUID = this.m_20148_();
        double d = this.m_20185_();
        double d2 = this.m_20186_();
        double d3 = this.m_20189_();
        float f = this.m_146909_();
        float f2 = this.m_146908_();
        EntityType entityType = this.m_6095_();
        Vec3 vec3 = this.m_20184_();
        Objects.requireNonNull(this);
        return new ClientboundAddEntityPacket(n, uUID, d, d2, d3, f, f2, entityType, i, new Vec3(vec3.m_82490_(1.0).m_252839_()), 0.0);
    }

    @Nullable
    public Entity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public void setOwner(@Nullable Entity entity) {
        if (entity != null) {
            this.ownerUUID = entity.m_20148_();
            this.cachedOwner = entity;
        }
    }

    private boolean checkLeftOwner() {
        Entity entity = this.getOwner();
        if (entity != null) {
            for (Entity entity1 : this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), p_37272_ -> !p_37272_.m_5833_() && p_37272_.m_6087_())) {
                if (entity1.m_20201_() != entity.m_20201_()) continue;
                return false;
            }
        }
        return true;
    }

    public void m_6001_(double x, double y, double z) {
        this.m_20334_(x, y, z);
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            float f = Mth.m_14116_((float)((float)(x * x + z * z)));
            this.m_146926_((float)(Mth.m_14136_((double)y, (double)f) * 57.2957763671875));
            this.m_146922_((float)(Mth.m_14136_((double)x, (double)z) * 57.2957763671875));
            this.f_19860_ = this.m_146909_();
            this.f_19859_ = this.m_146908_();
            this.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
        }
    }

    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void m_141965_(ClientboundAddEntityPacket clientboundAddEntityPacket) {
        super.m_141965_(clientboundAddEntityPacket);
        double d0 = clientboundAddEntityPacket.m_131503_();
        double d1 = clientboundAddEntityPacket.m_131504_();
        double d2 = clientboundAddEntityPacket.m_131505_();
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        if (d3 != 0.0) {
            this.xPower = d0 / d3 * 0.1;
            this.yPower = d1 / d3 * 0.1;
            this.zPower = d2 / d3 * 0.1;
        }
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compoundTag) {
        ListTag listtag;
        if (this.ownerUUID != null) {
            compoundTag.m_128362_("Owner", this.ownerUUID);
        }
        if (this.leftOwner) {
            compoundTag.m_128379_("LeftOwner", true);
        }
        compoundTag.m_128379_("HasBeenShot", this.hasBeenShot);
        if (compoundTag.m_128425_("power", 9) && (listtag = compoundTag.m_128437_("power", 6)).size() == 3) {
            this.xPower = listtag.m_128772_(0);
            this.yPower = listtag.m_128772_(1);
            this.zPower = listtag.m_128772_(2);
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        if (compoundTag.m_128403_("Owner")) {
            this.ownerUUID = compoundTag.m_128342_("Owner");
            this.cachedOwner = null;
        }
        this.leftOwner = compoundTag.m_128471_("LeftOwner");
        this.hasBeenShot = compoundTag.m_128471_("HasBeenShot");
        compoundTag.m_128365_("power", (Tag)this.m_20063_(new double[]{this.xPower, this.yPower, this.zPower}));
    }
}

