/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.server;

import dev.hexnowloading.dungeonnowloading.entity.DNLEntityEvents;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class DNLForgeEntityEvents {
    public static void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        for (EntityType<? extends LivingEntity> type : DNLEntityTypes.getAllAttributes().keySet()) {
            event.put(type, DNLEntityTypes.getAllAttributes().get(type));
        }
    }

    public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register(DNLEntityTypes.HOLLOW.get(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register(DNLEntityTypes.SPAWNER_CARRIER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.AND);
    }

    public static void onLivingDamageEvent(LivingDamageEvent event) {
        Entity attackingEntity = event.getSource().m_7639_();
        LivingEntity hurtedEntity = event.getEntity();
        float damage = event.getAmount();
        if (attackingEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attackingEntity;
            event.setAmount(DNLEntityEvents.onLivingDamageEvent(livingEntity, hurtedEntity, damage));
        }
    }

    public static void onLivingHurtEvent(LivingHurtEvent event) {
        Entity attacker = event.getSource().m_7639_();
        LivingEntity target = event.getEntity();
        float damage = event.getAmount();
        if (attacker instanceof LivingEntity) {
            LivingEntity attackerEntity = (LivingEntity)attacker;
            event.setAmount(DNLEntityEvents.onLivingHurtEvent(attackerEntity, target, damage));
        }
    }
}

