/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.connected.CTDyable;
import net.joefoxe.hexerei.block.connected.Waxed;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ToolAction;

public class ConnectingCarpetDyed
extends CarpetBlock
implements Waxed,
CTDyable {
    public static BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final EnumProperty<North> NORTH = EnumProperty.m_61587_((String)"north", North.class);
    public static final EnumProperty<South> SOUTH = EnumProperty.m_61587_((String)"south", South.class);
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.m_61587_((String)"color", DyeColor.class);
    public DyeColor dyeColor;

    public ConnectingCarpetDyed(BlockBehaviour.Properties pProperties, DyeColor dyeColor) {
        super(pProperties.m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.m_49966_().m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_(NORTH, (Comparable)((Object)North.NONE))).m_61124_(SOUTH, (Comparable)((Object)South.NONE))).m_61124_(COLOR, (Comparable)dyeColor));
        this.dyeColor = dyeColor;
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pParams) {
        List drops = super.m_49635_(pState, pParams);
        if (!pState.m_61138_(COLOR)) {
            return drops;
        }
        ArrayList<ItemStack> updated_drops = new ArrayList<ItemStack>();
        for (ItemStack stack : drops) {
            if (stack.m_41720_() == ((ConnectingCarpetDyed)ModBlocks.INFUSED_FABRIC_CARPET.get()).m_5456_() || stack.m_41720_() == ((ConnectingCarpetDyed)ModBlocks.WAXED_INFUSED_FABRIC_CARPET.get()).m_5456_()) {
                DyeColor color = (DyeColor)pState.m_61143_(COLOR);
                stack.m_41784_().m_128359_("color", color.m_41065_());
            }
            updated_drops.add(stack);
        }
        return updated_drops;
    }

    @Override
    public DyeColor getDyeColor(BlockState blockState) {
        if (blockState.m_61138_(COLOR)) {
            return (DyeColor)blockState.m_61143_(COLOR);
        }
        return DyeColor.WHITE;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        boolean east = (Boolean)pState.m_61143_((Property)EAST);
        boolean west = (Boolean)pState.m_61143_((Property)WEST);
        North northState = (North)((Object)pState.m_61143_(NORTH));
        South southState = (South)((Object)pState.m_61143_(SOUTH));
        boolean north = northState == North.ALL || northState == North.JUST_NORTH || northState == North.NORTH_AND_NORTH_EAST || northState == North.NORTH_AND_NORTH_WEST;
        boolean north_east = northState == North.ALL || northState == North.JUST_NORTH_EAST || northState == North.NORTH_AND_NORTH_EAST || northState == North.NORTH_EAST_AND_NORTH_WEST;
        boolean north_west = northState == North.ALL || northState == North.JUST_NORTH_WEST || northState == North.NORTH_AND_NORTH_WEST || northState == North.NORTH_EAST_AND_NORTH_WEST;
        boolean south = southState == South.ALL || southState == South.JUST_SOUTH || southState == South.SOUTH_AND_SOUTH_EAST || southState == South.SOUTH_AND_SOUTH_WEST;
        boolean south_east = southState == South.ALL || southState == South.JUST_SOUTH_EAST || southState == South.SOUTH_AND_SOUTH_EAST || southState == South.SOUTH_EAST_AND_SOUTH_WEST;
        boolean south_west = southState == South.ALL || southState == South.JUST_SOUTH_WEST || southState == South.SOUTH_AND_SOUTH_WEST || southState == South.SOUTH_EAST_AND_SOUTH_WEST;
        switch (pRot) {
            case NONE: {
                return pState;
            }
            case CLOCKWISE_90: {
                North northTemp = North.NONE;
                South southTemp = South.NONE;
                if (south_east && east && north_east) {
                    southTemp = South.ALL;
                } else if (!south_east && east && north_east) {
                    southTemp = South.SOUTH_AND_SOUTH_EAST;
                } else if (south_east && east) {
                    southTemp = South.SOUTH_AND_SOUTH_WEST;
                } else if (south_east && north_east) {
                    southTemp = South.SOUTH_EAST_AND_SOUTH_WEST;
                } else if (!south_east && east) {
                    southTemp = South.JUST_SOUTH;
                } else if (!south_east && north_east) {
                    southTemp = South.JUST_SOUTH_EAST;
                } else if (south_east) {
                    southTemp = South.JUST_SOUTH_WEST;
                }
                if (south_west && west && north_west) {
                    northTemp = North.ALL;
                } else if (!south_west && west && north_west) {
                    northTemp = North.NORTH_AND_NORTH_EAST;
                } else if (south_west && west) {
                    northTemp = North.NORTH_AND_NORTH_WEST;
                } else if (south_west && north_west) {
                    northTemp = North.NORTH_EAST_AND_NORTH_WEST;
                } else if (!south_west && west) {
                    northTemp = North.JUST_NORTH;
                } else if (!south_west && north_west) {
                    northTemp = North.JUST_NORTH_EAST;
                } else if (south_west) {
                    northTemp = North.JUST_NORTH_WEST;
                }
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(north))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(south))).m_61124_(NORTH, (Comparable)((Object)northTemp))).m_61124_(SOUTH, (Comparable)((Object)southTemp));
            }
            case CLOCKWISE_180: {
                North northTemp = North.NONE;
                South southTemp = South.NONE;
                if (north && north_east && north_west) {
                    southTemp = South.ALL;
                } else if (north && north_west) {
                    southTemp = South.SOUTH_AND_SOUTH_EAST;
                } else if (north && north_east) {
                    southTemp = South.SOUTH_AND_SOUTH_WEST;
                } else if (north_west && north_east) {
                    southTemp = South.SOUTH_EAST_AND_SOUTH_WEST;
                } else if (!north_west && !north_east && north) {
                    southTemp = South.JUST_SOUTH;
                } else if (north_west) {
                    southTemp = South.JUST_SOUTH_EAST;
                } else if (north_east) {
                    southTemp = South.JUST_SOUTH_WEST;
                }
                if (south && south_east && south_west) {
                    northTemp = North.ALL;
                } else if (south && south_west) {
                    northTemp = North.NORTH_AND_NORTH_EAST;
                } else if (south && south_east) {
                    northTemp = North.NORTH_AND_NORTH_WEST;
                } else if (south_west && south_east) {
                    northTemp = North.NORTH_EAST_AND_NORTH_WEST;
                } else if (!south_west && !south_east && south) {
                    northTemp = North.JUST_NORTH;
                } else if (south_west) {
                    northTemp = North.JUST_NORTH_EAST;
                } else if (south_east) {
                    northTemp = North.JUST_NORTH_WEST;
                }
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(west))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(east))).m_61124_(NORTH, (Comparable)((Object)northTemp))).m_61124_(SOUTH, (Comparable)((Object)southTemp));
            }
            case COUNTERCLOCKWISE_90: {
                North northTemp = North.NONE;
                South southTemp = South.NONE;
                if (north_west && west && south_west) {
                    southTemp = South.ALL;
                } else if (!north_west && west && south_west) {
                    southTemp = South.SOUTH_AND_SOUTH_EAST;
                } else if (north_west && west) {
                    southTemp = South.SOUTH_AND_SOUTH_WEST;
                } else if (north_west && south_west) {
                    southTemp = South.SOUTH_EAST_AND_SOUTH_WEST;
                } else if (!north_west && west) {
                    southTemp = South.JUST_SOUTH;
                } else if (!north_west && south_west) {
                    southTemp = South.JUST_SOUTH_EAST;
                } else if (north_west) {
                    southTemp = South.JUST_SOUTH_WEST;
                }
                if (north_east && east && south_east) {
                    northTemp = North.ALL;
                } else if (!north_east && east && south_east) {
                    northTemp = North.NORTH_AND_NORTH_EAST;
                } else if (north_east && east) {
                    northTemp = North.NORTH_AND_NORTH_WEST;
                } else if (north_east && south_east) {
                    northTemp = North.NORTH_EAST_AND_NORTH_WEST;
                } else if (!north_east && east) {
                    northTemp = North.JUST_NORTH;
                } else if (!north_east && south_east) {
                    northTemp = North.JUST_NORTH_EAST;
                } else if (north_east) {
                    northTemp = North.JUST_NORTH_WEST;
                }
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(north))).m_61124_(NORTH, (Comparable)((Object)northTemp))).m_61124_(SOUTH, (Comparable)((Object)southTemp));
            }
        }
        return pState;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos blockpos, Player player, InteractionHand pHand, BlockHitResult pHit) {
        Item item = player.m_21120_(pHand).m_41720_();
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            DyeColor dyecolor = dyeItem.m_41089_();
            if (this.getDyeColor(pState) == dyecolor) {
                return InteractionResult.FAIL;
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockpos, player.m_21120_(pHand));
            }
            BlockState newBlockstate = (BlockState)pLevel.m_8055_(blockpos).m_61124_(COLOR, (Comparable)dyecolor);
            if (pState.m_60734_() == ModBlocks.INFUSED_FABRIC_CARPET_ORNATE.get()) {
                Block.m_49840_((Level)pLevel, (BlockPos)blockpos, (ItemStack)new ItemStack((ItemLike)Items.f_42587_));
                newBlockstate = (BlockState)((ConnectingCarpetDyed)ModBlocks.INFUSED_FABRIC_CARPET.get()).m_49966_().m_61124_(COLOR, (Comparable)dyecolor);
            }
            pLevel.m_46597_(blockpos, newBlockstate);
            pLevel.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)newBlockstate));
            pLevel.m_5898_(player, 3003, blockpos, 0);
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        if (player.m_21120_(pHand).m_41720_() == Items.f_42587_) {
            if (pState.m_60734_() == ModBlocks.INFUSED_FABRIC_CARPET_ORNATE.get()) {
                return InteractionResult.FAIL;
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockpos, player.m_21120_(pHand));
            }
            BlockState newBlockstate = ((ConnectingCarpetDyed)ModBlocks.INFUSED_FABRIC_CARPET_ORNATE.get()).m_49966_();
            if (!player.m_7500_()) {
                player.m_21120_(pHand).m_41774_(1);
            }
            pLevel.m_46597_(blockpos, newBlockstate);
            pLevel.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)newBlockstate));
            pLevel.m_5898_(player, 3004, blockpos, 0);
            pLevel.m_5594_(player, blockpos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return super.m_6227_(pState, pLevel, blockpos, player, pHand, pHit);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        ItemStack stack = super.m_7397_(pLevel, pPos, pState);
        DyeColor color = this.getDyeColor(pState);
        if (color != DyeColor.WHITE) {
            stack.m_41784_().m_128359_("color", color.m_41065_());
        }
        return stack;
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        return this.getUnWaxed(state, context, toolAction);
    }

    public static int getColorValue(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_() != null && stack.m_41783_().m_128441_("color")) {
            return ConnectingCarpetDyed.getColorValue(DyeColor.m_41057_((String)stack.m_41784_().m_128461_("color"), (DyeColor)DyeColor.WHITE));
        }
        return ConnectingCarpetDyed.getColorValue(DyeColor.WHITE);
    }

    public static int getColorValue(BlockState state) {
        int col = ConnectingCarpetDyed.getColorValue(DyeColor.WHITE);
        Block block = state.m_60734_();
        if (block instanceof CTDyable) {
            CTDyable ctDyable = (CTDyable)block;
            col = ConnectingCarpetDyed.getColorValue(ctDyable.getDyeColor(state));
        }
        return col;
    }

    public static float[] toDarkPastel(float[] rgb) {
        float[] hsl = HexereiUtil.rgbToHsl(rgb[0], rgb[1], rgb[2]);
        hsl[1] = Math.max(0.0f, hsl[1] - 0.3f);
        return HexereiUtil.hslToRgb(hsl[0], hsl[1], hsl[2]);
    }

    public static int getColorValue(DyeColor color) {
        if (color == null) {
            return 0;
        }
        float[] colors = ConnectingCarpetDyed.toDarkPastel(color.m_41068_());
        int r = (int)(colors[0] * 255.0f);
        int g = (int)(colors[1] * 255.0f);
        int b = (int)(colors[2] * 255.0f);
        return r << 16 | g << 8 | b;
    }

    private static boolean canConnect(BlockState state1, BlockState state2) {
        if (state1.m_60734_() == state2.m_60734_() && state1.m_61138_(COLOR) && state2.m_61138_(COLOR)) {
            return state1.m_61143_(COLOR) == state2.m_61143_(COLOR);
        }
        return false;
    }

    protected BlockState updateCorners(BlockGetter world, BlockPos pos, BlockState state) {
        BlockState bs_north = world.m_8055_(pos.m_122012_());
        BlockState bs_north_east = world.m_8055_(pos.m_122012_().m_122029_());
        BlockState bs_north_west = world.m_8055_(pos.m_122012_().m_122024_());
        BlockState bs_east = world.m_8055_(pos.m_122029_());
        BlockState bs_south = world.m_8055_(pos.m_122019_());
        BlockState bs_south_east = world.m_8055_(pos.m_122019_().m_122029_());
        BlockState bs_south_west = world.m_8055_(pos.m_122019_().m_122024_());
        BlockState bs_west = world.m_8055_(pos.m_122024_());
        North north = North.NONE;
        South south = South.NONE;
        if (ConnectingCarpetDyed.canConnect(state, bs_north)) {
            north = North.JUST_NORTH;
            if (ConnectingCarpetDyed.canConnect(state, bs_north_west) && !ConnectingCarpetDyed.canConnect(state, bs_north_east)) {
                north = North.NORTH_AND_NORTH_WEST;
            }
            if (!ConnectingCarpetDyed.canConnect(state, bs_north_west) && ConnectingCarpetDyed.canConnect(state, bs_north_east)) {
                north = North.NORTH_AND_NORTH_EAST;
            }
            if (ConnectingCarpetDyed.canConnect(state, bs_north_west) && ConnectingCarpetDyed.canConnect(state, bs_north_east)) {
                north = North.ALL;
            }
        } else {
            if (ConnectingCarpetDyed.canConnect(state, bs_north_west) && !ConnectingCarpetDyed.canConnect(state, bs_north_east)) {
                north = North.JUST_NORTH_WEST;
            }
            if (!ConnectingCarpetDyed.canConnect(state, bs_north_west) && ConnectingCarpetDyed.canConnect(state, bs_north_east)) {
                north = North.JUST_NORTH_EAST;
            }
        }
        if (ConnectingCarpetDyed.canConnect(state, bs_south)) {
            south = South.JUST_SOUTH;
            if (ConnectingCarpetDyed.canConnect(state, bs_south_west) && !ConnectingCarpetDyed.canConnect(state, bs_south_east)) {
                south = South.SOUTH_AND_SOUTH_WEST;
            }
            if (!ConnectingCarpetDyed.canConnect(state, bs_south_west) && ConnectingCarpetDyed.canConnect(state, bs_south_east)) {
                south = South.SOUTH_AND_SOUTH_EAST;
            }
            if (ConnectingCarpetDyed.canConnect(state, bs_south_west) && ConnectingCarpetDyed.canConnect(state, bs_south_east)) {
                south = South.ALL;
            }
        } else {
            if (ConnectingCarpetDyed.canConnect(state, bs_south_west) && !ConnectingCarpetDyed.canConnect(state, bs_south_east)) {
                south = South.JUST_SOUTH_WEST;
            }
            if (!ConnectingCarpetDyed.canConnect(state, bs_south_west) && ConnectingCarpetDyed.canConnect(state, bs_south_east)) {
                south = South.JUST_SOUTH_EAST;
            }
        }
        boolean east = ConnectingCarpetDyed.canConnect(state, bs_east);
        boolean west = ConnectingCarpetDyed.canConnect(state, bs_west);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_(SOUTH, (Comparable)((Object)south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    public RenderShape m_7514_(BlockState iBlockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level iblockreader = context.m_43725_();
        ItemStack stack = context.m_43722_();
        BlockPos blockpos = context.m_8083_();
        if (stack.m_41782_()) {
            String colorName = stack.m_41784_().m_128461_("color");
            DyeColor color = DyeColor.m_41057_((String)colorName, (DyeColor)DyeColor.WHITE);
            return (BlockState)this.updateCorners((BlockGetter)iblockreader, blockpos, super.m_5573_(context)).m_61124_(COLOR, (Comparable)color);
        }
        return this.updateCorners((BlockGetter)iblockreader, blockpos, super.m_5573_(context));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WEST, EAST, NORTH, SOUTH, COLOR});
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : this.updateCorners((BlockGetter)world, pos, state);
    }

    public static enum North implements StringRepresentable
    {
        JUST_NORTH,
        NORTH_AND_NORTH_WEST,
        NORTH_AND_NORTH_EAST,
        JUST_NORTH_WEST,
        JUST_NORTH_EAST,
        NORTH_EAST_AND_NORTH_WEST,
        ALL,
        NONE;


        public String toString() {
            return this.m_7912_();
        }

        public String m_7912_() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case JUST_NORTH -> "north";
                case NORTH_AND_NORTH_WEST -> "north_and_north_west";
                case NORTH_AND_NORTH_EAST -> "north_and_north_east";
                case JUST_NORTH_WEST -> "north_west";
                case JUST_NORTH_EAST -> "north_east";
                case NORTH_EAST_AND_NORTH_WEST -> "north_east_and_north_west";
                case ALL -> "all";
                case NONE -> "none";
            };
        }
    }

    public static enum South implements StringRepresentable
    {
        JUST_SOUTH,
        SOUTH_AND_SOUTH_WEST,
        SOUTH_AND_SOUTH_EAST,
        JUST_SOUTH_WEST,
        JUST_SOUTH_EAST,
        SOUTH_EAST_AND_SOUTH_WEST,
        ALL,
        NONE;


        public String toString() {
            return this.m_7912_();
        }

        public String m_7912_() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case JUST_SOUTH -> "south";
                case SOUTH_AND_SOUTH_WEST -> "south_and_south_west";
                case SOUTH_AND_SOUTH_EAST -> "south_and_south_east";
                case JUST_SOUTH_WEST -> "south_west";
                case JUST_SOUTH_EAST -> "south_east";
                case SOUTH_EAST_AND_SOUTH_WEST -> "south_east_and_south_west";
                case ALL -> "all";
                case NONE -> "none";
            };
        }
    }
}

