/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.container;

import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.container.ModContainers;
import net.joefoxe.hexerei.tileentity.MixingCauldronTile;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class MixingCauldronContainer
extends AbstractContainerMenu {
    public final BlockEntity tileEntity;
    private final Player playerEntity;
    private final IItemHandler playerInventory;
    private FluidStack fluid;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 10;

    public MixingCauldronContainer(int windowId, Level world, BlockPos pos, Inventory playerInventory, Player player) {
        super((MenuType)ModContainers.MIXING_CAULDRON_CONTAINER.get(), windowId);
        BlockEntity blockEntity;
        this.tileEntity = world.m_7702_(pos);
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.layoutPlayerInventorySlots(14, 120);
        if (this.tileEntity != null) {
            this.tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
                this.m_38897_((Slot)new SlotItemHandler(h, 9, 42, 24));
                this.m_38897_((Slot)new SlotItemHandler(h, 0, 105, 17));
                this.m_38897_((Slot)new SlotItemHandler(h, 1, 127, 26));
                this.m_38897_((Slot)new SlotItemHandler(h, 2, 136, 48));
                this.m_38897_((Slot)new SlotItemHandler(h, 3, 127, 70));
                this.m_38897_((Slot)new SlotItemHandler(h, 4, 105, 79));
                this.m_38897_((Slot)new SlotItemHandler(h, 5, 83, 70));
                this.m_38897_((Slot)new SlotItemHandler(h, 6, 74, 48));
                this.m_38897_((Slot)new SlotItemHandler(h, 7, 83, 26));
                this.m_38897_((Slot)new SlotItemHandler(h, 8, 178, 48));
            });
        }
        if ((blockEntity = this.tileEntity) instanceof MixingCauldronTile) {
            MixingCauldronTile mixingTile = (MixingCauldronTile)blockEntity;
            this.fluid = mixingTile.getFluidStack();
        }
        this.m_38895_(new DataSlot(){

            public void m_6422_(int value) {
                ((MixingCauldronTile)MixingCauldronContainer.this.tileEntity).setCraftDelay(value);
            }

            public int m_6501_() {
                return ((MixingCauldronTile)MixingCauldronContainer.this.tileEntity).getCraftDelay();
            }
        });
    }

    public void setFluid(FluidStack fluidStack) {
        this.fluid = fluidStack;
    }

    public FluidStack getFluid() {
        BlockEntity blockEntity = this.tileEntity;
        if (blockEntity instanceof MixingCauldronTile) {
            MixingCauldronTile mixingTile = (MixingCauldronTile)blockEntity;
            return mixingTile.getFluidStack();
        }
        return this.fluid;
    }

    public FluidStack getRenderedFluid() {
        BlockEntity blockEntity = this.tileEntity;
        if (blockEntity instanceof MixingCauldronTile) {
            MixingCauldronTile mixingTile = (MixingCauldronTile)blockEntity;
            return mixingTile.renderedFluid;
        }
        return this.fluid;
    }

    public float getCraftPercent() {
        MixingCauldronTile cauldronTile;
        BlockEntity blockEntity = this.tileEntity;
        if (blockEntity instanceof MixingCauldronTile && !(cauldronTile = (MixingCauldronTile)blockEntity).getCrafted()) {
            return (float)cauldronTile.craftDelay / 100.0f;
        }
        return 0.0f;
    }

    public float getCraftPercentHalf() {
        BlockEntity blockEntity = this.tileEntity;
        if (blockEntity instanceof MixingCauldronTile) {
            MixingCauldronTile cauldronTile = (MixingCauldronTile)blockEntity;
            float delayHalf = (float)cauldronTile.craftDelay - 50.0f;
            if (!cauldronTile.getCrafted()) {
                return delayHalf / 100.0f;
            }
        }
        return 0.0f;
    }

    public boolean m_6875_(Player playerIn) {
        return MixingCauldronContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.tileEntity.m_58904_(), (BlockPos)this.tileEntity.m_58899_()), (Player)playerIn, (Block)((Block)ModBlocks.MIXING_CAULDRON.get()));
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 46, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 46) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(this.playerEntity, sourceStack);
        return copyOfSourceStack;
    }
}

