/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.item.custom.MixingCauldronItemRenderer;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.items.ItemStackHandler;

public class MixingCauldronItem
extends BlockItem
implements DyeableLeatherItem {
    public MixingCauldronItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void m_41115_(ItemStack p_41116_, int p_41117_) {
        super.m_41115_(p_41116_, p_41117_);
    }

    public static int getColorValue(DyeColor color, ItemStack stack) {
        int dyeCol = MixingCauldronItem.getColorStatic(stack);
        if (color == null && dyeCol != -1) {
            return dyeCol;
        }
        float[] colors = color.m_41068_();
        int r = (int)(colors[0] * 255.0f);
        int g = (int)(colors[1] * 255.0f);
        int b = (int)(colors[2] * 255.0f);
        return r << 16 | g << 8 | b;
    }

    public static int getColorStatic(ItemStack p_41122_) {
        CompoundTag compoundtag = p_41122_.m_41737_("display");
        return compoundtag != null && compoundtag.m_128425_("color", 99) ? compoundtag.m_128451_("color") : 16760348;
    }

    public static int getDyeColorNamed(String name) {
        if (HexereiUtil.getDyeColorNamed(name) != null) {
            float f3 = Hexerei.getClientTicks() / 10.0f * 4.0f % 16.0f / 16.0f;
            DyeColor col1 = HexereiUtil.getDyeColorNamed(name, 0);
            DyeColor col2 = HexereiUtil.getDyeColorNamed(name, 1);
            float[] afloat1 = Sheep.m_29829_((DyeColor)col1);
            float[] afloat2 = Sheep.m_29829_((DyeColor)col2);
            float f = afloat1[0] * (1.0f - f3) + afloat2[0] * f3;
            float f1 = afloat1[1] * (1.0f - f3) + afloat2[1] * f3;
            float f2 = afloat1[2] * (1.0f - f3) + afloat2[2] * f3;
            return HexereiUtil.getColorValue(f, f1, f2);
        }
        return 0;
    }

    public static DyeColor getDyeColorNamed(ItemStack stack) {
        return HexereiUtil.getDyeColorNamed(stack.m_41786_().getString());
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        return super.m_40576_(context);
    }

    public ItemStackHandler createHandler() {
        return new ItemStackHandler(36){

            public int getSlotLimit(int slot) {
                return 64;
            }
        };
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        final MixingCauldronItemRenderer renderer = this.createItemRenderer();
        if (renderer != null) {
            consumer.accept(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return renderer.getRenderer();
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public MixingCauldronItemRenderer createItemRenderer() {
        return new MixingCauldronItemRenderer();
    }
}

