/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.entity.spells.blood_crystal;

import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSEntityRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSPotionEffectRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.SpellRegistries;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BloodCrystalProjectile
extends AbstractMagicProjectile
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BloodCrystalProjectile(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_20242_(true);
    }

    public BloodCrystalProjectile(Level level, LivingEntity shooter) {
        this((EntityType<? extends Projectile>)((EntityType)CSEntityRegistry.BLOOD_CRYSTAL_PROJECTILE.get()), level);
        this.m_5602_((Entity)shooter);
    }

    public void trailParticles() {
        for (int i = 0; i < 4; ++i) {
            double speed = 0.05f;
            double x = Utils.random.m_188500_() * 2.0 * speed - speed;
            double y = Utils.random.m_188500_() * 2.0 * speed - speed;
            double z = Utils.random.m_188500_() * 2.0 * speed - speed;
            this.m_9236_().m_7106_(ParticleHelper.BLOOD, this.m_20185_() + x, this.m_20186_() + y, this.m_20189_() + z, x, y, z);
        }
    }

    public void impactParticles(double x, double y, double z) {
        MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)ParticleHelper.BLOOD, (double)x, (double)y, (double)z, (int)15, (double)0.1, (double)0.1, (double)0.1, (double)0.18, (boolean)true);
    }

    public void travel() {
        this.m_146884_(this.m_20182_().m_82549_(this.m_20184_()));
        if (!this.m_20068_()) {
            Vec3 vec3 = this.m_20184_();
            this.m_20334_(vec3.f_82479_, vec3.f_82480_ - (double)0.05f, vec3.f_82481_);
        }
    }

    public float getSpeed() {
        return 1.5f;
    }

    public Optional<SoundEvent> getImpactSound() {
        return Optional.of((SoundEvent)SoundRegistry.BLOOD_EXPLOSION.get());
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity target = pResult.m_82443_();
        DamageSources.applyDamage((Entity)target, (float)this.damage, (DamageSource)((AbstractSpell)SpellRegistries.HEMORRHAGING_IMPACT.get()).getDamageSource((Entity)this, this.m_19749_()));
        pResult.m_82443_().f_19802_ = 0;
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            livingTarget.m_7292_(new MobEffectInstance((MobEffect)CSPotionEffectRegistry.HEMOPHILIA_EFFECT.get(), 100, 0, true, true, true));
            livingTarget.m_7292_(new MobEffectInstance((MobEffect)CSPotionEffectRegistry.DISABLED_EFFECT.get(), 100, 0, true, true, true));
        }
    }

    protected void m_6532_(HitResult hitresult) {
        super.m_6532_(hitresult);
        if (hitresult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitresult;
            this.m_5790_(entityHitResult);
        }
        if (!this.m_9236_().f_46443_) {
            float radius = this.getExplosionRadius();
            float radiusSqr = radius * radius;
            List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_((double)radius));
            Vec3 losPoint = Utils.raycastForBlock((Level)this.m_9236_(), (Vec3)this.m_20182_(), (Vec3)this.m_20182_().m_82520_(0.0, 2.0, 0.0), (ClipContext.Fluid)ClipContext.Fluid.NONE).m_82450_();
            for (Entity entity : entities) {
                double distanceToSqr = entity.m_20238_(hitresult.m_82450_());
                if (!(distanceToSqr < (double)radiusSqr) || !this.m_5603_(entity) || !Utils.hasLineOfSight((Level)this.m_9236_(), (Vec3)losPoint, (Vec3)entity.m_20191_().m_82399_(), (boolean)true)) continue;
                double modifier = 1.0 - distanceToSqr / (double)radiusSqr;
                float damage = (float)((double)this.getDamage() * modifier);
                ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)entity.m_20182_(), (float)5.0f, (float)0.15f, (int)20, (int)20);
                if (entity instanceof LivingEntity) {
                    LivingEntity livingTarget = (LivingEntity)entity;
                    livingTarget.m_7292_(new MobEffectInstance((MobEffect)CSPotionEffectRegistry.HEMOPHILIA_EFFECT.get(), 100, 0, true, true, true));
                }
                DamageSources.applyDamage((Entity)entity, (float)damage, (DamageSource)((AbstractSpell)SpellRegistries.HEMORRHAGING_IMPACT.get()).getDamageSource((Entity)this, this.m_19749_()));
            }
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.BLOOD.get()).getTargetingColor(), 4.0f), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
        }
        this.m_146870_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

