/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.abyssal;

import com.github.L_Ender.cataclysm.capabilities.TidalTentacleCapability;
import com.github.L_Ender.cataclysm.entity.projectile.Tidal_Tentacle_Entity;
import com.github.L_Ender.cataclysm.entity.util.TidalTentacleUtil;
import com.github.L_Ender.cataclysm.init.ModCapabilities;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSchoolRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.spells.abyssal.AbstractAbyssalSpell;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.Capability;

@AutoSpellConfig
public class TidalGrabSpell
extends AbstractAbyssalSpell {
    private final ResourceLocation spellId = new ResourceLocation("cataclysm_spellbooks", "tidal_grab");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(CSSchoolRegistry.ABYSSAL_RESOURCE).setMaxLevel(5).setCooldownSeconds(50.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.cataclysm_spellbooks.range", (Object[])new Object[]{Utils.stringTruncation((double)(this.getRange(spellLevel, caster) / 10.0f), (int)2)}));
    }

    public TidalGrabSpell() {
        this.manaCostPerLevel = 1;
        this.baseSpellPower = 0;
        this.spellPowerPerLevel = 5;
        this.castTime = 100;
        this.baseManaCost = 10;
    }

    public boolean canBeCraftedBy(Player player) {
        Item tidalClaws = (Item)ModItems.TIDAL_CLAWS.get();
        return player.m_21205_().m_150930_(tidalClaws);
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.CONTINUOUS;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)ModSounds.TIDAL_TENTACLE.get());
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        return Utils.preCastTargetHelper((Level)level, (LivingEntity)entity, (MagicData)playerMagicData, (AbstractSpell)this, (int)((int)this.getRange(spellLevel, entity) / 10), (float)0.15f);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        TargetEntityCastData targetEntityCastData;
        LivingEntity targetEntity;
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData && (targetEntity = (targetEntityCastData = (TargetEntityCastData)iCastData).getTarget((ServerLevel)level)) != null) {
            Entity validTarget = null;
            HitResult hitResult = Utils.raycastForEntity((Level)level, (Entity)entity, (float)(this.getRange(spellLevel, entity) / 10.0f), (boolean)true, (float)0.25f);
            if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
                Entity target = ((EntityHitResult)hitResult).m_82443_();
                if (target.equals((Object)entity) || entity.m_7307_(target) || target.m_7307_((Entity)entity) || !(target instanceof Mob) || !entity.m_142582_(target)) {
                    Iterator iterator = level.m_45976_(LivingEntity.class, entity.m_20191_().m_82400_(16.0)).iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            this.launchTentacle(entity, (LivingEntity)validTarget, level);
                            return;
                        }
                        Entity e = (Entity)iterator.next();
                        if (e.equals((Object)entity) || entity.m_7307_(e) || e.m_7307_((Entity)entity) || !(e instanceof Mob) || !entity.m_142582_(e) || validTarget != null && !(entity.m_20270_(e) < entity.m_20270_(validTarget))) continue;
                        validTarget = e;
                    }
                }
                validTarget = target;
                this.launchTentacle(entity, (LivingEntity)validTarget, level);
            }
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void launchTentacle(LivingEntity caster, LivingEntity target, Level level) {
        TidalTentacleCapability.ITentacleCapability tentacleCapability = (TidalTentacleCapability.ITentacleCapability)ModCapabilities.getCapability((Entity)caster, (Capability)ModCapabilities.TENTACLE_CAPABILITY);
        if (tentacleCapability != null && !tentacleCapability.hasTentacle() && !level.f_46443_ && target != null) {
            Tidal_Tentacle_Entity tentacle = (Tidal_Tentacle_Entity)((EntityType)ModEntities.TIDAL_TENTACLE.get()).m_20615_(level);
            assert (tentacle != null);
            tentacle.m_20359_((Entity)caster);
            level.m_7967_((Entity)tentacle);
            tentacle.setCreatorEntityUUID(caster.m_20148_());
            tentacle.setFromEntityID(caster.m_19879_());
            tentacle.setToEntityID(target.m_19879_());
            tentacle.m_20359_((Entity)caster);
            tentacle.setProgress(0.0f);
            TidalTentacleUtil.setLastTentacle((LivingEntity)caster, (Tidal_Tentacle_Entity)tentacle);
        }
    }

    private float getRange(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * (float)(5 * spellLevel);
    }
}

