/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.ender;

import com.github.L_Ender.cataclysm.client.particle.StormParticle;
import com.github.L_Ender.cataclysm.init.ModItems;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class GravitationPullSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("cataclysm_spellbooks", "gravitation_pull");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.ENDER_RESOURCE).setMaxLevel(5).setCooldownSeconds(30.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237115_((String)"ui.cataclysm_spellbooks.gravitation"), Component.m_237110_((String)"ui.cataclysm_spellbooks.range", (Object[])new Object[]{spellLevel}), Component.m_237110_((String)"ui.cataclysm_spellbooks.difference", (Object[])new Object[]{Float.valueOf(this.getDifference(spellLevel, caster))}));
    }

    public GravitationPullSpell() {
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 5;
        this.castTime = 100;
        this.baseManaCost = 10;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.CONTINUOUS;
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of(SoundEvents.f_12286_);
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.CHARGE_SPIT_ANIMATION;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        Item gauntlet = (Item)ModItems.GAUNTLET_OF_GUARD.get();
        double radius = entity.m_21206_().m_150930_(gauntlet) || entity.m_21205_().m_150930_(gauntlet) ? (double)(spellLevel * 8) : (double)(spellLevel * 2);
        List entitiesNearby = level.m_45976_(LivingEntity.class, entity.m_20191_().m_82400_(radius));
        entitiesNearby.forEach(target -> {
            block8: {
                block7: {
                    if (target == entity) break block7;
                    if (!(target instanceof Player)) break block8;
                    Player player = (Player)target;
                    if (!player.m_150110_().f_35934_) break block8;
                }
                return;
            }
            Vec3 difference = entity.m_20182_().m_82546_(target.m_20182_());
            difference = difference.m_82541_().m_82490_((double)this.getDifference(spellLevel, entity));
            if (entity.m_6047_()) {
                target.m_20256_(difference.m_82542_((double)(-this.getDifference(spellLevel, entity)), (double)(-this.getDifference(spellLevel, entity)), (double)(-this.getDifference(spellLevel, entity))).m_82541_());
            } else {
                float distance = target.m_20270_((Entity)entity);
                if (distance <= 1.0f) {
                    return;
                }
                double overshot = difference.m_82553_() / (double)distance;
                if (overshot > 1.0) {
                    difference = new Vec3(difference.m_7096_() / overshot, difference.m_7098_() / overshot, difference.m_7094_() / overshot);
                }
                difference = difference.m_82542_((double)this.getDifference(spellLevel, entity), (double)this.getDifference(spellLevel, entity), (double)this.getDifference(spellLevel, entity)).m_82541_();
                target.m_20256_(difference);
            }
        });
        float r = 0.4f;
        float g = 0.1f;
        float b = 0.8f;
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new StormParticle.OrbData(r, g, b, 2.75f + entity.m_217043_().m_188501_() * 0.6f, 3.75f + entity.m_217043_().m_188501_() * 0.6f, entity.m_19879_()), (double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (boolean)true);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new StormParticle.OrbData(r, g, b, 2.5f + entity.m_217043_().m_188501_() * 0.45f, 3.0f + entity.m_217043_().m_188501_() * 0.45f, entity.m_19879_()), (double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (boolean)true);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new StormParticle.OrbData(r, g, b, 2.25f + entity.m_217043_().m_188501_() * 0.45f, 2.25f + entity.m_217043_().m_188501_() * 0.45f, entity.m_19879_()), (double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (boolean)true);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new StormParticle.OrbData(r, g, b, 1.25f + entity.m_217043_().m_188501_() * 0.45f, 1.25f + entity.m_217043_().m_188501_() * 0.45f, entity.m_19879_()), (double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (boolean)true);
        int count = 16;
        float particleRadius = 1.25f;
        for (int i = 0; i < count; ++i) {
            double theta = Math.toRadians(360.0 / (double)count) * (double)i;
            double x = Math.cos(theta) * (double)particleRadius;
            double z = Math.sin(theta) * (double)particleRadius;
            MagicManager.spawnParticles((Level)entity.m_9236_(), (ParticleOptions)ParticleTypes.f_123799_, (double)(entity.m_20182_().f_82479_ + x), (double)entity.m_20182_().f_82480_, (double)(entity.m_20182_().f_82481_ + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (boolean)false);
        }
        int count2 = 16;
        float particleRadius2 = 3.25f;
        for (int i = 0; i < count; ++i) {
            double theta = Math.toRadians(360.0 / (double)count2) * (double)i;
            double x = Math.cos(theta) * (double)particleRadius2;
            double z = Math.sin(theta) * (double)particleRadius2;
            MagicManager.spawnParticles((Level)entity.m_9236_(), (ParticleOptions)ParticleTypes.f_123799_, (double)(entity.m_20182_().f_82479_ + x), (double)entity.m_20182_().f_82480_, (double)(entity.m_20182_().f_82481_ + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (boolean)false);
        }
        int count3 = 16;
        float particleRadius3 = 5.25f;
        for (int i = 0; i < count; ++i) {
            double theta = Math.toRadians(360.0 / (double)count3) * (double)i;
            double x = Math.cos(theta) * (double)particleRadius3;
            double z = Math.sin(theta) * (double)particleRadius3;
            MagicManager.spawnParticles((Level)entity.m_9236_(), (ParticleOptions)ParticleTypes.f_123799_, (double)(entity.m_20182_().f_82479_ + x), (double)entity.m_20182_().f_82480_, (double)(entity.m_20182_().f_82481_ + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (boolean)false);
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private float getDifference(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) / 5.0f;
    }
}

