/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.evocation;

import com.github.L_Ender.cataclysm.init.ModTag;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class PilferSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("cataclysm_spellbooks", "pilfer");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.EVOCATION_RESOURCE).setMaxLevel(3).setCooldownSeconds(100.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237115_((String)"ui.cataclysm_spellbooks.pilfer_priority"));
    }

    public PilferSpell() {
        this.manaCostPerLevel = 15;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 0;
        this.castTime = 20;
        this.baseManaCost = 110;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.ONE_HANDED_HORIZONTAL_SWING_ANIMATION;
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of(SoundEvents.f_12317_);
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        return Utils.preCastTargetHelper((Level)level, (LivingEntity)entity, (MagicData)playerMagicData, (AbstractSpell)this, (int)(spellLevel * 2), (float)0.15f);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        TargetEntityCastData targetEntityCastData;
        LivingEntity targetEntity;
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData && (targetEntity = (targetEntityCastData = (TargetEntityCastData)iCastData).getTarget((ServerLevel)level)) != null) {
            ItemStack offhandItem = targetEntity.m_21206_();
            ItemStack mainhandItem = targetEntity.m_21205_();
            if (!offhandItem.m_41619_()) {
                if (!offhandItem.m_204117_(ModTag.STICKY_ITEM)) {
                    int i = offhandItem.m_41613_();
                    ItemStack offhandCopyItem = offhandItem.m_41777_();
                    offhandCopyItem.m_41764_(1);
                    this.stealItemDrop(offhandCopyItem, targetEntity);
                    targetEntity.m_8061_(EquipmentSlot.OFFHAND, offhandItem.m_41620_(i - 1));
                }
            } else if (!mainhandItem.m_41619_() && !offhandItem.m_204117_(ModTag.STICKY_ITEM)) {
                int i = mainhandItem.m_41613_();
                ItemStack offhandCopyItem = mainhandItem.m_41777_();
                offhandCopyItem.m_41764_(1);
                this.stealItemDrop(offhandCopyItem, targetEntity);
                targetEntity.m_8061_(EquipmentSlot.MAINHAND, mainhandItem.m_41620_(i - 1));
            }
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private ItemEntity stealItemDrop(ItemStack itemStack, LivingEntity target) {
        if (itemStack.m_41619_()) {
            return null;
        }
        if (target.m_9236_().f_46443_) {
            return null;
        }
        double d0 = target.m_20188_() - (double)0.3f;
        ItemEntity itemEntity = new ItemEntity(target.m_9236_(), target.m_20185_(), d0, target.m_20189_(), itemStack);
        itemEntity.m_32060_();
        itemEntity.m_32064_();
        float targetSinX = Mth.m_14031_((float)((float)((double)target.m_146909_() * (Math.PI / 180))));
        float targetCosX = Mth.m_14089_((float)((float)((double)target.m_146909_() * (Math.PI / 180))));
        float targetSinY = Mth.m_14031_((float)((float)((double)target.m_146908_() * (Math.PI / 180))));
        float targetCosY = Mth.m_14089_((float)((float)((double)target.m_146908_() * (Math.PI / 180))));
        float f5 = (float)((double)target.m_217043_().m_188501_() * (Math.PI * 2));
        float f6 = 0.02f * target.m_217043_().m_188501_();
        itemEntity.m_20334_((double)(-targetSinY * targetCosX * 0.3f) + Math.cos(f5) * (double)f6, (double)(-targetSinX * 0.3f + 0.1f + (target.m_217043_().m_188501_() - target.m_217043_().m_188501_()) * 0.1f), (double)(targetCosY * targetCosX * 0.3f) + Math.sin(f5) * (double)f6);
        target.m_9236_().m_7967_((Entity)itemEntity);
        return itemEntity;
    }
}

