/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.fire;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.mobs.MagicSummon;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.entity.mobs.SummonedIgnitedBerserker;
import net.acetheeldritchking.cataclysm_spellbooks.entity.mobs.SummonedIgnitedRevenant;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSPotionEffectRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.spells.fire.AbstractIgnisSpell;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class ConjureIgnitedReinforcement
extends AbstractIgnisSpell {
    private final ResourceLocation spellId = new ResourceLocation("cataclysm_spellbooks", "conjure_ignited_reinforcement");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(3).setCooldownSeconds(100.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.cataclysm_spellbooks.ignited_count", (Object[])new Object[]{spellLevel}));
    }

    public ConjureIgnitedReinforcement() {
        this.manaCostPerLevel = 15;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 5;
        this.castTime = 80;
        this.baseManaCost = 50;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        int summonTimer = 12000;
        for (int i = 0; i < spellLevel; ++i) {
            Vec3 vec = entity.m_146892_();
            double randomNearbyX = vec.f_82479_ + entity.m_217043_().m_188583_() * 3.0;
            double randomNearbyZ = vec.f_82481_ + entity.m_217043_().m_188583_() * 3.0;
            this.spawnIgnitedNearby(randomNearbyX, vec.f_82480_, randomNearbyZ, entity, level, summonTimer);
        }
        MobEffectInstance effect = new MobEffectInstance((MobEffect)CSPotionEffectRegistry.IGNITED_TIMER.get(), summonTimer, 0, false, true, true);
        entity.m_7292_(effect);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void spawnIgnitedNearby(double x, double y, double z, LivingEntity caster, Level level, int summonTimer) {
        MobEffectInstance effect = new MobEffectInstance((MobEffect)CSPotionEffectRegistry.IGNITED_TIMER.get(), summonTimer, 0, false, false, false);
        boolean isBerserker = Utils.random.m_188500_() < (double)0.7f;
        SummonedIgnitedRevenant revenantEntity = new SummonedIgnitedRevenant(level, caster);
        SummonedIgnitedBerserker berserkerEntity = new SummonedIgnitedBerserker(level, caster);
        MagicSummon ignited = isBerserker ? berserkerEntity : revenantEntity;
        ignited.m_6518_((ServerLevelAccessor)level, level.m_6436_(ignited.m_20097_()), MobSpawnType.MOB_SUMMONED, null, null);
        ignited.m_6027_(x, y, z);
        ignited.m_7292_(effect);
        level.m_7967_((Entity)ignited);
    }
}

