/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.holy;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.entity.mobs.SummonedKoboldiator;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSPotionEffectRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class ConjureKoboldiatorSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("cataclysm_spellbooks", "conjure_koboldiator");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.HOLY_RESOURCE).setMaxLevel(1).setCooldownSeconds(200.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.cataclysm_spellbooks.koboldiator_count", (Object[])new Object[]{spellLevel}));
    }

    public ConjureKoboldiatorSpell() {
        this.manaCostPerLevel = 20;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 5;
        this.castTime = 80;
        this.baseManaCost = 250;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        int summonTimer = 12000;
        for (int i = 0; i < spellLevel; ++i) {
            Vec3 vec = entity.m_146892_();
            double randomNearbyX = vec.f_82479_ + entity.m_217043_().m_188583_() * 3.0;
            double randomNearbyZ = vec.f_82481_ + entity.m_217043_().m_188583_() * 3.0;
            this.spawnKoboldiator(randomNearbyX, vec.f_82480_, randomNearbyZ, entity, level, summonTimer);
        }
        MobEffectInstance effect = new MobEffectInstance((MobEffect)CSPotionEffectRegistry.KOBOLDIATOR_TIMER.get(), summonTimer, 0, false, false, false);
        entity.m_7292_(effect);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void spawnKoboldiator(double x, double y, double z, LivingEntity caster, Level level, int summonTimer) {
        MobEffectInstance effect = new MobEffectInstance((MobEffect)CSPotionEffectRegistry.KOBOLDIATOR_TIMER.get(), summonTimer, 0, false, false, false);
        SummonedKoboldiator kobolediator = new SummonedKoboldiator(level, caster);
        kobolediator.m_6518_((ServerLevelAccessor)level, level.m_6436_(kobolediator.m_20097_()), MobSpawnType.MOB_SUMMONED, null, null);
        kobolediator.m_6027_(x, y, z);
        kobolediator.setSleep(false);
        kobolediator.m_7292_(effect);
        level.m_7967_((Entity)kobolediator);
    }
}

