/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.ice;

import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.entity.spells.EarthquakeAoe;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.List;
import java.util.Optional;
import net.acetheeldritchking.cataclysm_spellbooks.spells.CSSpellAnimations;
import net.acetheeldritchking.cataclysm_spellbooks.spells.ice.AbstractMaledictusSpell;
import net.acetheeldritchking.cataclysm_spellbooks.util.CSUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class MalevolentBattlefieldSpell
extends AbstractMaledictusSpell {
    private final ResourceLocation spellId = new ResourceLocation("cataclysm_spellbooks", "malevolent_battlefield");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchoolResource(SchoolRegistry.ICE_RESOURCE).setMaxLevel(10).setCooldownSeconds(60.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.cataclysm_spellbooks.halberd_rings", (Object[])new Object[]{spellLevel}), Component.m_237110_((String)"ui.cataclysm_spellbooks.halberd_amount", (Object[])new Object[]{Utils.stringTruncation((double)this.getHalberdsPerBranch(spellLevel, caster), (int)0)}), Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1)}), Component.m_237110_((String)"ui.cataclysm_spellbooks.maledictus_armory_bonus", (Object[])new Object[]{Utils.stringTruncation((double)this.getBonusDamage(spellLevel, caster), (int)1)}));
    }

    public MalevolentBattlefieldSpell() {
        this.manaCostPerLevel = 20;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 3;
        this.castTime = 80;
        this.baseManaCost = 100;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public AnimationHolder getCastStartAnimation() {
        return CSSpellAnimations.ANIMATION_MALEVOLENT_HAND_SIGN;
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.SPIT_FINISH_ANIMATION;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of(SoundEvents.f_215762_);
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)ModSounds.MALEDICTUS_BATTLE_CRY.get());
    }

    public boolean canBeInterrupted(@Nullable Player player) {
        return false;
    }

    public void onServerPreCast(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        double radius = 15.0;
        List entitiesNearby = level.m_45976_(LivingEntity.class, entity.m_20191_().m_82400_(radius));
        for (LivingEntity targets : entitiesNearby) {
            targets.m_7292_(new MobEffectInstance(MobEffects.f_216964_, this.getCastTime(spellLevel), 1, false, false, false));
        }
        entity.m_7292_(new MobEffectInstance(MobEffects.f_216964_, this.getCastTime(spellLevel), 1, false, false, false));
        super.onServerPreCast(level, spellLevel, entity, playerMagicData);
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        if (entity.f_19797_ % 10 == 0) {
            int count = 16;
            float particleRadius = 1.25f;
            for (int i = 0; i < count; ++i) {
                double theta = Math.toRadians(360.0 / (double)count) * (double)i;
                double x = Math.cos(theta) * (double)particleRadius;
                double z = Math.sin(theta) * (double)particleRadius;
                MagicManager.spawnParticles((Level)entity.m_9236_(), (ParticleOptions)((ParticleOptions)ModParticle.PHANTOM_WING_FLAME.get()), (double)(entity.m_20182_().f_82479_ + x), (double)entity.m_20182_().f_82480_, (double)(entity.m_20182_().f_82481_ + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (boolean)false);
            }
            int count2 = 16;
            float particleRadius2 = 3.25f;
            for (int i = 0; i < count; ++i) {
                double theta = Math.toRadians(360.0 / (double)count2) * (double)i;
                double x = Math.cos(theta) * (double)particleRadius2;
                double z = Math.sin(theta) * (double)particleRadius2;
                MagicManager.spawnParticles((Level)entity.m_9236_(), (ParticleOptions)((ParticleOptions)ModParticle.PHANTOM_WING_FLAME.get()), (double)(entity.m_20182_().f_82479_ + x), (double)entity.m_20182_().f_82480_, (double)(entity.m_20182_().f_82481_ + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (boolean)false);
            }
            int count3 = 16;
            float particleRadius3 = 5.25f;
            for (int i = 0; i < count; ++i) {
                double theta = Math.toRadians(360.0 / (double)count3) * (double)i;
                double x = Math.cos(theta) * (double)particleRadius3;
                double z = Math.sin(theta) * (double)particleRadius3;
                MagicManager.spawnParticles((Level)entity.m_9236_(), (ParticleOptions)((ParticleOptions)ModParticle.PHANTOM_WING_FLAME.get()), (double)(entity.m_20182_().f_82479_ + x), (double)entity.m_20182_().f_82480_, (double)(entity.m_20182_().f_82481_ + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (boolean)false);
            }
        }
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        Item soulRenderer = (Item)ModItems.SOUL_RENDER.get();
        Item annihilator = (Item)ModItems.THE_ANNIHILATOR.get();
        if (entity.m_21205_().m_150930_(soulRenderer) || entity.m_21205_().m_150930_(annihilator)) {
            CSUtils.spawnHalberdWindmill(spellLevel * 6, this.getHalberdsPerBranch(spellLevel, entity), 1.5, 1.95, 0.2, 1, entity, level, this.getBonusDamage(spellLevel, entity), spellLevel);
        } else {
            CSUtils.spawnHalberdWindmill(spellLevel * 6, this.getHalberdsPerBranch(spellLevel, entity), 1.5, 1.95, 0.2, 1, entity, level, this.getDamage(spellLevel, entity), spellLevel);
        }
        EarthquakeAoe aoe = new EarthquakeAoe(level);
        aoe.m_20219_(entity.m_20182_());
        aoe.m_5602_((Entity)entity);
        aoe.setCircular();
        aoe.setRadius(6.0f);
        aoe.setDuration(20);
        aoe.setDamage(0.0f);
        aoe.setSlownessAmplifier(0);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ICE.get()).getTargetingColor(), 4.0f), (double)entity.m_20185_(), (double)(entity.m_20186_() + (double)0.8f), (double)entity.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        ScreenShake_Entity.ScreenShake((Level)level, (Vec3)entity.m_20182_(), (float)6.0f, (float)0.15f, (int)20, (int)20);
        level.m_7967_((Entity)aoe);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public SpellDamageSource getDamageSource(Entity projectile, Entity attacker) {
        return super.getDamageSource(projectile, attacker).setIFrames(0).setFreezeTicks(200);
    }

    private int getHalberdsPerBranch(int spellLevel, LivingEntity caster) {
        return (int)Mth.m_14036_((float)this.getSpellPower(spellLevel, (Entity)caster), (float)1.0f, (float)3.0f);
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) + 7.0f;
    }

    private float getBonusDamage(int spellLevel, LivingEntity caster) {
        float baseDamage = this.getDamage(spellLevel, caster);
        int bonusAmount = (int)(3.5 + (double)spellLevel);
        return baseDamage + (float)bonusAmount;
    }
}

