/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.nature;

import com.github.L_Ender.cataclysm.entity.effect.Sandstorm_Entity;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class SandstormSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("cataclysm_spellbooks", "sandstorm");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.NATURE_RESOURCE).setMaxLevel(3).setCooldownSeconds(30.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.cataclysm_spellbooks.sandstorm.lifespan", (Object[])new Object[]{Float.valueOf(this.getLifespan(spellLevel, caster) / 20.0f)}), Component.m_237110_((String)"ui.cataclysm_spellbooks.sandstorm_amount", (Object[])new Object[]{spellLevel}));
    }

    public SandstormSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 2;
        this.spellPowerPerLevel = 2;
        this.castTime = 25;
        this.baseManaCost = 60;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        this.summonSandstormAroundCaster(spellLevel, level, entity);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void summonSandstormAroundCaster(int spellLevel, Level level, LivingEntity caster) {
        for (int i = 0; i < spellLevel; ++i) {
            double casterX = caster.m_20185_();
            double casterY = caster.m_20186_();
            double casterZ = caster.m_20189_();
            float angle = (float)((double)i * Math.PI / 1.5);
            double stormX = casterX + (double)(Mth.m_14089_((float)angle) * 4.0f);
            double stormZ = casterZ + (double)(Mth.m_14031_((float)angle) * 4.0f);
            Sandstorm_Entity sandstorm = new Sandstorm_Entity(level, stormX, casterY, stormZ, (int)this.getLifespan(spellLevel, caster), angle, caster);
            level.m_7967_((Entity)sandstorm);
        }
    }

    private float getLifespan(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 30.0f;
    }
}

