/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.technomancy;

import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.L_Ender.cataclysm.util.CMDamageTypes;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import java.util.Optional;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSchoolRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.spells.technomancy.AbstractHarbingerSpell;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class EMPSpell
extends AbstractHarbingerSpell {
    private final ResourceLocation spellId = new ResourceLocation("cataclysm_spellbooks", "emp_blast");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(CSSchoolRegistry.TECHNOMANCY_RESOURCE).setMaxLevel(5).setCooldownSeconds(45.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.m_237110_((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{Utils.timeFromTicks((float)this.getEffectDuration(spellLevel), (int)1)}));
    }

    public EMPSpell() {
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 5;
        this.castTime = 15;
        this.baseManaCost = 90;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.STOMP;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)ModSounds.EMP_ACTIVATED.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)ModSounds.HARBINGER_CHARGE.get());
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        float radius = (float)spellLevel + 0.5f;
        float distance = 2.0f;
        Vec3 EMPLocation = entity.m_20182_().m_82549_(entity.m_20156_().m_82542_((double)distance, (double)0.3f, (double)distance));
        this.spawnParticles(entity);
        List entities = level.m_45933_((Entity)entity, AABB.m_165882_((Vec3)EMPLocation, (double)(radius * 2.0f), (double)radius, (double)(radius * 2.0f)));
        ScreenShake_Entity.ScreenShake((Level)level, (Vec3)entity.m_20182_(), (float)radius, (float)0.01f, (int)0, (int)20);
        for (Entity target : entities) {
            target.m_6469_(CMDamageTypes.getDamageSource((Level)level, (ResourceKey)CMDamageTypes.EMP, (EntityType[])new EntityType[0]), this.getDamage(spellLevel, entity));
            if (!(target instanceof LivingEntity)) continue;
            LivingEntity livingTarget = (LivingEntity)target;
            this.spawnParticles(livingTarget);
            livingTarget.m_7292_(new MobEffectInstance((MobEffect)ModEffect.EFFECTSTUN.get(), this.getEffectDuration(spellLevel), 0, true, true, true));
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return (float)(0.7 * (double)this.getSpellPower(spellLevel, (Entity)caster));
    }

    private void spawnParticles(LivingEntity entity) {
        ServerLevel level = (ServerLevel)entity.m_9236_();
        level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticle.EM_PULSE.get()), entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
    }

    private int getEffectDuration(int spellLevel) {
        return 20 * (spellLevel + 1);
    }
}

