/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.technomancy;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.ImpulseCastData;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSchoolRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class GearShiftSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("cataclysm_spellbooks", "gear_shift");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(CSSchoolRegistry.TECHNOMANCY_RESOURCE).setMaxLevel(8).setCooldownSeconds(20.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.cataclysm_spellbooks.forward_acceleration", (Object[])new Object[]{Utils.stringTruncation((double)this.forwardAcceleration(spellLevel, caster), (int)1)}), Component.m_237110_((String)"ui.cataclysm_spellbooks.upward_acceleration", (Object[])new Object[]{Utils.stringTruncation((double)this.upwardAcceleration(spellLevel, caster), (int)1)}));
    }

    public GearShiftSpell() {
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 2;
        this.castTime = 10;
        this.baseManaCost = 35;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.CHARGE_SPIT_ANIMATION;
    }

    public ICastDataSerializable getEmptyCastData() {
        return new ImpulseCastData();
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return spellLevel;
    }

    public void onClientCast(Level level, int spellLevel, LivingEntity entity, ICastData castData) {
        if (castData instanceof ImpulseCastData) {
            ImpulseCastData data = (ImpulseCastData)castData;
            entity.f_19812_ = data.hasImpulse;
            if (!entity.m_6047_()) {
                entity.m_20256_(entity.m_20184_().m_82520_((double)data.x, (double)data.y, (double)data.z));
            } else {
                double y = Math.max(entity.m_20184_().f_82480_, (double)data.y);
                entity.m_20334_((double)data.x, y, (double)data.z);
            }
        }
        super.onClientCast(level, spellLevel, entity, castData);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        entity.f_19812_ = true;
        Vec3 forwards = entity.m_20154_();
        if (!playerMagicData.getPlayerRecasts().hasRecastForSpell(this.getSpellId())) {
            playerMagicData.getPlayerRecasts().addRecast(new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), 100, castSource, null), playerMagicData);
        }
        if (playerMagicData.getAdditionalCastData() instanceof GearShiftDirectionOverrideCastData) {
            forwards = Utils.random.m_188499_() ? forwards.m_82524_(90.0f) : forwards.m_82524_(-90.0f);
        }
        if (!entity.m_6047_()) {
            Vec3 vec3 = forwards.m_82542_(3.0, 1.0, 3.0).m_82541_().m_82520_(0.0, 0.25, 0.0).m_82490_((double)this.forwardAcceleration(spellLevel, entity));
            if (entity.m_20096_()) {
                entity.m_146884_(entity.m_20182_().m_82520_(0.0, 1.5, 0.0));
                vec3.m_82520_(0.0, 0.25, 0.0);
            }
            playerMagicData.setAdditionalCastData((ICastData)new ImpulseCastData((float)vec3.f_82479_, (float)vec3.f_82480_, (float)vec3.f_82481_, true));
            entity.m_20256_(new Vec3(Mth.m_14139_((double)0.75, (double)entity.m_20184_().f_82479_, (double)vec3.f_82479_), Mth.m_14139_((double)0.75, (double)entity.m_20184_().f_82480_, (double)vec3.f_82480_), Mth.m_14139_((double)0.75, (double)entity.m_20184_().f_82481_, (double)vec3.f_82481_)));
        } else {
            Vec3 up = entity.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82520_(0.0, 5.0, 0.0).m_82490_((double)this.upwardAcceleration(spellLevel, entity));
            playerMagicData.setAdditionalCastData((ICastData)new ImpulseCastData((float)up.f_82479_, (float)up.f_82480_, (float)up.f_82481_, true));
            entity.m_20256_(entity.m_20184_().m_82549_(up));
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public float forwardAcceleration(int spellLevel, LivingEntity entity) {
        return (this.getSpellPower(spellLevel, (Entity)entity) + (float)(spellLevel + 1)) / 20.0f;
    }

    public float upwardAcceleration(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity) / 120.0f;
    }

    private static class GearShiftDirectionOverrideCastData
    implements ICastData {
        private GearShiftDirectionOverrideCastData() {
        }

        public void reset() {
        }
    }
}

