/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.technomancy;

import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.entity.spells.parting_shot.PartingShotProjectile;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSchoolRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.spells.CSSpellAnimations;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class PartingShotSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("cataclysm_spellbooks", "parting_shot");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(CSSchoolRegistry.TECHNOMANCY_RESOURCE).setMaxLevel(1).setCooldownSeconds(120.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}));
    }

    public PartingShotSpell() {
        this.manaCostPerLevel = 0;
        this.baseSpellPower = 25;
        this.spellPowerPerLevel = 0;
        this.castTime = 35;
        this.baseManaCost = 150;
    }

    public boolean canBeCraftedBy(Player player) {
        return false;
    }

    public boolean allowLooting() {
        return false;
    }

    public boolean allowCrafting() {
        return false;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public AnimationHolder getCastStartAnimation() {
        return CSSpellAnimations.ANIMATION_CHARGE_GUN_FULL;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        PartingShotProjectile partingShot1 = new PartingShotProjectile(level, entity);
        PartingShotProjectile partingShot2 = new PartingShotProjectile(level, entity);
        partingShot1.m_146884_(entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_() + 0.5 - partingShot1.m_20191_().m_82376_() * 0.5, 0.0));
        partingShot1.m_37251_((Entity)entity, entity.m_146909_(), entity.m_6080_(), 0.0f, 1.0f, 1.0f);
        partingShot1.setExplosionRadius(6.0f);
        partingShot2.m_146884_(entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_() - 0.5 - partingShot2.m_20191_().m_82376_() * 0.5, 0.0));
        partingShot2.m_37251_((Entity)entity, entity.m_146909_(), entity.m_6080_(), 0.0f, 1.0f, 1.0f);
        partingShot2.setExplosionRadius(6.0f);
        float damage = this.getDamage(spellLevel, entity);
        partingShot1.setDamage(damage);
        ScreenShake_Entity.ScreenShake((Level)level, (Vec3)entity.m_20182_(), (float)5.0f, (float)0.15f, (int)20, (int)20);
        level.m_7967_((Entity)partingShot1);
        level.m_7967_((Entity)partingShot2);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 2.0f;
    }
}

