/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.technomancy;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.entity.mobs.MagicSummon;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSPotionEffectRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSchoolRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.spells.CSSpellAnimations;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class RewireSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("cataclysm_spellbooks", "rewire");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(CSSchoolRegistry.TECHNOMANCY_RESOURCE).setMaxLevel(8).setCooldownSeconds(30.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{Utils.timeFromTicks((float)this.getEffectDuration(spellLevel, caster), (int)1)}), Component.m_237110_((String)"attribute.modifier.plus.1", (Object[])new Object[]{Utils.stringTruncation((double)this.getPercentageMovementSpeed(spellLevel), (int)0), Component.m_237115_((String)"attribute.name.generic.movement_speed")}), Component.m_237110_((String)"attribute.modifier.plus.1", (Object[])new Object[]{Utils.stringTruncation((double)this.getPercentageAttackDamage(spellLevel), (int)0), Component.m_237115_((String)"attribute.name.generic.attack_damage")}), Component.m_237110_((String)"attribute.modifier.plus.1", (Object[])new Object[]{Utils.stringTruncation((double)this.getPercentageArmorReduction(spellLevel), (int)0), Component.m_237115_((String)"attribute.name.generic.armor")}), Component.m_237110_((String)"attribute.modifier.plus.1", (Object[])new Object[]{Utils.stringTruncation((double)this.getPercentageToughnessReduction(spellLevel), (int)0), Component.m_237115_((String)"attribute.name.generic.armor_toughness")}));
    }

    public RewireSpell() {
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 2;
        this.castTime = 0;
        this.baseManaCost = 25;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public AnimationHolder getCastStartAnimation() {
        return CSSpellAnimations.ANIMATION_CONSTRUCT_SUMMON;
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.ANIMATION_LONG_CAST_FINISH;
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return spellLevel;
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        return Utils.preCastTargetHelper((Level)level, (LivingEntity)entity, (MagicData)playerMagicData, (AbstractSpell)this, (int)32, (float)0.15f);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData) {
            LivingEntity targetEntity;
            TargetEntityCastData targetingData = (TargetEntityCastData)iCastData;
            if (!playerMagicData.getPlayerRecasts().hasRecastForSpell(this.getSpellId())) {
                playerMagicData.getPlayerRecasts().addRecast(new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), 200, castSource, null), playerMagicData);
            }
            if ((targetEntity = targetingData.getTarget((ServerLevel)level)) != null && targetEntity instanceof MagicSummon) {
                targetEntity.m_7292_(new MobEffectInstance((MobEffect)CSPotionEffectRegistry.REWIRED_EFFECT.get(), this.getEffectDuration(spellLevel, entity), spellLevel - 1, true, true, true));
            }
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public int getEffectDuration(int spellLevel, LivingEntity caster) {
        int amount = (int)(this.getSpellPower(spellLevel, (Entity)caster) * 20.0f);
        return amount;
    }

    private float getPercentageMovementSpeed(int spellLevel) {
        return (float)spellLevel * 0.2f * 100.0f;
    }

    private float getPercentageAttackDamage(int spellLevel) {
        return (float)spellLevel * 0.2f * 100.0f;
    }

    private float getPercentageArmorReduction(int spellLevel) {
        return (float)spellLevel * 0.2f * 100.0f;
    }

    private float getPercentageToughnessReduction(int spellLevel) {
        return (float)spellLevel * 0.2f * 100.0f;
    }
}

