/*
 * Decompiled with CFR 0.152.
 */
package com.dynview.ViewDistHandler;

import com.dynview.DynView;
import com.dynview.ViewDistHandler.IDynamicViewDistanceManager;
import com.dynview.config.CommonConfiguration;
import java.util.Random;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mth;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ServerDynamicViewDistanceManager
implements IDynamicViewDistanceManager {
    private static final int UPDATE_LEEWAY = 3;
    private static ServerDynamicViewDistanceManager instance;
    private static Random rand;
    private int currentChunkViewDist = 0;
    private int currentChunkUpdateDist = 0;

    private ServerDynamicViewDistanceManager() {
    }

    public static IDynamicViewDistanceManager getInstance() {
        if (instance == null) {
            instance = new ServerDynamicViewDistanceManager();
        }
        return instance;
    }

    @Override
    public void initViewDist(MinecraftServer server) {
        this.currentChunkViewDist = (((CommonConfiguration)DynView.config.getCommonConfig()).minChunkViewDist + ((CommonConfiguration)DynView.config.getCommonConfig()).maxChunkViewDist) / 2;
        this.currentChunkUpdateDist = (((CommonConfiguration)DynView.config.getCommonConfig()).minSimulationDist + ((CommonConfiguration)DynView.config.getCommonConfig()).maxSimulationDist) / 2;
        server.m_6846_().m_11217_(this.currentChunkUpdateDist);
        if (((CommonConfiguration)DynView.config.getCommonConfig()).adjustSimulationDistance) {
            ServerLifecycleHooks.getCurrentServer().m_129785_().forEach(level -> level.m_7726_().m_184026_(this.currentChunkUpdateDist));
        }
    }

    @Override
    public void updateViewDistForMeanTick(int meanTickTime) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server.m_6846_().m_11314_().isEmpty()) {
            return;
        }
        if (meanTickTime - 3 > ((CommonConfiguration)DynView.config.getCommonConfig()).meanAvgTickTime) {
            if (this.currentChunkUpdateDist > ((CommonConfiguration)DynView.config.getCommonConfig()).minSimulationDist && rand.nextInt(10) != 0) {
                --this.currentChunkUpdateDist;
                if (((CommonConfiguration)DynView.config.getCommonConfig()).logMessages) {
                    DynView.LOGGER.info("Mean tick: " + meanTickTime + "ms decreasing simulation distance to: " + this.currentChunkUpdateDist);
                }
                server.m_129785_().forEach(level -> level.m_7726_().m_184026_(this.currentChunkUpdateDist));
                return;
            }
            if (this.currentChunkViewDist > ((CommonConfiguration)DynView.config.getCommonConfig()).minChunkViewDist) {
                --this.currentChunkViewDist;
                if (((CommonConfiguration)DynView.config.getCommonConfig()).logMessages) {
                    DynView.LOGGER.info("Mean tick: " + meanTickTime + "ms decreasing chunk view distance to: " + this.currentChunkViewDist);
                }
                server.m_6846_().m_11217_(this.currentChunkViewDist);
            }
        }
        if (meanTickTime + 3 < ((CommonConfiguration)DynView.config.getCommonConfig()).meanAvgTickTime) {
            if (this.currentChunkUpdateDist < ((CommonConfiguration)DynView.config.getCommonConfig()).maxSimulationDist && rand.nextInt(10) != 0) {
                ++this.currentChunkUpdateDist;
                if (((CommonConfiguration)DynView.config.getCommonConfig()).logMessages) {
                    DynView.LOGGER.info("Mean tick: " + meanTickTime + "ms increasing simulation distance to: " + this.currentChunkUpdateDist);
                }
                server.m_129785_().forEach(level -> level.m_7726_().m_184026_(this.currentChunkUpdateDist));
                return;
            }
            if (this.currentChunkViewDist < ((CommonConfiguration)DynView.config.getCommonConfig()).maxChunkViewDist) {
                ++this.currentChunkViewDist;
                if (((CommonConfiguration)DynView.config.getCommonConfig()).logMessages) {
                    DynView.LOGGER.info("Mean tick: " + meanTickTime + "ms increasing chunk view distance to: " + this.currentChunkViewDist);
                }
                server.m_6846_().m_11217_(this.currentChunkViewDist);
            }
        }
    }

    @Override
    public void setCurrentChunkViewDist(int currentChunkViewDist) {
        this.currentChunkViewDist = Mth.m_14045_((int)currentChunkViewDist, (int)0, (int)200);
        ServerLifecycleHooks.getCurrentServer().m_6846_().m_11217_(this.currentChunkViewDist);
    }

    @Override
    public void setCurrentChunkUpdateDist(int currentChunkUpdateDist) {
        this.currentChunkUpdateDist = Mth.m_14045_((int)currentChunkUpdateDist, (int)0, (int)200);
        ServerLifecycleHooks.getCurrentServer().m_129785_().forEach(level -> level.m_7726_().m_184026_(this.currentChunkUpdateDist));
    }

    static {
        rand = new Random();
    }
}

