/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.block;

import forestry.core.blocks.IBlockType;
import forestry.core.blocks.IMachineProperties;
import forestry.core.blocks.MachineProperties;
import forestry.core.tiles.IForestryTicker;
import forestry.core.tiles.TileForestry;
import forestry.core.tiles.TilePowered;
import forestry.modules.features.FeatureTileType;
import java.util.Locale;
import thedarkcolour.gendustry.blockentity.AbstractMutatronBlockEntity;
import thedarkcolour.gendustry.blockentity.IndustrialApiaryBlockEntity;
import thedarkcolour.gendustry.blockentity.ProducerBlockEntity;
import thedarkcolour.gendustry.blockentity.ReplicatorBlockEntity;
import thedarkcolour.gendustry.registry.GBlockEntities;

public enum GendustryMachineType implements IBlockType
{
    INDUSTRIAL_APIARY(GBlockEntities.INDUSTRIAL_APIARY, IndustrialApiaryBlockEntity::serverTick, IndustrialApiaryBlockEntity::clientTick),
    MUTAGEN_PRODUCER(GBlockEntities.MUTAGEN_PRODUCER, ProducerBlockEntity::serverTick),
    DNA_EXTRACTOR(GBlockEntities.DNA_EXTRACTOR, ProducerBlockEntity::serverTick),
    PROTEIN_LIQUEFIER(GBlockEntities.PROTEIN_LIQUEFIER, ProducerBlockEntity::serverTick),
    SAMPLER(GBlockEntities.SAMPLER, TilePowered::serverTick),
    MUTATRON(GBlockEntities.MUTATRON, AbstractMutatronBlockEntity::serverTick),
    ADVANCED_MUTATRON(GBlockEntities.ADVANCED_MUTATRON, AbstractMutatronBlockEntity::serverTick),
    IMPRINTER(GBlockEntities.IMPRINTER, TilePowered::serverTick),
    GENETIC_TRANSPOSER(GBlockEntities.GENETIC_TRANSPOSER, TilePowered::serverTick),
    REPLICATOR(GBlockEntities.REPLICATOR, ReplicatorBlockEntity::serverTick);

    private final IMachineProperties<?> properties;

    private <T extends TileForestry> GendustryMachineType(FeatureTileType<T> teClass, IForestryTicker<T> serverTicker) {
        String name = this.name().toLowerCase(Locale.ENGLISH);
        this.properties = new MachineProperties.Builder(teClass, name).setServerTicker(serverTicker).create();
    }

    private <T extends TileForestry> GendustryMachineType(FeatureTileType<T> teClass, IForestryTicker<T> serverTicker, IForestryTicker<T> clientTicker) {
        String name = this.name().toLowerCase(Locale.ENGLISH);
        this.properties = new MachineProperties.Builder(teClass, name).setServerTicker(serverTicker).setClientTicker(clientTicker).create();
    }

    public IMachineProperties<?> getMachineProperties() {
        return this.properties;
    }

    public String m_7912_() {
        return this.properties.m_7912_();
    }
}

