/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.blockentity;

import forestry.api.core.IError;
import forestry.api.core.IErrorLogic;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.TilePowered;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;
import thedarkcolour.gendustry.blockentity.GeneticTransposerInventory;
import thedarkcolour.gendustry.blockentity.IHintTile;
import thedarkcolour.gendustry.compat.forestry.GendustryError;
import thedarkcolour.gendustry.menu.ThreeInputMenu;
import thedarkcolour.gendustry.registry.GBlockEntities;

public class GeneticTransposerBlockEntity
extends TilePowered
implements IHintTile {
    private static final float CONSUME_LABWARE_CHANCE = 0.2f;
    public static final String HINTS_KEY = "gendustry.genetic_transposer";
    private final GeneticTransposerInventory inventory = new GeneticTransposerInventory(this);

    public GeneticTransposerBlockEntity(BlockPos pos, BlockState state) {
        super(GBlockEntities.GENETIC_TRANSPOSER.tileType(), pos, state, 10000, 1000000);
        this.setInternalInventory((IInventoryAdapter)this.inventory);
        this.setTicksPerWorkCycle(20);
        this.setEnergyPerWorkCycle(50000);
    }

    public boolean hasWork() {
        IErrorLogic errors = this.getErrorLogic();
        boolean noBlanks = errors.setCondition(this.inventory.m_8020_(0).m_41619_(), (IError)GendustryError.NO_BLANK);
        boolean noSource = errors.setCondition(this.inventory.m_8020_(1).m_41619_(), (IError)GendustryError.NO_SOURCE);
        boolean noLabware = errors.setCondition(this.inventory.m_8020_(2).m_41619_(), (IError)GendustryError.NO_LABWARE);
        return !noBlanks && !noSource && !noLabware;
    }

    protected boolean workCycle() {
        ItemStack result;
        ItemStack copy = this.inventory.m_8020_(1).m_255036_(1);
        ItemStack output = this.inventory.m_8020_(3);
        if (!output.m_41619_() && !ItemHandlerHelper.canItemStacksStack((ItemStack)output, (ItemStack)copy)) {
            return false;
        }
        this.inventory.m_7407_(0, 1);
        if (this.f_58857_.f_46441_.m_188501_() < 0.2f) {
            this.inventory.m_7407_(2, 1);
        }
        if (output.m_41619_()) {
            result = copy;
        } else {
            result = output.m_41777_();
            result.m_41769_(1);
        }
        this.inventory.m_6836_(3, result);
        return true;
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
        return ThreeInputMenu.geneticTransposer(windowId, playerInv, this);
    }

    @Override
    public String getHintsKey() {
        return HINTS_KEY;
    }
}

