/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.blockentity;

import forestry.api.core.IError;
import forestry.api.core.IItemSubtype;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.StandardTank;
import forestry.core.inventory.IInventoryAdapter;
import forestry.modules.features.FeatureTileType;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.gendustry.blockentity.PoweredTankBlockEntity;
import thedarkcolour.gendustry.blockentity.ProducerInventory;
import thedarkcolour.gendustry.compat.forestry.GendustryError;
import thedarkcolour.gendustry.item.GendustryResourceType;
import thedarkcolour.gendustry.menu.ProducerMenu;
import thedarkcolour.gendustry.recipe.ProcessorRecipe;
import thedarkcolour.gendustry.registry.GFluids;
import thedarkcolour.gendustry.registry.GItems;

public abstract class ProducerBlockEntity<T extends ProducerBlockEntity<T, R>, R extends ProcessorRecipe>
extends PoweredTankBlockEntity {
    private static final float CONSUME_LABWARE_CHANCE = 0.1f;
    protected final FilteredTank outputTank;
    protected final ProducerInventory<T> inventory;
    public final boolean usesLabware;
    private final GFluids resultFluid;
    @Nullable
    protected ProcessorRecipe currentRecipe;

    public ProducerBlockEntity(FeatureTileType<?> type, GFluids result, boolean usesLabware, BlockPos pos, BlockState state) {
        super(type.tileType(), pos, state, 10000, 1000000);
        this.outputTank = new FilteredTank(10000, false, true).setFilters(Set.of(result.fluid()));
        this.tankManager.add((StandardTank)this.outputTank);
        this.inventory = new ProducerInventory<ProducerBlockEntity>(this, usesLabware);
        this.usesLabware = usesLabware;
        this.resultFluid = result;
        this.setInternalInventory((IInventoryAdapter)this.inventory);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        FluidStack fluid;
        super.serverTick(level, pos, state);
        if (this.updateOnInterval(20) && !(fluid = this.outputTank.getFluid()).isEmpty()) {
            FluidHelper.fillContainers((IFluidHandler)this.tankManager, this.inventory, (int)1, (int)2, (Fluid)fluid.getFluid(), (boolean)true);
        }
    }

    public boolean hasWork() {
        boolean hasInput;
        R matchingRecipe = this.getRecipe(this.inventory.m_8020_(0));
        if (this.currentRecipe != matchingRecipe) {
            this.currentRecipe = matchingRecipe;
            if (this.currentRecipe != null) {
                this.startWorking();
            }
        }
        boolean bl = hasInput = !this.getErrorLogic().setCondition(this.currentRecipe == null, this.getNoInputError());
        if (this.usesLabware) {
            ItemStack labware = this.inventory.m_8020_(3);
            boolean hasLabware = !this.getErrorLogic().setCondition(labware.m_41619_(), (IError)GendustryError.NO_LABWARE);
            return hasInput && hasLabware;
        }
        return hasInput;
    }

    protected boolean workCycle() {
        int resultAmount = this.currentRecipe.getAmount();
        if (this.outputTank.getRemainingSpace() < resultAmount) {
            return false;
        }
        ItemStack input = this.inventory.m_8020_(0);
        if (!this.currentRecipe.isIngredient(input)) {
            return false;
        }
        if (this.usesLabware) {
            ItemStack labware = this.inventory.m_8020_(3);
            if (!labware.m_150930_(GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.LABWARE))) {
                return false;
            }
            if (this.f_58857_.f_46441_.m_188501_() < 0.1f) {
                this.inventory.m_7407_(3, 1);
            }
        }
        this.inventory.m_7407_(0, 1);
        FluidStack result = this.resultFluid.fluidStack(resultAmount);
        this.outputTank.fillInternal(result, IFluidHandler.FluidAction.EXECUTE);
        return true;
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
        return new ProducerMenu(windowId, playerInv, this);
    }

    public abstract boolean isValidInput(ItemStack var1);

    @Nullable
    public abstract R getRecipe(ItemStack var1);

    public abstract void startWorking();

    public abstract IError getNoInputError();

    public abstract String getHintsKey();
}

