/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.blockentity;

import forestry.api.core.ForestryError;
import forestry.api.core.IError;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.gendustry.blockentity.ProducerBlockEntity;
import thedarkcolour.gendustry.recipe.ProteinRecipe;
import thedarkcolour.gendustry.recipe.cache.ProteinRecipeCache;
import thedarkcolour.gendustry.registry.GBlockEntities;
import thedarkcolour.gendustry.registry.GFluids;

public class ProteinLiquefierBlockEntity
extends ProducerBlockEntity<ProteinLiquefierBlockEntity, ProteinRecipe> {
    private static final int ENERGY_PER_WORK_CYCLE = 20000;
    private static final int TICKS_PER_WORK_CYCLE = 100;
    public static final String HINTS_KEY = "gendustry.protein_liquefier";

    public ProteinLiquefierBlockEntity(BlockPos pos, BlockState state) {
        super(GBlockEntities.PROTEIN_LIQUEFIER, GFluids.PROTEIN, false, pos, state);
    }

    @Override
    public boolean isValidInput(ItemStack input) {
        return ProteinRecipeCache.INSTANCE.getRecipe(input) != null;
    }

    @Override
    @Nullable
    public ProteinRecipe getRecipe(ItemStack input) {
        return ProteinRecipeCache.INSTANCE.getRecipe(input);
    }

    @Override
    public void startWorking() {
        this.setTicksPerWorkCycle(100);
        this.setEnergyPerWorkCycle(20000);
    }

    @Override
    public IError getNoInputError() {
        return ForestryError.NO_RECIPE;
    }

    @Override
    public String getHintsKey() {
        return HINTS_KEY;
    }
}

