/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.blockentity;

import forestry.api.apiculture.genetics.IBee;
import forestry.api.core.IError;
import forestry.api.core.IErrorLogic;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.alleles.IValueAllele;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.StandardTank;
import forestry.core.inventory.IInventoryAdapter;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.gendustry.blockentity.PoweredTankBlockEntity;
import thedarkcolour.gendustry.blockentity.ReplicatorInventory;
import thedarkcolour.gendustry.compat.forestry.GendustryError;
import thedarkcolour.gendustry.item.GeneticTemplateItem;
import thedarkcolour.gendustry.menu.ReplicatorMenu;
import thedarkcolour.gendustry.registry.GBlockEntities;
import thedarkcolour.gendustry.registry.GFluids;

public class ReplicatorBlockEntity
extends PoweredTankBlockEntity {
    public static final String HINTS_KEY = "gendustry.replicator";
    private final FilteredTank dnaTank = new FilteredTank(10000).setFilters(Set.of(GFluids.LIQUID_DNA.fluid()));
    private final FilteredTank proteinTank = new FilteredTank(10000).setFilters(Set.of(GFluids.PROTEIN.fluid()));
    private final ReplicatorInventory inventory;

    public ReplicatorBlockEntity(BlockPos pos, BlockState state) {
        super(GBlockEntities.REPLICATOR.tileType(), pos, state, 10000, 1000000);
        this.tankManager.add((StandardTank)this.dnaTank);
        this.tankManager.add((StandardTank)this.proteinTank);
        this.inventory = new ReplicatorInventory(this);
        this.setInternalInventory((IInventoryAdapter)this.inventory);
        this.setEnergyPerWorkCycle(200000);
        this.setTicksPerWorkCycle(50);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers((IFluidHandler)this.tankManager, (Container)this, (int)1);
            FluidHelper.drainContainers((IFluidHandler)this.tankManager, (Container)this, (int)2);
        }
    }

    public boolean hasWork() {
        IErrorLogic errors = this.getErrorLogic();
        boolean noDna = errors.setCondition(this.dnaTank.getFluidAmount() < 1000, (IError)GendustryError.NO_DNA);
        boolean noProtein = errors.setCondition(this.proteinTank.getFluidAmount() < 1000, (IError)GendustryError.NO_PROTEIN);
        boolean noTemplate = errors.setCondition(this.inventory.m_8020_(0).m_41619_(), (IError)GendustryError.NO_TEMPLATE);
        return !noDna && !noProtein && !noTemplate;
    }

    protected boolean workCycle() {
        if (!this.inventory.m_8020_(3).m_41619_()) {
            return false;
        }
        ItemStack template = this.inventory.m_8020_(0);
        ISpeciesType<?, ?> speciesType = GeneticTemplateItem.getSpeciesType(template);
        Map<IChromosome<?>, IAllele> alleles = GeneticTemplateItem.getAlleles(template);
        if (speciesType == null) {
            return false;
        }
        this.dnaTank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        this.proteinTank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        IValueAllele speciesAllele = (IValueAllele)alleles.get(speciesType.getKaryotype().getSpeciesChromosome()).cast();
        IIndividual individual = ((ISpecies)speciesAllele.value()).createIndividual(alleles);
        if (individual instanceof IBee) {
            IBee bee = (IBee)individual;
            bee.setPristine(false);
        }
        this.inventory.m_6836_(3, individual.createStack(speciesType.getTypeForMutation(2)));
        return true;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
        return new ReplicatorMenu(windowId, playerInv, this);
    }
}

