/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.blockentity;

import forestry.api.core.ForestryError;
import forestry.api.core.IError;
import forestry.api.core.IErrorLogic;
import forestry.api.genetics.alleles.AllelePair;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.TilePowered;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import thedarkcolour.gendustry.blockentity.IHintTile;
import thedarkcolour.gendustry.blockentity.SamplerInventory;
import thedarkcolour.gendustry.compat.forestry.GendustryError;
import thedarkcolour.gendustry.item.GeneSampleItem;
import thedarkcolour.gendustry.menu.ThreeInputMenu;
import thedarkcolour.gendustry.registry.GBlockEntities;

public class SamplerBlockEntity
extends TilePowered
implements IHintTile {
    private static final int ENERGY_PER_WORK_CYCLE = 20000;
    private static final int TICKS_PER_WORK_CYCLE = 20;
    public static final String HINTS_KEY = "gendustry.sampler";
    private final SamplerInventory inventory = new SamplerInventory(this);

    public SamplerBlockEntity(BlockPos pos, BlockState state) {
        super(GBlockEntities.SAMPLER.tileType(), pos, state, 10000, 100000);
        this.setInternalInventory((IInventoryAdapter)this.inventory);
        this.setTicksPerWorkCycle(20);
        this.setEnergyPerWorkCycle(20000);
    }

    public boolean hasWork() {
        IErrorLogic errors = this.getErrorLogic();
        boolean noSamples = errors.setCondition(this.inventory.m_8020_(1).m_41619_(), (IError)GendustryError.NO_SAMPLES);
        boolean noLabware = errors.setCondition(this.inventory.m_8020_(2).m_41619_(), (IError)GendustryError.NO_LABWARE);
        boolean noSpecimen = errors.setCondition(this.inventory.m_8020_(0).m_41619_(), (IError)ForestryError.NO_SPECIMEN);
        return !noSamples && !noLabware && !noSpecimen;
    }

    protected boolean workCycle() {
        if (!this.inventory.m_8020_(3).m_41619_()) {
            return false;
        }
        ItemStack organism = this.inventory.m_7407_(0, 1);
        this.inventory.m_7407_(2, 1);
        this.inventory.m_7407_(1, 1);
        return IIndividualHandlerItem.filter((ItemStack)organism, individual -> {
            RandomSource random = this.f_58857_.f_46441_;
            Map.Entry randomEntry = (Map.Entry)Util.m_214621_((List)individual.getGenome().getChromosomes().entrySet().asList(), (RandomSource)random);
            AllelePair randomPair = (AllelePair)randomEntry.getValue();
            IAllele chosenAllele = random.m_188499_() ? randomPair.active() : randomPair.inactive();
            this.inventory.m_6836_(3, GeneSampleItem.createStack(individual.getType(), (IChromosome)randomEntry.getKey(), chosenAllele));
            return true;
        });
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
        return ThreeInputMenu.sampler(windowId, playerInv, this);
    }

    @Override
    public String getHintsKey() {
        return HINTS_KEY;
    }
}

