/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.compat.jei;

import forestry.apiculture.compat.MutationRecipe;
import forestry.core.ClientsideCode;
import forestry.core.utils.RecipeUtils;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import thedarkcolour.gendustry.Gendustry;
import thedarkcolour.gendustry.client.screen.MutatronScreen;
import thedarkcolour.gendustry.client.screen.ProducerScreen;
import thedarkcolour.gendustry.compat.jei.GendustryRecipeType;
import thedarkcolour.gendustry.compat.jei.GeneSampleInterpreter;
import thedarkcolour.gendustry.compat.jei.producers.DNAExtractorRecipeCategory;
import thedarkcolour.gendustry.compat.jei.producers.MutagenRecipeCategory;
import thedarkcolour.gendustry.compat.jei.producers.ProducerGuiContainerHandler;
import thedarkcolour.gendustry.compat.jei.producers.ProteinProducerRecipeCategory;
import thedarkcolour.gendustry.registry.GFluids;
import thedarkcolour.gendustry.registry.GItems;
import thedarkcolour.gendustry.registry.GRecipeTypes;

@JeiPlugin
public class GendustryJeiPlugin
implements IModPlugin {
    public static final ResourceLocation ID = Gendustry.loc("jei");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(GItems.GENE_SAMPLE.item(), (IIngredientSubtypeInterpreter)new GeneSampleInterpreter());
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new MutagenRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ProteinProducerRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new DNAExtractorRecipeCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(MutagenRecipeCategory.ICON_STACK, new RecipeType[]{GendustryRecipeType.MUTAGEN_PRODUCER});
        registration.addRecipeCatalyst(DNAExtractorRecipeCategory.ICON_STACK, new RecipeType[]{GendustryRecipeType.DNA_EXTRACTOR});
        registration.addRecipeCatalyst(ProteinProducerRecipeCategory.ICON_STACK, new RecipeType[]{GendustryRecipeType.PROTEIN_LIQUEFIER});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager manager = ClientsideCode.getRecipeManager();
        registration.addRecipes(GendustryRecipeType.MUTAGEN_PRODUCER, RecipeUtils.getRecipes((RecipeManager)manager, GRecipeTypes.MUTAGEN).toList());
        registration.addRecipes(GendustryRecipeType.PROTEIN_LIQUEFIER, RecipeUtils.getRecipes((RecipeManager)manager, GRecipeTypes.PROTEIN).toList());
        registration.addRecipes(GendustryRecipeType.DNA_EXTRACTOR, RecipeUtils.getRecipes((RecipeManager)manager, GRecipeTypes.DNA).toList());
        registration.addIngredientInfo((Object)GFluids.MUTAGEN.fluidStack(1000), (IIngredientType)ForgeTypes.FLUID_STACK, new Component[]{Component.m_237115_((String)"info.gendustry.mutagen")});
        registration.addIngredientInfo((Object)GFluids.LIQUID_DNA.fluidStack(1000), (IIngredientType)ForgeTypes.FLUID_STACK, new Component[]{Component.m_237115_((String)"info.gendustry.dna")});
        registration.addIngredientInfo((Object)GFluids.PROTEIN.fluidStack(1000), (IIngredientType)ForgeTypes.FLUID_STACK, new Component[]{Component.m_237115_((String)"info.gendustry.protein")});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        RecipeType[] mutationTypes = (RecipeType[])registration.getJeiHelpers().getAllRecipeTypes().filter(type -> type.getRecipeClass() == MutationRecipe.class).toArray(RecipeType[]::new);
        registration.addRecipeClickArea(MutatronScreen.class, 68, 38, 55, 18, mutationTypes);
        registration.addGuiContainerHandler(ProducerScreen.class, (IGuiContainerHandler)new ProducerGuiContainerHandler());
    }
}

