/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.data;

import forestry.api.core.IError;
import forestry.api.core.IFeatureSubtype;
import forestry.modules.features.FeatureBlock;
import net.minecraft.world.level.ItemLike;
import thedarkcolour.gendustry.block.GendustryMachineType;
import thedarkcolour.gendustry.compat.forestry.GendustryError;
import thedarkcolour.gendustry.item.EliteGendustryUpgradeType;
import thedarkcolour.gendustry.item.GendustryResourceType;
import thedarkcolour.gendustry.item.GendustryUpgradeType;
import thedarkcolour.gendustry.registry.GBlocks;
import thedarkcolour.gendustry.registry.GFluids;
import thedarkcolour.gendustry.registry.GItems;
import thedarkcolour.modkit.data.MKEnglishProvider;

class English {
    English() {
    }

    static void addTranslations(MKEnglishProvider lang) {
        lang.add("item.gendustry.genetic_template.missing_allele", "MISSING");
        lang.add("item.gendustry.genetic_template.allele_entry", "  %1$s - %2$s");
        lang.add("item.gendustry.genetic_template.allele_count", "Alleles (%1$s/%2$s)");
        lang.add("item.gendustry.upgrade.energy_cost", "Energy Cost: %s RF");
        lang.add("item.gendustry.upgrade.max_count", "Max Count: %s");
        lang.add("gendustry.for.chance", "%s%% chance to be consumed!");
        lang.add("info.gendustry.mutagen", "Mutagen is used in the Mutatron and Advanced Mutatron to trigger mutations between two organisms.");
        lang.add("info.gendustry.dna", "Liquid DNA is used in the Replicator to produce new organisms from complete Genetic Templates.");
        lang.add("info.gendustry.protein", "Protein is used in the Replicator to produce new organisms from complete Genetic Templates.");
        English.addHint(lang, "mutagen_usage", "What's Mutagen for?", "Produce Mutagen to use in other Gendustry machines.");
        English.addHint(lang, "mutagen_ingredients", "What makes Mutagen?", "Mutagen can be made from redstone, glowstone, and even uranium!");
        English.addHint(lang, "dna_usage", "How to use Liquid DNA?", "Use Liquid DNA in the Replicator to construct new organisms!");
        English.addHint(lang, "dna_ingredients", "What makes Liquid DNA?", "Liquid DNA can be made from any organisms with a Forestry genome, like bees, saplings and pollen, and butterflies.");
        English.addHint(lang, "protein_usage", "How to use Protein?", "Protein is an ingredient used by the Replicator to create new organisms.");
        English.addHint(lang, "protein_ingredients", "How to get Protein?", "Protein can be made from any kind of raw meat.");
        English.addHint(lang, "sample_usage", "What are samples for?", "Gene samples can be crafted with a Genetic Template to create a complete genome for use in the Imprinter.");
        English.addHint(lang, "sample_reuse", "Don't throw away samples!", "Unwanted gene samples can be wiped blank by heating them in a furnace.");
        English.addHint(lang, "sample_selection", "How to choose a gene?", "The Sampler picks a random allele from the specimen's genome and saves it to a gene sample.");
        English.addHint(lang, "imprinter_usage", "How to use the Imprinter?", "The Imprinter replaces the genome of an individual with the alleles stored in a Genetic Template. Ignoble stock may not survive.");
        English.addHint(lang, "transposer_usage", "How to use the Genetic Transposer?", "The Genetic Transposer creates copies of Gene Samples and Genetic Templates.");
        English.addHint(lang, "replicator_usage", "How to use the Replicator?", "The Replicator produces a new organism from a Genetic Template using Liquid DNA and Protein.");
        English.addHint(lang, "mutatron_usage", "What is the Mutatron?", "The Mutatron triggers a mutation between two parent organisms, yielding offspring of a new species.");
        English.addHint(lang, "advanced_mutatron", "How to use the Replicator?", "To choose the desired mutation between the two parents, use the Advanced Mutatron.");
        English.addHint(lang, "industrial_apiary", "How to use the Industrial Apiary?", "The left slots are for a Princess and Drone. The four middle slots are for upgrades. The nine right slots are outputs.");
        English.addHint(lang, "industrial_apiary_upgrades", "Why no frames?", "The Industrial Apiary does not need frames. Instead, it uses upgrades that affect climate, productivity, lifespan, and more!");
        lang.add(((FeatureBlock)GBlocks.MACHINE.get((IFeatureSubtype)GendustryMachineType.DNA_EXTRACTOR)).block(), "DNA Extractor");
        lang.add((Object)GFluids.LIQUID_DNA.fluid().getFluidType(), "Liquid DNA");
        lang.add(GItems.GENE_SAMPLE.get(), "Gene Sample (%s)");
        lang.add(GItems.GENETIC_TEMPLATE.get(), "Genetic Template (%s)");
        English.addError(lang, GendustryError.NO_LABWARE, "No Labware", "This machine requires Labware to operate.");
        English.addError(lang, GendustryError.NO_SAMPLES, "No Samples", "This machine requires Blank Gene Samples to operate.");
        English.addError(lang, GendustryError.INCOMPATIBLE_SPECIES, "Incompatible species", "Individuals may only be mated with individuals of the same species type.");
        English.addError(lang, GendustryError.NO_MUTATIONS, "No Mutations", "There are no mutations between these two species. Please choose different species.");
        English.addError(lang, GendustryError.NO_MATES, "No Mates", "Two compatible mates are required for a mutation to occur.");
        English.addError(lang, GendustryError.NO_MUTAGEN, "No Mutagen", "Mutagen is required to trigger a mutation.");
        English.addError(lang, GendustryError.NO_TEMPLATE, "Missing template", "A complete Genetic Template is required to operate.");
        English.addError(lang, GendustryError.NO_SELECTION, "Select a mutation", "You must choose a mutation for the Advanced Mutatron.");
        English.addError(lang, GendustryError.NO_BLANK, "Missing blank template/sample", "The Genetic Transposer needs Blank Gene Samples or Blank Genetic Templates to copy to.");
        English.addError(lang, GendustryError.NO_SOURCE, "Missing source template/sample", "The Genetic Transposer is missing a filled Gene Sample or Genetic Template.");
        English.addError(lang, GendustryError.NO_DNA, "Missing Liquid DNA", "This machine requires Liquid DNA to operate.");
        English.addError(lang, GendustryError.NO_PROTEIN, "Missing Protein", "This machine requires Protein to operate.");
        lang.add("itemGroup.gendustry", "Gendustry");
        lang.add("itemGroup.gene_samples", "Gene Samples");
        English.addTooltip(lang, (ItemLike)GItems.RESOURCE.get((IFeatureSubtype)GendustryResourceType.BLANK_GENETIC_TEMPLATE), "Combine with Gene Samples in a Crafting Table");
        English.addTooltip(lang, (ItemLike)GItems.RESOURCE.get((IFeatureSubtype)GendustryResourceType.BLANK_GENE_SAMPLE), "Use in the Sampler to obtain Gene Samples");
        English.addTooltip(lang, (ItemLike)GItems.UPGRADE.get((IFeatureSubtype)GendustryUpgradeType.AUTOMATION), "Automatically recycles princesses and drones from deceased queens.");
        English.addTooltip(lang, (ItemLike)GItems.UPGRADE.get((IFeatureSubtype)GendustryUpgradeType.HEATER), "Raises the temperature of the apiary by 1 step.");
        English.addTooltip(lang, (ItemLike)GItems.UPGRADE.get((IFeatureSubtype)GendustryUpgradeType.COOLER), "Lowers the temperature of the apiary by 1 step.");
        English.addTooltip(lang, (ItemLike)GItems.UPGRADE.get((IFeatureSubtype)GendustryUpgradeType.HUMIDIFIER), "Raises the humidity of the apiary by 1 step.");
        English.addTooltip(lang, (ItemLike)GItems.UPGRADE.get((IFeatureSubtype)GendustryUpgradeType.DRYER), "Lowers the humidity of the apiary by 1 step.");
        English.addTooltip(lang, (ItemLike)GItems.UPGRADE.get((IFeatureSubtype)GendustryUpgradeType.POLLINATION), "Increases bee pollination by 25%.");
        English.addTooltip(lang, (ItemLike)GItems.UPGRADE.get((IFeatureSubtype)GendustryUpgradeType.SCRUBBER), "Disables bee pollination.");
        English.addTooltip(lang, (ItemLike)GItems.UPGRADE.get((IFeatureSubtype)GendustryUpgradeType.NETHER), "Sets the apiary's climate to Hellish temperature and Arid humidity.");
        English.addTooltip(lang, (ItemLike)GItems.UPGRADE.get((IFeatureSubtype)GendustryUpgradeType.LIFESPAN), "Decreases lifespan by 20%.");
        English.addTooltip(lang, (ItemLike)GItems.UPGRADE.get((IFeatureSubtype)GendustryUpgradeType.LIGHTING), "Allows bees to work without needing to sleep.");
        English.addTooltip(lang, (ItemLike)GItems.UPGRADE.get((IFeatureSubtype)GendustryUpgradeType.PRODUCTIVITY), "Increases bee productivity by 25%.");
        English.addTooltip(lang, (ItemLike)GItems.UPGRADE.get((IFeatureSubtype)GendustryUpgradeType.WEATHERPROOF), "Allows bees to work during the rain.");
        English.addTooltip(lang, (ItemLike)GItems.UPGRADE.get((IFeatureSubtype)GendustryUpgradeType.SIEVE), "Automatically recycles princesses and drones from deceased queens.");
        English.addTooltip(lang, (ItemLike)GItems.UPGRADE.get((IFeatureSubtype)GendustryUpgradeType.SKY), "Simulates a view of the sky for bees that aren't cave dwelling.");
        English.addTooltip(lang, (ItemLike)GItems.UPGRADE.get((IFeatureSubtype)GendustryUpgradeType.STABILIZER), "Prevents Ignoble Stock bees from dying.");
        English.addTooltip(lang, (ItemLike)GItems.UPGRADE.get((IFeatureSubtype)GendustryUpgradeType.TERRITORY), "Increases territory by 25%.");
        English.addTooltip(lang, (ItemLike)GItems.ELITE_UPGRADE.get((IFeatureSubtype)EliteGendustryUpgradeType.MUTATION), "Increases bee mutation chances by 25%.");
        English.addTooltip(lang, (ItemLike)GItems.ELITE_UPGRADE.get((IFeatureSubtype)EliteGendustryUpgradeType.ACTIVITY_SIMULATOR), "A combination of the Sky, Weatherproof, and Lighting upgrades.");
        English.addTooltip(lang, (ItemLike)GItems.ELITE_UPGRADE.get((IFeatureSubtype)EliteGendustryUpgradeType.PRODUCTIVITY), "Increases bee productivity by 25% and speeds up work cycle by 15 ticks.");
        English.addTooltip(lang, (ItemLike)GItems.ELITE_UPGRADE.get((IFeatureSubtype)EliteGendustryUpgradeType.TERRITORY), "Increases bee territory by 25%, but has a higher limit.");
        English.addTooltip(lang, (ItemLike)GItems.ELITE_UPGRADE.get((IFeatureSubtype)EliteGendustryUpgradeType.YOUTH), "Increases lifespan by 20%.");
        English.addTooltip(lang, (ItemLike)GItems.ELITE_UPGRADE.get((IFeatureSubtype)EliteGendustryUpgradeType.FERTILITY), "Increases fertility count by 1.");
    }

    private static void addHint(MKEnglishProvider lang, String hint, String title, String description) {
        lang.add("for.hints." + hint + ".tag", title);
        lang.add("for.hints." + hint + ".desc", description);
    }

    private static void addError(MKEnglishProvider lang, IError error, String title, String description) {
        String path = error.getId().m_135815_();
        String namespace = error.getId().m_135827_();
        String combined = namespace + "." + path;
        lang.add("errors." + combined + ".desc", title);
        lang.add("errors." + combined + ".help", description);
    }

    private static void addTooltip(MKEnglishProvider lang, ItemLike item, String tooltip) {
        lang.add(item.m_5456_().m_5524_() + ".tooltip", tooltip);
    }
}

