/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.data;

import forestry.api.ForestryConstants;
import forestry.api.ForestryTags;
import forestry.api.IForestryApi;
import forestry.api.apiculture.genetics.BeeLifeStage;
import forestry.api.arboriculture.genetics.TreeLifeStage;
import forestry.api.core.IFeatureSubtype;
import forestry.api.core.IItemSubtype;
import forestry.api.genetics.ForestrySpeciesTypes;
import forestry.api.genetics.ILifeStage;
import forestry.api.lepidopterology.genetics.ButterflyLifeStage;
import forestry.modules.features.FeatureItem;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import thedarkcolour.gendustry.Gendustry;
import thedarkcolour.gendustry.block.GendustryMachineType;
import thedarkcolour.gendustry.item.EliteGendustryUpgradeType;
import thedarkcolour.gendustry.item.GendustryResourceType;
import thedarkcolour.gendustry.item.GendustryUpgradeType;
import thedarkcolour.gendustry.recipe.DnaFinishedRecipe;
import thedarkcolour.gendustry.recipe.MutagenFinishedRecipe;
import thedarkcolour.gendustry.recipe.ProteinFinishedRecipe;
import thedarkcolour.gendustry.registry.GBlocks;
import thedarkcolour.gendustry.registry.GFluids;
import thedarkcolour.gendustry.registry.GItems;
import thedarkcolour.gendustry.registry.GRecipeTypes;
import thedarkcolour.modkit.data.MKRecipeProvider;

class Recipes {
    private static final RegistryObject<Item> SILK_WISP = RegistryObject.create((ResourceLocation)ForestryConstants.forestry((String)"silk_wisp"), (IForgeRegistry)ForgeRegistries.ITEMS);
    private static final RegistryObject<Item> BEESWAX = RegistryObject.create((ResourceLocation)ForestryConstants.forestry((String)"beeswax"), (IForgeRegistry)ForgeRegistries.ITEMS);
    private static final RegistryObject<Item> ROYAL_JELLY = RegistryObject.create((ResourceLocation)ForestryConstants.forestry((String)"royal_jelly"), (IForgeRegistry)ForgeRegistries.ITEMS);
    private static final RegistryObject<Item> POLLEN_CLUSTER = RegistryObject.create((ResourceLocation)ForestryConstants.forestry((String)"pollen_cluster_normal"), (IForgeRegistry)ForgeRegistries.ITEMS);
    private static final RegistryObject<Item> STURDY_CASING = RegistryObject.create((ResourceLocation)ForestryConstants.forestry((String)"sturdy_machine"), (IForgeRegistry)ForgeRegistries.ITEMS);

    Recipes() {
    }

    static void addRecipes(Consumer<FinishedRecipe> writer, MKRecipeProvider recipes) {
        recipes.special("combine_genetic_template", GRecipeTypes.GENETIC_TEMPLATE_SERIALIZER);
        Recipes.mutagen(writer, Items.f_42451_, 100);
        Recipes.mutagen(writer, Items.f_42525_, 200);
        Recipes.mutagen(writer, Items.f_42054_, 800);
        Recipes.mutagen(writer, Items.f_42153_, 900);
        Recipes.protein(writer, Items.f_42485_, 500);
        Recipes.protein(writer, Items.f_42579_, 500);
        Recipes.protein(writer, Items.f_42697_, 250);
        Recipes.protein(writer, Items.f_42526_, 250);
        Recipes.protein(writer, Items.f_42527_, 250);
        Recipes.protein(writer, Items.f_42529_, 250);
        Recipes.protein(writer, Items.f_42528_, 250);
        Recipes.dna(writer, ForestrySpeciesTypes.BEE, (ILifeStage)BeeLifeStage.DRONE, 100);
        Recipes.dna(writer, ForestrySpeciesTypes.BEE, (ILifeStage)BeeLifeStage.PRINCESS, 500);
        Recipes.dna(writer, ForestrySpeciesTypes.BEE, (ILifeStage)BeeLifeStage.QUEEN, 600);
        Recipes.dna(writer, ForestrySpeciesTypes.BEE, (ILifeStage)BeeLifeStage.LARVAE, 300);
        Recipes.dna(writer, ForestrySpeciesTypes.TREE, (ILifeStage)TreeLifeStage.SAPLING, 100);
        Recipes.dna(writer, ForestrySpeciesTypes.TREE, (ILifeStage)TreeLifeStage.POLLEN, 400);
        Recipes.dna(writer, ForestrySpeciesTypes.BUTTERFLY, (ILifeStage)ButterflyLifeStage.BUTTERFLY, 200);
        Recipes.dna(writer, ForestrySpeciesTypes.BUTTERFLY, (ILifeStage)ButterflyLifeStage.SERUM, 800);
        Recipes.dna(writer, ForestrySpeciesTypes.BUTTERFLY, (ILifeStage)ButterflyLifeStage.CATERPILLAR, 1000);
        Recipes.dna(writer, ForestrySpeciesTypes.BUTTERFLY, (ILifeStage)ButterflyLifeStage.COCOON, 1000);
        Recipes.resourceCraftingRecipes(recipes);
        Recipes.upgradeCraftingRecipes(recipes);
        Recipes.eliteUpgradeCraftingRecipes(recipes);
        Recipes.machineCraftingRecipes(recipes);
        recipes.shapelessCrafting(RecipeCategory.TOOLS, GItems.POLLEN_KIT, 1, new Object[]{GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.LABWARE), Tags.Items.STRING, Items.f_42516_});
    }

    private static void resourceCraftingRecipes(MKRecipeProvider recipes) {
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.LABWARE), 2, recipe -> {
            recipe.define('G', Tags.Items.GLASS_PANES);
            recipe.define('D', Tags.Items.GEMS_DIAMOND);
            recipe.pattern("G G");
            recipe.pattern("G G");
            recipe.pattern(" D ");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.UPGRADE_FRAME), 2, recipe -> {
            recipe.define('I', ForestryTags.Items.INGOTS_TIN);
            recipe.define('R', Tags.Items.DUSTS_REDSTONE);
            recipe.define('G', Tags.Items.NUGGETS_GOLD);
            recipe.pattern("IGI");
            recipe.pattern("R R");
            recipe.pattern("IGI");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.ELITE_UPGRADE_FRAME), 2, recipe -> {
            recipe.define('I', Tags.Items.STORAGE_BLOCKS_GOLD);
            recipe.define('R', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.POWER_MODULE));
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('T', (ItemLike)Items.f_42586_);
            recipe.pattern("ITI");
            recipe.pattern("RGR");
            recipe.pattern("ITI");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.CLIMATE_CONTROL_MODULE), recipe -> {
            recipe.define('R', Tags.Items.DUSTS_REDSTONE);
            recipe.define('B', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.pattern("BRB");
            recipe.pattern("BGB");
            recipe.pattern("BRB");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.POWER_MODULE), recipe -> {
            recipe.define('R', Tags.Items.STORAGE_BLOCKS_REDSTONE);
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('I', Tags.Items.INGOTS_GOLD);
            recipe.define('P', (ItemLike)Items.f_41869_);
            recipe.pattern("GIG");
            recipe.pattern("PRP");
            recipe.pattern("GIG");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.GENETICS_PROCESSOR), recipe -> {
            recipe.define('D', Tags.Items.GEMS_DIAMOND);
            recipe.define('Q', Tags.Items.GEMS_QUARTZ);
            recipe.define('P', Tags.Items.ENDER_PEARLS);
            recipe.pattern("DQD");
            recipe.pattern("QPQ");
            recipe.pattern("DQD");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.ENVIRONMENTAL_PROCESSOR), recipe -> {
            recipe.define('D', Tags.Items.GEMS_DIAMOND);
            recipe.define('Q', Tags.Items.GEMS_LAPIS);
            recipe.define('P', Tags.Items.INGOTS_GOLD);
            recipe.pattern("DQD");
            recipe.pattern("QPQ");
            recipe.pattern("DQD");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.BLANK_GENE_SAMPLE), recipe -> {
            recipe.define('I', ForestryTags.Items.INGOTS_TIN);
            recipe.define('R', Tags.Items.DUSTS_REDSTONE);
            recipe.pattern(" I ");
            recipe.pattern("IRI");
            recipe.pattern(" I ");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.BLANK_GENETIC_TEMPLATE), recipe -> {
            recipe.define('I', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.BLANK_GENE_SAMPLE));
            recipe.define('R', Tags.Items.DUSTS_REDSTONE);
            recipe.define('D', Tags.Items.GEMS_DIAMOND);
            recipe.pattern("RIR");
            recipe.pattern("IDI");
            recipe.pattern("RIR");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.RECEPTACLE), recipe -> {
            recipe.define('I', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('P', Tags.Items.GLASS_PANES);
            recipe.define('G', (ItemLike)Blocks.f_50326_);
            recipe.define('R', Tags.Items.DUSTS_REDSTONE);
            recipe.pattern("III");
            recipe.pattern("IPI");
            recipe.pattern("RGR");
        });
        recipes.renameRecipes(oldId -> oldId.m_266382_("_wipe_dna"), finishedRecipe -> {
            recipes.smelting(GItems.GENE_SAMPLE, (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.BLANK_GENE_SAMPLE), 0.1f);
            recipes.smelting(GItems.GENETIC_TEMPLATE, (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.BLANK_GENETIC_TEMPLATE), 0.1f);
        });
    }

    private static void upgradeCraftingRecipes(MKRecipeProvider recipes) {
        FeatureItem upgradeFrame = (FeatureItem)GItems.RESOURCE.get((IFeatureSubtype)GendustryResourceType.UPGRADE_FRAME);
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.UPGRADE.item((IItemSubtype)GendustryUpgradeType.AUTOMATION), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('R', Tags.Items.DUSTS_REDSTONE);
            recipe.define('C', (ItemLike)Items.f_42351_);
            recipe.pattern(" G ");
            recipe.pattern("RFR");
            recipe.pattern(" C ");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.UPGRADE.item((IItemSubtype)GendustryUpgradeType.HEATER), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('C', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.CLIMATE_CONTROL_MODULE));
            recipe.define('P', (ItemLike)Items.f_42593_);
            recipe.define('I', ForestryTags.Items.INGOTS_BRONZE);
            recipe.pattern("PPP");
            recipe.pattern("IFI");
            recipe.pattern("ICI");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.UPGRADE.item((IItemSubtype)GendustryUpgradeType.COOLER), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('C', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.CLIMATE_CONTROL_MODULE));
            recipe.define('P', (ItemLike)Items.f_41980_);
            recipe.define('I', ForestryTags.Items.INGOTS_BRONZE);
            recipe.pattern("PPP");
            recipe.pattern("IFI");
            recipe.pattern("ICI");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.UPGRADE.item((IItemSubtype)GendustryUpgradeType.HUMIDIFIER), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('C', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.CLIMATE_CONTROL_MODULE));
            recipe.define('P', Tags.Items.MUSHROOMS);
            recipe.define('I', ForestryTags.Items.INGOTS_BRONZE);
            recipe.pattern("PPP");
            recipe.pattern("IFI");
            recipe.pattern("ICI");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.UPGRADE.item((IItemSubtype)GendustryUpgradeType.DRYER), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('C', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.CLIMATE_CONTROL_MODULE));
            recipe.define('P', (ItemLike)Items.f_41866_);
            recipe.define('I', ForestryTags.Items.INGOTS_BRONZE);
            recipe.pattern("PPP");
            recipe.pattern("IFI");
            recipe.pattern("ICI");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.UPGRADE.item((IItemSubtype)GendustryUpgradeType.POLLINATION), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('P', ItemTags.f_13145_);
            recipe.define('I', ForestryTags.Items.INGOTS_BRONZE);
            recipe.pattern("PPP");
            recipe.pattern("IFI");
            recipe.pattern("IGI");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.UPGRADE.item((IItemSubtype)GendustryUpgradeType.SCRUBBER), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('S', (ItemLike)SILK_WISP.get());
            recipe.pattern("SGS");
            recipe.pattern("GFG");
            recipe.pattern("SGS");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.UPGRADE.item((IItemSubtype)GendustryUpgradeType.NETHER), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('C', (ItemLike)Items.f_42488_);
            recipe.define('W', (ItemLike)Items.f_42541_);
            recipe.define('S', (ItemLike)Items.f_42049_);
            recipe.define('I', ForestryTags.Items.INGOTS_BRONZE);
            recipe.pattern("CWS");
            recipe.pattern("IFI");
            recipe.pattern("IGI");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.UPGRADE.item((IItemSubtype)GendustryUpgradeType.LIFESPAN), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('E', (ItemLike)Items.f_41951_);
            recipe.define('I', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('R', Tags.Items.DUSTS_REDSTONE);
            recipe.pattern("ERE");
            recipe.pattern("RFR");
            recipe.pattern("IGI");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.UPGRADE.item((IItemSubtype)GendustryUpgradeType.LIGHTING), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('D', (ItemLike)Items.f_42054_);
            recipe.define('I', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('R', Tags.Items.DUSTS_REDSTONE);
            recipe.pattern("DRD");
            recipe.pattern("RFR");
            recipe.pattern("IGI");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.UPGRADE.item((IItemSubtype)GendustryUpgradeType.PRODUCTIVITY), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('D', Tags.Items.GEMS_EMERALD);
            recipe.define('I', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('R', Tags.Items.DUSTS_REDSTONE);
            recipe.pattern("DRD");
            recipe.pattern("RFR");
            recipe.pattern("IGI");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.UPGRADE.item((IItemSubtype)GendustryUpgradeType.WEATHERPROOF), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('D', BEESWAX);
            recipe.define('I', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('R', Tags.Items.DUSTS_REDSTONE);
            recipe.pattern("DRD");
            recipe.pattern("RFR");
            recipe.pattern("IGI");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.UPGRADE.item((IItemSubtype)GendustryUpgradeType.SIEVE), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('S', (ItemLike)SILK_WISP.get());
            recipe.define('I', ForestryTags.Items.INGOTS_BRONZE);
            recipe.pattern("SSS");
            recipe.pattern("SFS");
            recipe.pattern("IGI");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.UPGRADE.item((IItemSubtype)GendustryUpgradeType.SKY), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('L', Tags.Items.GEMS_LAPIS);
            recipe.define('I', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.pattern("LLL");
            recipe.pattern("IFI");
            recipe.pattern("IGI");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.UPGRADE.item((IItemSubtype)GendustryUpgradeType.STABILIZER), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('I', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('R', Tags.Items.DUSTS_REDSTONE);
            recipe.define('P', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.GENETICS_PROCESSOR));
            recipe.pattern("RPR");
            recipe.pattern("RFR");
            recipe.pattern("GIG");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.UPGRADE.item((IItemSubtype)GendustryUpgradeType.TERRITORY), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('R', Tags.Items.DUSTS_REDSTONE);
            recipe.define('B', (ItemLike)Items.f_42276_);
            recipe.pattern("RBR");
            recipe.pattern("BFB");
            recipe.pattern("RGR");
        });
    }

    private static void eliteUpgradeCraftingRecipes(MKRecipeProvider recipes) {
        FeatureItem upgradeFrame = (FeatureItem)GItems.RESOURCE.get((IFeatureSubtype)GendustryResourceType.ELITE_UPGRADE_FRAME);
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.ELITE_UPGRADE.item((IItemSubtype)EliteGendustryUpgradeType.MUTATION), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('P', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.GENETICS_PROCESSOR));
            recipe.define('D', (ItemLike)GFluids.LIQUID_DNA.getBucket());
            recipe.define('M', (ItemLike)GFluids.MUTAGEN.getBucket());
            recipe.define('R', Tags.Items.DUSTS_REDSTONE);
            recipe.pattern("RMR");
            recipe.pattern("PFP");
            recipe.pattern("RDR");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.ELITE_UPGRADE.item((IItemSubtype)EliteGendustryUpgradeType.ACTIVITY_SIMULATOR), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('S', (ItemLike)GItems.UPGRADE.item((IItemSubtype)GendustryUpgradeType.SKY));
            recipe.define('W', (ItemLike)GItems.UPGRADE.item((IItemSubtype)GendustryUpgradeType.WEATHERPROOF));
            recipe.define('L', (ItemLike)GItems.UPGRADE.item((IItemSubtype)GendustryUpgradeType.LIGHTING));
            recipe.define('R', Tags.Items.DUSTS_REDSTONE);
            recipe.define('I', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.pattern("RWR");
            recipe.pattern("LFS");
            recipe.pattern("IGI");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.ELITE_UPGRADE.item((IItemSubtype)EliteGendustryUpgradeType.PRODUCTIVITY), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('D', Tags.Items.GEMS_EMERALD);
            recipe.define('C', POLLEN_CLUSTER);
            recipe.define('R', ROYAL_JELLY);
            recipe.pattern("DRD");
            recipe.pattern("RFR");
            recipe.pattern("CGC");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.ELITE_UPGRADE.item((IItemSubtype)EliteGendustryUpgradeType.TERRITORY), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('R', Tags.Items.DUSTS_REDSTONE);
            recipe.define('B', (ItemLike)Items.f_42276_);
            recipe.pattern("RBR");
            recipe.pattern("BFB");
            recipe.pattern("RGR");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.ELITE_UPGRADE.item((IItemSubtype)EliteGendustryUpgradeType.YOUTH), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('T', (ItemLike)Items.f_42586_);
            recipe.define('R', Tags.Items.DUSTS_REDSTONE);
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('I', ForestryTags.Items.INGOTS_BRONZE);
            recipe.pattern("TRT");
            recipe.pattern("RFR");
            recipe.pattern("IGI");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GItems.ELITE_UPGRADE.item((IItemSubtype)EliteGendustryUpgradeType.FERTILITY), recipe -> {
            recipe.define('F', (ItemLike)upgradeFrame);
            recipe.define('P', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.GENETICS_PROCESSOR));
            recipe.define('D', (ItemLike)GFluids.LIQUID_DNA.getBucket());
            recipe.define('M', (ItemLike)GFluids.PROTEIN.getBucket());
            recipe.define('R', Tags.Items.DUSTS_REDSTONE);
            recipe.pattern("RMR");
            recipe.pattern("PFP");
            recipe.pattern("RDR");
        });
    }

    private static void machineCraftingRecipes(MKRecipeProvider recipes) {
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GBlocks.MACHINE.get((IFeatureSubtype)GendustryMachineType.INDUSTRIAL_APIARY), recipe -> {
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('C', Tags.Items.GLASS);
            recipe.define('S', STURDY_CASING);
            recipe.define('P', (ItemLike)Items.f_41869_);
            recipe.define('R', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.RECEPTACLE));
            recipe.pattern("CRC");
            recipe.pattern("CSC");
            recipe.pattern("GPG");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GBlocks.MACHINE.get((IFeatureSubtype)GendustryMachineType.MUTAGEN_PRODUCER), recipe -> {
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('I', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('C', (ItemLike)Items.f_42544_);
            recipe.define('S', STURDY_CASING);
            recipe.define('H', (ItemLike)Items.f_42155_);
            recipe.define('P', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.POWER_MODULE));
            recipe.pattern("IHI");
            recipe.pattern("PSP");
            recipe.pattern("GCG");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GBlocks.MACHINE.get((IFeatureSubtype)GendustryMachineType.DNA_EXTRACTOR), recipe -> {
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('S', STURDY_CASING);
            recipe.define('H', (ItemLike)Items.f_42155_);
            recipe.define('P', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.POWER_MODULE));
            recipe.define('D', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.GENETICS_PROCESSOR));
            recipe.pattern("GHG");
            recipe.pattern("DSD");
            recipe.pattern("GPG");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GBlocks.MACHINE.get((IFeatureSubtype)GendustryMachineType.PROTEIN_LIQUEFIER), recipe -> {
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('S', STURDY_CASING);
            recipe.define('H', (ItemLike)Items.f_42155_);
            recipe.define('P', (ItemLike)Items.f_41869_);
            recipe.define('M', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.POWER_MODULE));
            recipe.pattern("GHG");
            recipe.pattern("PSP");
            recipe.pattern("GMG");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GBlocks.MACHINE.get((IFeatureSubtype)GendustryMachineType.SAMPLER), recipe -> {
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('S', STURDY_CASING);
            recipe.define('H', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.GENETICS_PROCESSOR));
            recipe.define('P', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.RECEPTACLE));
            recipe.define('M', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.POWER_MODULE));
            recipe.define('D', Tags.Items.GEMS_DIAMOND);
            recipe.pattern("GHG");
            recipe.pattern("PSD");
            recipe.pattern("GMG");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GBlocks.MACHINE.get((IFeatureSubtype)GendustryMachineType.MUTATRON), recipe -> {
            recipe.define('I', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('S', STURDY_CASING);
            recipe.define('H', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.GENETICS_PROCESSOR));
            recipe.define('R', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.RECEPTACLE));
            recipe.define('M', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.POWER_MODULE));
            recipe.define('C', (ItemLike)Items.f_42544_);
            recipe.pattern("RHI");
            recipe.pattern("MSR");
            recipe.pattern("RCI");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GBlocks.MACHINE.get((IFeatureSubtype)GendustryMachineType.ADVANCED_MUTATRON), recipe -> {
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('S', (ItemLike)GBlocks.MACHINE.get((IFeatureSubtype)GendustryMachineType.MUTATRON));
            recipe.define('H', Tags.Items.GEMS_QUARTZ);
            recipe.define('P', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.GENETICS_PROCESSOR));
            recipe.define('M', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.POWER_MODULE));
            recipe.pattern("GHG");
            recipe.pattern("PSP");
            recipe.pattern("GMG");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GBlocks.MACHINE.get((IFeatureSubtype)GendustryMachineType.IMPRINTER), recipe -> {
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('S', STURDY_CASING);
            recipe.define('H', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.GENETICS_PROCESSOR));
            recipe.define('R', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.RECEPTACLE));
            recipe.define('M', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.POWER_MODULE));
            recipe.pattern("GHG");
            recipe.pattern("RSR");
            recipe.pattern("GMG");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GBlocks.MACHINE.get((IFeatureSubtype)GendustryMachineType.GENETIC_TRANSPOSER), recipe -> {
            recipe.define('I', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('S', STURDY_CASING);
            recipe.define('H', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.GENETICS_PROCESSOR));
            recipe.define('M', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.POWER_MODULE));
            recipe.pattern("GIG");
            recipe.pattern("HSH");
            recipe.pattern("GMG");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)GBlocks.MACHINE.get((IFeatureSubtype)GendustryMachineType.REPLICATOR), recipe -> {
            recipe.define('G', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('S', STURDY_CASING);
            recipe.define('H', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.GENETICS_PROCESSOR));
            recipe.define('M', (ItemLike)GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.POWER_MODULE));
            recipe.pattern("GHG");
            recipe.pattern("MSM");
            recipe.pattern("GHG");
        });
    }

    private static void mutagen(Consumer<FinishedRecipe> writer, Item input, int mutagen) {
        writer.accept(new MutagenFinishedRecipe(Gendustry.loc("mutagen/" + MKRecipeProvider.path((ItemLike)input)), Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), mutagen));
    }

    private static void protein(Consumer<FinishedRecipe> writer, Item input, int protein) {
        writer.accept(new ProteinFinishedRecipe(Gendustry.loc("protein/" + MKRecipeProvider.path((ItemLike)input)), Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), protein));
    }

    private static void dna(Consumer<FinishedRecipe> writer, ResourceLocation speciesType, ILifeStage input, int dna) {
        writer.accept(new DnaFinishedRecipe(Gendustry.loc("dna/" + input.m_7912_()), IForestryApi.INSTANCE.getGeneticManager().getSpeciesType(speciesType), input, dna));
    }
}

