/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.item;

import forestry.api.IForestryApi;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IChromosome;
import forestry.core.render.ColourProperties;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.gendustry.item.SpeciesTypeItem;
import thedarkcolour.gendustry.registry.GItems;

public class GeneSampleItem
extends SpeciesTypeItem {
    public static final String NBT_CHROMOSOME = "chromosome";
    public static final String NBT_ALLELE = "allele";

    public GeneSampleItem() {
        super(new Item.Properties().m_41497_(Rarity.UNCOMMON));
    }

    public static ItemStack createStack(ISpeciesType<?, ?> speciesType, IChromosome<?> chromosome, IAllele allele) {
        ItemStack stack = new ItemStack(GItems.GENE_SAMPLE);
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128359_("speciesType", speciesType.id().toString());
        nbt.m_128359_(NBT_CHROMOSOME, chromosome.id().toString());
        nbt.m_128359_(NBT_ALLELE, allele.alleleId().toString());
        return stack;
    }

    @Nullable
    public static IChromosome<?> getChromosome(ItemStack stack) {
        ResourceLocation location;
        if (stack.m_41782_() && (location = ResourceLocation.m_135820_((String)stack.m_41783_().m_128461_(NBT_CHROMOSOME))) != null) {
            return IForestryApi.INSTANCE.getAlleleManager().getChromosome(location);
        }
        return null;
    }

    @Nullable
    public static IAllele getAllele(ItemStack stack) {
        ResourceLocation location;
        if (stack.m_41782_() && (location = ResourceLocation.m_135820_((String)stack.m_41783_().m_128461_(NBT_ALLELE))) != null) {
            return IForestryApi.INSTANCE.getAlleleManager().getAllele(location);
        }
        return null;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag pIsAdvanced) {
        IChromosome<?> chromosome = GeneSampleItem.getChromosome(stack);
        if (chromosome == null) {
            return;
        }
        IAllele allele = GeneSampleItem.getAllele(stack);
        if (allele == null) {
            return;
        }
        tooltip.add((Component)chromosome.getChromosomeDisplayName().m_130946_(" - ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)chromosome.getDisplayName(allele.cast()).m_130938_(style -> style.m_178520_(GeneSampleItem.getColorCoding(allele.dominant())))));
    }

    public static int getColorCoding(boolean dominant) {
        if (dominant) {
            return ColourProperties.INSTANCE.get("gui.beealyzer.dominant");
        }
        return ColourProperties.INSTANCE.get("gui.beealyzer.recessive");
    }
}

