/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.item;

import com.google.common.collect.ImmutableList;
import forestry.api.IForestryApi;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IAlleleManager;
import forestry.api.genetics.alleles.IChromosome;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.gendustry.item.GeneSampleItem;
import thedarkcolour.gendustry.item.SpeciesTypeItem;

public class GeneticTemplateItem
extends SpeciesTypeItem {
    public static final String NBT_ALLELES = "alleles";

    public GeneticTemplateItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE));
    }

    public static void addAlleles(ItemStack template, Map<IChromosome<?>, IAllele> samples) {
        CompoundTag nbt = template.m_41698_(NBT_ALLELES);
        samples.forEach((chromosome, allele) -> nbt.m_128359_(chromosome.id().toString(), allele.alleleId().toString()));
    }

    public static Map<IChromosome<?>, IAllele> getAlleles(ItemStack template) {
        CompoundTag nbt = template.m_41737_(NBT_ALLELES);
        if (nbt == null) {
            return Map.of();
        }
        IdentityHashMap alleles = new IdentityHashMap(nbt.m_128440_());
        IAlleleManager manager = IForestryApi.INSTANCE.getAlleleManager();
        for (String key : nbt.m_128431_()) {
            IAllele allele;
            ResourceLocation alleleId;
            IChromosome chromosome;
            ResourceLocation chromosomeId = ResourceLocation.m_135820_((String)key);
            if (chromosomeId == null || (chromosome = manager.getChromosome(chromosomeId)) == null || (alleleId = ResourceLocation.m_135820_((String)nbt.m_128461_(key))) == null || (allele = manager.getAllele(alleleId)) == null) continue;
            alleles.put(chromosome, allele);
        }
        return alleles;
    }

    public static boolean isComplete(ItemStack stack) {
        ISpeciesType<?, ?> speciesType = GeneticTemplateItem.getSpeciesType(stack);
        Map<IChromosome<?>, IAllele> alleles = GeneticTemplateItem.getAlleles(stack);
        return speciesType != null && speciesType.getKaryotype().size() == alleles.size();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        ISpeciesType<?, ?> speciesType = GeneticTemplateItem.getSpeciesType(stack);
        if (speciesType == null) {
            return;
        }
        ImmutableList chromosomes = speciesType.getKaryotype().getChromosomes();
        Map<IChromosome<?>, IAllele> alleles = GeneticTemplateItem.getAlleles(stack);
        int countIndex = tooltip.size();
        int totalAlleles = chromosomes.size();
        int foundAlleles = 0;
        for (IChromosome chromosome : chromosomes) {
            IAllele allele = alleles.get(chromosome);
            MutableComponent chromosomeName = chromosome.getChromosomeDisplayName();
            if (allele == null) {
                tooltip.add((Component)Component.m_237110_((String)"item.gendustry.genetic_template.allele_entry", (Object[])new Object[]{chromosomeName, Component.m_237115_((String)"item.gendustry.genetic_template.missing_allele").m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.GRAY));
                continue;
            }
            MutableComponent alleleName = chromosome.getDisplayName(allele.cast()).m_130938_(style -> style.m_178520_(GeneSampleItem.getColorCoding(allele.dominant())));
            tooltip.add((Component)Component.m_237110_((String)"item.gendustry.genetic_template.allele_entry", (Object[])new Object[]{chromosomeName, alleleName}).m_130940_(ChatFormatting.GRAY));
            ++foundAlleles;
        }
        tooltip.add(countIndex, (Component)Component.m_237110_((String)"item.gendustry.genetic_template.allele_count", (Object[])new Object[]{foundAlleles, totalAlleles}).m_130940_(ChatFormatting.GRAY));
    }
}

