/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.menu;

import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpecies;
import forestry.core.tiles.TileUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.gendustry.blockentity.AbstractMutatronBlockEntity;
import thedarkcolour.gendustry.blockentity.AdvancedMutatronBlockEntity;
import thedarkcolour.gendustry.menu.AbstractMutatronMenu;
import thedarkcolour.gendustry.registry.GMenus;

public class AdvancedMutatronMenu
extends AbstractMutatronMenu<AdvancedMutatronBlockEntity> {
    public static final int BUTTON_CYCLE_LEFT = 0;
    public static final int BUTTON_CYCLE_RIGHT = 1;
    public static final int CHOICE_CLICKED = 2;
    public final Slot[] choices = new ChoiceSlot[4];
    private final SimpleContainerData data;
    private List<IMutation<ISpecies<?>>> possibilities = List.of();
    private List<ItemStack> icons = List.of();
    @Nullable
    private Runnable dataListener;

    public AdvancedMutatronMenu(int windowId, Inventory playerInventory, AdvancedMutatronBlockEntity tile) {
        super(windowId, GMenus.ADVANCED_MUTATRON.menuType(), playerInventory, tile);
        this.data = new SimpleContainerData(3);
        for (int i = 0; i < 4; ++i) {
            ChoiceSlot choice = new ChoiceSlot(i, 63 + i * 16, 71);
            this.m_38897_(choice);
            this.choices[i] = choice;
        }
        this.m_38884_((ContainerData)this.data);
    }

    public static AdvancedMutatronMenu fromNetwork(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        AdvancedMutatronBlockEntity tile = (AdvancedMutatronBlockEntity)((Object)TileUtil.getTile((BlockGetter)playerInv.f_35978_.m_9236_(), (BlockPos)extraData.m_130135_(), AdvancedMutatronBlockEntity.class));
        return new AdvancedMutatronMenu(windowId, playerInv, Objects.requireNonNull(tile));
    }

    public void m_38946_() {
        List<IMutation<ISpecies<?>>> newPossibilities = ((AdvancedMutatronBlockEntity)this.tile).getPossibilities();
        if (this.possibilities != newPossibilities) {
            int i;
            this.possibilities = newPossibilities;
            IMutation<?> current = ((AdvancedMutatronBlockEntity)this.tile).getCurrentMutation();
            this.setSelected(current == null ? -1 : newPossibilities.indexOf(current));
            this.setOffset(0);
            this.icons = newPossibilities.stream().map(mutation -> {
                ILifeStage stage = mutation.getType().getTypeForMutation(2);
                IIndividual individual = mutation.getResult().createIndividual(AbstractMutatronBlockEntity.createMutatedGenome(mutation));
                return individual.createStack(stage);
            }).toList();
            for (i = 0; i < this.icons.size(); ++i) {
                this.choices[i].m_5852_(this.icons.get(i));
            }
            for (i = this.icons.size(); i < 4; ++i) {
                this.choices[i].m_5852_(ItemStack.f_41583_);
            }
            this.setPossibilityCount(this.possibilities.size());
        }
        super.m_38946_();
    }

    public boolean m_6366_(Player player, int id) {
        int offset = this.getOffset();
        if (this.getPossibilityCount() > 4) {
            if (id == 0) {
                if (offset > 0) {
                    this.setOffset(offset - 1);
                }
            } else if (id == 1 && offset + 4 < this.getPossibilityCount()) {
                this.setOffset(offset + 1);
            }
        }
        if (id >= 2 && id < 6) {
            this.setSelected(offset + id - 2);
        }
        return super.m_6366_(player, id);
    }

    public int getPossibilityCount() {
        return this.data.m_6413_(0);
    }

    public void setPossibilityCount(int possibilityCount) {
        this.data.m_8050_(0, possibilityCount);
    }

    public int getOffset() {
        return this.data.m_6413_(1);
    }

    public void setOffset(int offset) {
        this.data.m_8050_(1, offset);
    }

    public int getSelected() {
        return this.data.m_6413_(2);
    }

    public void setSelected(int selected) {
        this.data.m_8050_(2, selected);
        if (selected >= 0 && !((AdvancedMutatronBlockEntity)this.tile).m_58904_().f_46443_) {
            List<IMutation<ISpecies<?>>> possibilities = ((AdvancedMutatronBlockEntity)this.tile).getPossibilities();
            int choice = this.getSelected() + this.getOffset();
            if (choice < possibilities.size()) {
                ((AdvancedMutatronBlockEntity)this.tile).setCurrentMutation(possibilities.get(choice), ((AdvancedMutatronBlockEntity)this.tile).m_8020_(0), ((AdvancedMutatronBlockEntity)this.tile).m_8020_(1));
            }
        }
    }

    public void setDataListener(Runnable listener) {
        this.dataListener = listener;
    }

    public void m_7511_(int pId, int pData) {
        super.m_7511_(pId, pData);
        if (this.dataListener != null) {
            this.dataListener.run();
        }
    }

    public static class ChoiceSlot
    extends Slot {
        public final int choiceIndex;

        public ChoiceSlot(int choiceIndex, int x, int y) {
            super((Container)new SimpleContainer(1), 0, x, y);
            this.choiceIndex = choiceIndex;
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public boolean m_8010_(Player pPlayer) {
            return false;
        }

        public boolean m_280329_() {
            return false;
        }
    }
}

