/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.recipe;

import forestry.api.core.IItemSubtype;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IChromosome;
import java.util.IdentityHashMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import thedarkcolour.gendustry.item.GendustryResourceType;
import thedarkcolour.gendustry.item.GeneSampleItem;
import thedarkcolour.gendustry.item.GeneticTemplateItem;
import thedarkcolour.gendustry.item.SpeciesTypeItem;
import thedarkcolour.gendustry.registry.GItems;
import thedarkcolour.gendustry.registry.GRecipeTypes;

public class GeneticTemplateRecipe
extends CustomRecipe {
    public GeneticTemplateRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(CraftingContainer container, Level level) {
        boolean hasTemplate = false;
        ISpeciesType<?, ?> speciesType = null;
        int samples = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_(GItems.GENETIC_TEMPLATE.item()) || stack.m_150930_(GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.BLANK_GENETIC_TEMPLATE))) {
                if (hasTemplate) {
                    return false;
                }
                ISpeciesType<?, ?> templateType = SpeciesTypeItem.getSpeciesType(stack);
                if (speciesType != null) {
                    if (speciesType != templateType && templateType != null) {
                        return false;
                    }
                } else {
                    speciesType = templateType;
                }
                hasTemplate = true;
                continue;
            }
            if (!stack.m_150930_(GItems.GENE_SAMPLE.item())) {
                return false;
            }
            ISpeciesType<?, ?> sampleType = SpeciesTypeItem.getSpeciesType(stack);
            if (sampleType == null) {
                return false;
            }
            if (hasTemplate && speciesType != sampleType) {
                if (speciesType != null) return false;
                speciesType = sampleType;
            } else {
                speciesType = sampleType;
            }
            ++samples;
        }
        if (!hasTemplate) return false;
        if (samples == 0) return false;
        return true;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        IdentityHashMap samples = new IdentityHashMap();
        ItemStack template = ItemStack.f_41583_;
        ISpeciesType<?, ?> type = null;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_(GItems.GENE_SAMPLE.item())) {
                IChromosome<?> chromosome = GeneSampleItem.getChromosome(stack);
                IAllele allele = GeneSampleItem.getAllele(stack);
                samples.put(chromosome, allele);
                if (type != null) continue;
                type = SpeciesTypeItem.getSpeciesType(stack);
                continue;
            }
            if (!stack.m_150930_(GItems.GENETIC_TEMPLATE.item()) && !stack.m_150930_(GItems.RESOURCE.item((IItemSubtype)GendustryResourceType.BLANK_GENETIC_TEMPLATE))) continue;
            if (!template.m_41619_()) {
                return ItemStack.f_41583_;
            }
            template = stack;
        }
        if (!template.m_41619_() && !samples.isEmpty() && type != null) {
            ItemStack result = template.m_150930_(GItems.GENETIC_TEMPLATE.item()) ? template.m_255036_(1) : new ItemStack(GItems.GENETIC_TEMPLATE);
            SpeciesTypeItem.setSpeciesType(result, type);
            GeneticTemplateItem.addAlleles(result, samples);
            return result;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)GRecipeTypes.GENETIC_TEMPLATE_SERIALIZER.get();
    }
}

