/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.recipe.cache;

import com.google.common.collect.ImmutableList;
import forestry.core.utils.RecipeUtils;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.gendustry.recipe.ProteinRecipe;
import thedarkcolour.gendustry.recipe.cache.IRecipeCache;
import thedarkcolour.gendustry.registry.GRecipeTypes;

public enum ProteinRecipeCache implements IRecipeCache
{
    INSTANCE;

    private IdentityHashMap<Item, ProteinRecipe> simple = new IdentityHashMap();
    private List<ProteinRecipe> complex = List.of();

    @Nullable
    public ProteinRecipe getRecipe(ItemStack stack) {
        ProteinRecipe recipe = this.simple.get(stack.m_41720_());
        if (recipe == null) {
            for (ProteinRecipe r : this.complex) {
                if (!r.getIngredient().test(stack)) continue;
                return r;
            }
        }
        return recipe;
    }

    @Override
    public void reload(RecipeManager recipes) {
        IdentityHashMap simpleBuilder = new IdentityHashMap();
        ImmutableList.Builder complexBuilder = ImmutableList.builder();
        RecipeUtils.getRecipes((RecipeManager)recipes, GRecipeTypes.PROTEIN).forEach(recipe -> {
            Ingredient ingredient = recipe.getIngredient();
            if (ingredient.isSimple()) {
                for (ItemStack stack : ingredient.m_43908_()) {
                    simpleBuilder.put(stack.m_41720_(), recipe);
                }
            } else {
                complexBuilder.add(recipe);
            }
        });
        this.simple = simpleBuilder;
        this.complex = complexBuilder.build();
    }

    @Override
    public void unload() {
        this.simple = new IdentityHashMap();
        this.complex = List.of();
    }
}

