/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.intercompatibility;

import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.permission.PermissionManager;
import de.maxhenkel.voicechat.plugins.impl.VoicechatServerApiImpl;
import de.maxhenkel.voicechat.service.Service;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public abstract class CommonCompatibilityManager {
    public static CommonCompatibilityManager INSTANCE = Service.get(CommonCompatibilityManager.class);

    public abstract String getModVersion();

    public abstract String getModName();

    public abstract Path getGameDirectory();

    public abstract void emitServerVoiceChatConnectedEvent(ServerPlayer var1);

    public abstract void emitServerVoiceChatDisconnectedEvent(UUID var1);

    public abstract void emitPlayerCompatibilityCheckSucceeded(ServerPlayer var1);

    public abstract void onServerVoiceChatConnected(Consumer<ServerPlayer> var1);

    public abstract void onServerVoiceChatDisconnected(Consumer<UUID> var1);

    public abstract void onServerStarting(Consumer<MinecraftServer> var1);

    public abstract void onServerStopping(Consumer<MinecraftServer> var1);

    public abstract void onPlayerLoggedIn(Consumer<ServerPlayer> var1);

    public abstract void onPlayerLoggedOut(Consumer<ServerPlayer> var1);

    public abstract void onPlayerCompatibilityCheckSucceeded(Consumer<ServerPlayer> var1);

    public abstract void onRegisterServerCommands(Consumer<CommandDispatcher<CommandSourceStack>> var1);

    public abstract NetManager getNetManager();

    public abstract boolean isDevEnvironment();

    public abstract boolean isDedicatedServer();

    public abstract boolean isModLoaded(String var1);

    public abstract List<VoicechatPlugin> loadPlugins();

    public abstract PermissionManager createPermissionManager();

    public VoicechatServerApi getServerApi() {
        return VoicechatServerApiImpl.INSTANCE;
    }

    public Object createRawApiEntity(Entity entity) {
        return entity;
    }

    public Object createRawApiPlayer(Player player) {
        return player;
    }

    public Object createRawApiLevel(ServerLevel level) {
        return level;
    }
}

