/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.util.Utils;
import me.shedaniel.clothconfig2.gui.entries.SelectionListEntry;
import net.fabricmc.api.EnvironmentInterface;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import org.dimdev.dimdoors.DimensionalDoors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Config(name="dimdoors")
public final class ModConfig
implements ConfigData {
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="general")
    private General general = new General();
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="pockets")
    private Pockets pockets = new Pockets();
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="world")
    private World world = new World();
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="dungeons")
    private Dungeons dungeons = new Dungeons();
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="monoliths")
    private Monoliths monoliths = new Monoliths();
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="limbo")
    private Limbo limbo = new Limbo();
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="graphics")
    private Graphics graphics = new Graphics();
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="doors")
    private Doors doors = new Doors();
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="decay")
    private Decay decay = new Decay();

    public General getGeneralConfig() {
        return this.general;
    }

    public Pockets getPocketsConfig() {
        return this.pockets;
    }

    public World getWorldConfig() {
        return this.world;
    }

    public Dungeons getDungeonsConfig() {
        return this.dungeons;
    }

    public Monoliths getMonolithsConfig() {
        return this.monoliths;
    }

    public Limbo getLimboConfig() {
        return this.limbo;
    }

    public Graphics getGraphicsConfig() {
        return this.graphics;
    }

    public Doors getDoorsConfig() {
        return this.doors;
    }

    public Decay getDecayConfig() {
        return this.decay;
    }

    public static class General {
        @ConfigEntry.Gui.Tooltip
        public double teleportOffset = 0.0;
        @ConfigEntry.Gui.Tooltip
        public boolean riftBoundingBoxInCreative;
        @ConfigEntry.Gui.Tooltip
        public double riftCloseSpeed = 0.1;
        @ConfigEntry.Gui.Tooltip
        public double riftGrowthSpeed = 1.0;
        @ConfigEntry.Gui.Tooltip
        public boolean enableRiftDecay = true;
        @ConfigEntry.Gui.Tooltip
        public int depthSpreadFactor = 20;
        @ConfigEntry.Gui.Tooltip
        public double endermanSpawnChance = 5.0E-5;
        @ConfigEntry.Gui.Tooltip
        public double endermanAggressiveChance = 0.5;
        @ConfigEntry.Gui.Tooltip
        public boolean enableDebugMessages = false;
    }

    public static class Pockets {
        @ConfigEntry.Gui.Tooltip
        public int pocketGridSize = 32;
        @ConfigEntry.Gui.Tooltip
        public int maxPocketSize = 15;
        @ConfigEntry.Gui.Tooltip
        public int privatePocketSize = 2;
        @ConfigEntry.Gui.Tooltip
        public int publicPocketSize = 1;
        @ConfigEntry.Gui.Tooltip
        public String defaultWeightEquation = "5";
        @ConfigEntry.Gui.Tooltip
        public int fallbackWeight = 5;
        @ConfigEntry.Gui.Tooltip
        public boolean asyncWorldEditPocketLoading = true;
        @ConfigEntry.Gui.Tooltip
        public boolean canUseRiftSignatureInPrivatePockets = true;
    }

    public static class World {
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        public double clusterGenChance = 20000.0;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        public List<String> clusterDimBlacklist = new LinkedList<String>();
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        public List<String> gatewayDimBlacklist = new LinkedList<String>();
    }

    public static class Dungeons {
        @ConfigEntry.Gui.Tooltip
        public int maxDungeonDepth = 50;
    }

    public static class Monoliths {
        @ConfigEntry.Gui.Tooltip
        public boolean dangerousLimboMonoliths = false;
        @ConfigEntry.Gui.Tooltip
        public boolean monolithTeleportation = true;
    }

    public static class Limbo {
        @ConfigEntry.Gui.CollapsibleObject
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        private WorldList worldsLeadingToLimbo = new WorldList();
        @ConfigEntry.Gui.Tooltip
        public boolean hardcoreLimbo = false;
        @ConfigEntry.Gui.Tooltip
        public int limboReturnDistanceMax = 5000;
        @ConfigEntry.Gui.Tooltip
        public int limboReturnDistanceMin = 0;
        @ConfigEntry.Gui.Tooltip
        public boolean decaySurroundings = true;
        @ConfigEntry.Gui.Tooltip
        public boolean tryPlayerBedSpawn = false;
        @ConfigEntry.Gui.Tooltip
        public boolean defaultToWorldSpawn = true;
        @ConfigEntry.Gui.Tooltip
        public float limboBlocksCorruptingExitWorldAmount = 5.0f;
        @ConfigEntry.Gui.Tooltip
        @Nullable
        public ResourceKey<Level> escapeTargetWorld = Level.f_46428_;

        public boolean shouldUseLimbo(ResourceKey<Level> level) {
            return this.worldsLeadingToLimbo.blacklist != this.worldsLeadingToLimbo.list.contains(level.m_135782_().toString());
        }

        public static final class WorldList {
            @ConfigEntry.Gui.Tooltip
            public List<String> list;
            @ConfigEntry.Gui.Tooltip
            public boolean blacklist;

            public WorldList(List<String> list, boolean blacklist) {
                this.list = list;
                this.blacklist = blacklist;
            }

            public WorldList() {
                this(new ArrayList<String>(), false);
            }
        }
    }

    public static class Graphics {
        @ConfigEntry.Gui.Tooltip
        public boolean showRiftCore = false;
        @ConfigEntry.Gui.Tooltip
        public int highlightRiftCoreFor = 15000;
        @ConfigEntry.Gui.Tooltip
        public double riftSize = 1.0;
        @ConfigEntry.Gui.Tooltip
        public double riftJitter = 1.0;
    }

    public static class Doors {
        @ConfigEntry.Gui.Tooltip
        public boolean closeDoorBehind = true;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.CollapsibleObject
        public DoorList doorList = new DoorList();
        @ConfigEntry.Gui.Tooltip
        public boolean placeRiftsInCreativeMode = true;

        public boolean isAllowed(ResourceLocation id) {
            String idStr = id.toString();
            boolean contains = this.doorList.doors.contains(idStr);
            return this.doorList.mode == DoorList.Mode.ENABLE == contains;
        }

        public static class DoorList {
            @ConfigEntry.Gui.Tooltip
            public Mode mode = Mode.DISABLE;
            @ConfigEntry.Gui.Tooltip
            public Set<String> doors = new HashSet<String>();

            @EnvironmentInterface(value=Dist.CLIENT, itf=SelectionListEntry.Translatable.class)
            public static enum Mode implements SelectionListEntry.Translatable
            {
                ENABLE("dimdoors.mode.enable"),
                DISABLE("dimdoors.mode.disable");

                private String translationKey;

                private Mode(String translationKey) {
                    this.translationKey = translationKey;
                }

                @NotNull
                public String getKey() {
                    return this.translationKey;
                }
            }
        }
    }

    public static class Decay {
        @ConfigEntry.Gui.Tooltip
        public double decaySpreadChance = 1.0;
        @ConfigEntry.Gui.Tooltip
        public int decayDelay = 40;
        public boolean decaysIntoAir = true;
    }

    public static final class LevelKeyAdapter
    implements JsonSerializer<ResourceKey<Level>>,
    JsonDeserializer<ResourceKey<Level>> {
        public ResourceKey<Level> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.m_135820_((String)json.getAsJsonPrimitive().getAsString()));
        }

        public JsonElement serialize(ResourceKey<Level> src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.m_135782_().toString());
        }
    }

    public static class SubRootGsonConfigSerializer<T extends ConfigData>
    implements ConfigSerializer<T> {
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(new TypeToken<ResourceKey<Level>>(){}.getType(), (Object)new LevelKeyAdapter()).create();
        private final Config definition;
        private final Class<T> configClass;

        public SubRootGsonConfigSerializer(Config definition, Class<T> configClass) {
            this.definition = definition;
            this.configClass = configClass;
        }

        private Path getConfigPath() {
            return DimensionalDoors.getConfigRoot().resolve(this.definition.name() + "-config.json5");
        }

        public void serialize(T config) throws ConfigSerializer.SerializationException {
            Path configPath = this.getConfigPath();
            try {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);
                writer.write(GSON.toJson(config));
                writer.close();
            }
            catch (IOException e) {
                throw new ConfigSerializer.SerializationException((Throwable)e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public T deserialize() throws ConfigSerializer.SerializationException {
            Path configPath = this.getConfigPath();
            if (!Files.exists(configPath, new LinkOption[0])) return this.createDefault();
            try (BufferedReader reader = Files.newBufferedReader(this.getConfigPath());){
                ConfigData configData = (ConfigData)GSON.fromJson((Reader)reader, this.configClass);
                return (T)configData;
            }
            catch (Throwable e) {
                throw new ConfigSerializer.SerializationException(e);
            }
        }

        public T createDefault() {
            return (T)((ConfigData)Utils.constructUnsafely(this.configClass));
        }
    }
}

