/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.block.entity;

import com.mojang.datafixers.types.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.dimdev.dimdoors.mixin.accessor.BlockEntityTypeAccessor;

public class MutableBlockEntityType<T extends BlockEntity>
extends BlockEntityType<T> {
    public MutableBlockEntityType(BlockEntityFactory<? extends T> factory, Set<Block> blocks, Type<?> type) {
        super(factory, new HashSet<Block>(blocks), type);
    }

    public boolean addBlock(Block block) {
        return MutableBlockEntityType.getBlocks(this).add(block);
    }

    public boolean removeBlock(Block block) {
        return MutableBlockEntityType.getBlocks(this).remove(block);
    }

    public static Set<Block> getBlocks(BlockEntityType<?> type) {
        return ((BlockEntityTypeAccessor)type).getBlocks();
    }

    @FunctionalInterface
    public static interface BlockEntityFactory<T extends BlockEntity>
    extends BlockEntityType.BlockEntitySupplier<T> {
    }

    public static final class Builder<T extends BlockEntity> {
        private final BlockEntityFactory<? extends T> factory;
        private final Set<Block> blocks;

        private Builder(BlockEntityFactory<? extends T> factory, Set<Block> blocks) {
            this.factory = factory;
            this.blocks = blocks;
        }

        public static <T extends BlockEntity> Builder<T> create(BlockEntityFactory<? extends T> factory, Block ... blocks) {
            return new Builder<T>(factory, new HashSet<Block>(Arrays.asList(blocks)));
        }

        public MutableBlockEntityType<T> build() {
            return this.build(null);
        }

        public MutableBlockEntityType<T> build(Type<?> type) {
            return new MutableBlockEntityType<T>(this.factory, this.blocks, type);
        }
    }
}

